#version unofficial megapov 0.7;

#include "cross.inc"

#if (TEXT_FINAL)
  #include "text.inc"
#end

/*
#declare CROSS_FINAL=0;
#declare TEXT_FINAL=1;
*/

#declare stone_int=
interior {
  ior 20
  fade_power 2
  fade_distance .08
  media {
    scattering{ 
      1, rgb 3
    }
    method 2
  }
}

#declare starmarker=
difference {
  union {
    box { <-.3125, 0, 0>, <.3125, 2.5, -.4> }
    prism {
      linear_spline
      0, .5, 3
      <-.5, 0>, <.5, 0>, <0, .866>
      rotate <-90,0,0>
      scale <1.5,1.5,1>
      translate <0,2,0>
    }
    prism {
      linear_spline
      0, .5, 3
      <-.5, .866>, <.5, .866>, <0, 0>
      rotate <-90,0,0>
      scale <1.5,1.5,1>
      translate <0,2-.866/2,0>
    }
  }
  cylinder {
    <0, 2.5, -.6>, <0, 2.3, -.3>, .2
  }
}

#macro makecross(loc, rot, namenum, shape)
difference {
  object {
#if (shape)
    starmarker
#else
    crossmarker
    rotate <-90, 0, 0>
#end
  }

#if(TEXT_FINAL & (namenum!=-1))
  union {
    object {
      line[namenum][0]
      scale .08
      translate <0, 0, -.5001>
      translate <0,2.32,0>
    }
    object {
      line[namenum][1]
      scale .08
      translate <0, 0, -.5001>
      translate <0,2.24,0>
    }
    object {
      line[namenum][2]
      scale .08
      translate <0, 0, -.5001>
      translate <0,2.14,0>
    }
  }
#end

  texture {
    pigment {
      granite
      scale <1,4,1>
      rotate <0,0,-40>
      color_map {
#if (CROSS_FINAL)
  #local filt=.5;
  #local dimm=1;
#else
  #local filt=0;
  #local dimm=.7;
#end
	[0, rgbf <.7, .8, .8, filt>*dimm]
	[.5, rgbf <1, 1, .8, filt>*dimm]
	[1, rgbf <1, 1, 1, filt>*dimm]
      }
    }
    finish {
      reflection 0
    }
    normal {
      granite
      scale .05
      bump_size .05
    }
  }
  hollow
#if (CROSS_FINAL)
  interior {
    stone_int
  }
#end

  rotate rot
  translate loc
}

#end
