package Vector;
require Exporter;
@ISA=qw(Exporter);
@EXPORT=qw(vector cross mag dot);

$PI=atan2(0,-1);

sub vector
{
    return new Vector(@_);
}

sub new
{
    shift;
    return bless [@_];
}

sub show
{
    my @vector=@{$_[0]};
    return join ",",@vector;
}

sub add
{
    my ($v1, $v2)=@_;
    my $vr=new Vector;

    my $i;
    for ($i=0; $i<=$#$v1; $i++) {
	$$vr[$i]=$$v1[$i];
    }

    if (ref $v2 eq "Vector")
    {
	for ($i=0; $i<=$#$v2; $i++) {
	    $$vr[$i]+=$$v2[$i];
	}
    }
    else
    {
	for ($i=0; $i<=$#$vr; $i++) {
	    $$vr[$i]+=$v2;
	}
    }

    return $vr;
}

sub subtract
{
    my ($v1, $v2)=@_;

    if (ref $v2 ne "Vector") {
	return add ($v1, -$v2);
    }
    my $vr=new Vector;
    my $i;
    for ($i=0; $i<=$#$v1; $i++) {
	$$vr[$i]=$$v1[$i];
    }
    for ($i=0; $i<=$#$v2; $i++) {
	$$vr[$i]-=$$v2[$i];
    }
    return $vr;
}

sub multiply
{
    my ($v1, $n2)=@_;
    if (ref $n2 ne "") {
	die "Can't multiply vectors";
    }
    my $vr=new Vector;
    foreach $f (@$v1)
    {
	push @$vr, $f*$n2;
    }
    return $vr;
}

sub divide
{
    my ($v1, $n2)=@_;
    if (ref $n2 ne "") {
	die "Can't divide vectors";
    }
    return multiply($v1, 1/$n2);
}

sub mag
{
    my ($v1)=@_;
    my $res;
    foreach $v (@$v1) {
	$res+=$v**2;
    }
    return sqrt($res);
}

sub dot
{
    my ($v1, $v2)=@_;
    my $res;
    for (my $i=0; $i<@v1; $i++) {
	$res+=$v1[$i]*$v2[$i];
    }
    return sqrt($res);
}

sub cross
{
    my ($v1, $v2)=@_;
    my $v3=new Vector;
    @$v3=(
	$$v1[1]*$$v2[2] - $$v1[2]*$$v2[1],
	-$$v1[0]*$$v2[2] + $$v1[2]*$$v2[0],
	$$v1[0]*$$v2[1] - $$v1[1]*$$v2[0]);
    return $v3;
}

sub rotx
{
    my ($v1, $angle)=@_;
    $angle=-$angle*$PI/180; # use LH coords
    my $v2=new Vector;
    my $ca=cos($angle);
    my $sa=sin($angle);
    $$v2[0]=$$v1[0];
    $$v2[1]=$$v1[1]*$ca+$$v1[2]*$sa;
    $$v2[2]=-$$v1[1]*$sa+$$v1[2]*$ca;
    return $v2;
}

sub roty
{
    my ($v1, $angle)=@_;
    $angle=-$angle*$PI/180; # use LH coords
    my $v2=new Vector;
    my $ca=cos($angle);
    my $sa=sin($angle);
    $$v2[1]=$$v1[1];
    $$v2[0]=$$v1[0]*$ca+$$v1[2]*$sa;
    $$v2[2]=-$$v1[0]*$sa+$$v1[2]*$ca;

    return $v2;
}

use overload '+' => \&add,
	     '-' => \&subtract,
	     '*' => \&multiply,
	     '/' => \&divide,
	     '""' => \&show;

1;
