/*----------------------------------------------------------
Smoke.inc by Johnny Yip  Sept-Oct 2001
Contains all Smoke declarations
----------------------------------------------------------*/
//Some variables
#declare FaintSmokeTurb = 0.3;
#declare MedSmokeTurb = 0.32;
#declare SmokeTurb = 0.35;

//#declare High_Quality = on;

#ifdef (High_Quality)
  #declare Confid = 0.9999;
  #declare Vari = 1/1000;
#else
  #declare Confid = 0.9;
  #declare Vari = 1/128;
#end

//--------------The fainter smoke, close up---------------//
#declare FaintSmokeInterior = interior {
   media {
      //emission <0.01,0,0>
      scattering { 1, <0.11,0.11,0.11> extinction 1 }  //0.08
      #ifdef (High_Quality)
        samples 1,20
      #end
      confidence Confid
      variance Vari
      density {
         spherical
         cubic_wave
         turbulence FaintSmokeTurb
         omega 0.7
         colour_map{
            [0.00 colour rgb 0.0 ]
            [0.10 colour rgb 0.0 ]
            //[0.60 colour rgb 1 ]
            [1.00 colour rgb 1 ]    //0.6
         }
      }
   }
}

#declare FaintSmokeTexture = texture {
   pigment { colour rgbf 1 }
   finish { ambient 0.1 diffuse 0.7 }
}

#declare FaintSmokeMaterial = material {
   texture { FaintSmokeTexture }
   interior { FaintSmokeInterior }
}

//--------------The Medium smoke, close up------------------//
#declare MedSmokeInterior = interior {
   media {
      emission 0.02
      scattering { 3, <0.03,0.03,0.03,> extinction 1 }
      density {
         spherical
         cubic_wave
         turbulence MedSmokeTurb
         omega 0.7
         frequency 1.3
         colour_map{
            [0.00 colour rgb 0 ]
            [0.30 colour rgb 0 ]
            [0.7 colour rgb 0.3 ]
            [1.00 colour rgb 0.3 ]
         }
      }
   }
}

#declare MedSmokeTexture = texture {
   pigment { colour rgbf 1 }
   finish { ambient 0.07 diffuse 0.5 }
}

#declare MedSmokeMaterial = material {
   texture { MedSmokeTexture }
   interior { MedSmokeInterior }
}

//---------------The thicker smoke, at a distance----------//
#declare SmokeInterior = interior {
   media {
     absorption <0.03,0.03,0.03>         //0.02
      scattering { 2, <0.1,0.1,0.1> extinction 1 }    //0.08
      #ifdef (High_Quality)
        samples 1,15
      #end
      confidence Confid
      variance Vari
      density {
         spherical
         turbulence SmokeTurb
         omega 0.7
         colour_map{
            [0.00 colour rgb <0,0,0> ]
            [0.08 colour rgb <0,0,0> ]
            [0.90 colour rgb <1,1,1> ]
            [1.00 colour rgb <1,1,1> ]
            /*[0.00 colour rgb <0,0,0> ]
            [0.25 colour rgb <0,0,0> ]
            [0.60 colour rgb <1,1,1> ]
            [1.00 colour rgb <1,1,1> ]*/
         }
      }
   }
}

#declare SmokeTexture =	texture {
   pigment { colour rgbf 1 }
   finish { ambient 0.1 diffuse 0.7 }
}

#declare SmokeMaterial = material {
   texture { SmokeTexture }
   interior { SmokeInterior }
}

//Testing material
#declare _FaintSmokeMaterial = material {
   texture { pigment { colour rgb 1 } finish {ambient .5}}
}

#declare _MedSmokeMaterial = material {
   texture { pigment { colour rgb <1,1,0> } finish {ambient .5}}
}

#declare _SmokeMaterial = material {
   texture { pigment { colour rgb <1,0,0> } finish {ambient .5}}
}
//----------- Base Object Declaration -------------//
#declare SmokeScale = 40;

#declare FaintSmokeElement = sphere { <0,0,0>, 1
   hollow
   material { FaintSmokeMaterial }
   scale SmokeScale
}

#declare MedSmokeElement = sphere { <0,0,0>, 1
   material { MedSmokeMaterial }
   scale SmokeScale
   hollow
}

#declare HeavySmokeElement = sphere { <0,0,0>, 1
   hollow
   material { SmokeMaterial }
   scale SmokeScale
}

//------------- Smoke Object Declaration --------------//
//Heavy smoke is just another faint smoke group, the interior for Heavy smoke is not used
#declare HeavySmoke = union {
        //object { HeavySmokeElement scale 1.1 rotate <20,40,120> translate <-70,-150,20> }
        //object { HeavySmokeElement scale 1.2 rotate <30,120,53> translate <20,-50,0> }
        
        object { FaintSmokeElement scale 1.2 rotate <126,12,78> translate <85,22,5> }
        //object { FaintSmokeElement scale 1.2 rotate <12,43,12> translate <117,40,90>}
        object { FaintSmokeElement scale 1.1 rotate <50,43,120> translate <105,-5,90>}
        //object { FaintSmokeElement scale 0.74 rotate <62,63,53> translate <100,92,-77>}    //140,122,-95
        object { FaintSmokeElement scale 0.8 rotate <62,63,53> translate <108,109,-77>}    //140,122,-95
        object { FaintSmokeElement scale 1.2 rotate <65,10,41> translate <72,90,-5>}

        //object { HeavySmokeElement scale 0.6 rotate <62,63,53> translate <142,60,-80> }
        //pigment { colour rgbt 1 }
}

#declare MediumSmoke = union {
        //object { MedSmokeElement scale 1.1 rotate <20,40,120> translate <0,-45,0>}
        
        //object { MedSmokeElement scale 1 rotate <30,120,53> translate <60,-5,30>}
        //object { MedSmokeElement scale 1.2 rotate <30,120,53> translate <20,-5,0>}
        
        //object { MedSmokeElement scale 1.2 rotate <126,12,78> translate <65,25,5>}
        object { MedSmokeElement scale 0.8 rotate <65,30,41> translate <15,10,-45>}
        //pigment { colour rgbt 1 }
}
                                                                                                                 
#declare FaintSmoke = union {
        //object { FaintSmokeElement scale 1.0 rotate <20,40,10> translate <20,-150,30> }
        //object { FaintSmokeElement scale 0.9 rotate <30,120,53> translate <30,-20,-0> }
        
        object { FaintSmokeElement scale 1.3 rotate <126,12,78> translate <75,50,55> }//70 50 55
        object { FaintSmokeElement scale 1.3 rotate <65,10,41> translate <50,120,-7> }
        object { FaintSmokeElement scale 1.2 rotate <126,12,78> translate <40,10,-60> }
        //pigment { colour rgbt 1 }
}