#macro drawarc(rad, arc, tubeR) 
object
{
  difference
  {  
    
    object
    {
        difference
        {
            torus
            {
                rad,
                tubeR
            }
       
            box
            {
                <-2*rad-2*tubeR-1,-tubeR-1,0>
                <+2*rad+2*tubeR+1,+tubeR+1,2*rad+2*tubeR+1>    
            } 
            rotate<0,-arc,0>
            
        }
    }
    box
    {
        <-2*rad-2*tubeR-1,-tubeR-1,0>
        <+2*rad+2*tubeR+1,+tubeR+1,-2*rad-2*tubeR-1>    
    } 
  }    

}
#end

#macro doubleArc(rad2,arc2,twist2,
                 rad1,arc1,twist1,
                 tubeR)
object
{
  union
  {
    object
    {
      drawarc(rad1,arc1,tubeR)
//      pigment{Blue}
      translate<-rad1,0,0>
      rotate<0,0,twist1>
      translate<rad2,0,0> 
      rotate<0,-arc2,0>
    }
    
    object
    {
      drawarc(rad2,arc2,tubeR)   
//      pigment{Yellow}
    } 
    translate<-rad2,0,0>
    rotate<0,0,twist2>
    
  }
}
#end

#macro tripleArc(rad3,arc3,twist3,
                 rad1,arc1,twist1,
                 rad2,arc2,twist2,
                 tubeR)
object
{
  union
  {
    object
    {
      doubleArc(rad1,arc1,twist1,rad2,arc2,twist2,tubeR)
      translate<rad3,0,0>
      rotate<0,-arc3,0>
    }
    
    object
    {
      drawarc(rad3,arc3,tubeR)
//      pigment{Red}
    } 
    translate<-rad3,0,0>
    rotate<0,0,twist3>    
  }
}
#end
