#include "colors.inc"
#include "metals.inc"
                     
#declare hiltGold = T_Chrome_1E
                     
#declare za = seed(10);

#macro wireRing(littleR,xx)
object
{
    #declare hiltA = 0.04166667;
    #declare hiltB = -0.3;       
    #declare hiltC = 0.55833333;
    #declare hiltD = 0.45;
    #declare hiltSquash = 0.75;  
    #declare bigR = (((hiltA * xx) + hiltB ) * xx + hiltC ) * xx + hiltD;
    
    torus
    {
      bigR
      littleR
      translate<0,xx,0>   
      texture{T_Chrome_2A}
      normal
      {
        radial 0.6 
        frequency 80  
        scale 0.24   
        rotate -10*rand(za)*y
      }
      scale<1,1,hiltSquash*bigR> 
    }
}
#end

#macro Knob(R,r)
union
{                         
  #declare h = R-r;
  difference
  {
    cylinder { <0,0,0> <0,-h,0> R }
    torus{ R,h }
    scale <1,2,1> 
  }   
  
  
  intersection
  {
    sphere { <0,0,0> R }         
    box { <-4,0,-4> <4,-8,4> }
    translate -2*h*y
    texture{hiltGold}
  }  
  
  scale < 1, 1, hiltSquash*r> 
  texture{hiltGold}
}
#end

#declare Hilt =
union
{
  object
  {
    #declare littleR = 0.05;
    #declare hiltLength = 4;
    #declare jewelR = 0.6;

    #declare xx = littleR;
    
    union
    {
        #while (xx < hiltLength )
              
            wireRing(littleR,xx) 
            #declare xx = xx + 2*littleR;
        
        #end        
    }
          
    rotate<0,0,180>
  }
  object
  {
    Knob(0.8,0.6)
    translate<0,-hiltLength,0>
  }     
}           

#macro Tip(r)
union
{
    sphere
    {
        <0,0,0>
        r
    }

    #declare root3 = sqrt(3);    
    cone
    {
        <0, r*root3/2,0> r/2
        <0,2*r/root3,0> 0
    }
} 
#end

#macro Blade(R,L,r,stretch)
object
{
   union
   {
        Tip(r)
        
        difference
        {
            cone
            { <0, -L, 0> R
              <0,0,0> r
            }
            
            union
            {
                cone
                {
                    <0,-9*L/10,-R> R/2
                    <0,0,-2*r> r/2
                }
                sphere
                {
                    <0,-9*L/10,-R> R/2
                }                        
            }
       }
   }
   translate<0,L,0>  
   scale<1,stretch,0.1>
   //texture{T_Chrome_1E}
   texture{T_Chrome_2C}  
}                 
#end

  
#macro xBar(W,w,r,R,S)
difference
{
  union
  {
    cylinder
    {
      <-W,0,0>
      <W,0,0>
      r
    }
    sphere
    {
      <-W,0,0>
      r
    }
    sphere
    {
      <W,0,0>
      r
    }
  }
  union
  {
    #declare xx = 0;
    #while (xx < 360)
    
      
    cylinder
    {
       <-S,-20,-R-w>
       <-S,20,-R-w>
       R
       rotate xx*x
    }  
    cylinder
    {
       <S,-20,-R-w>
       <S,20,-R-w>
       R
       rotate xx*x
    }  
    cylinder
    {
       <-S,-20,-R-w>
       <-S,20,-R-w>
       R
       rotate (xx+45)*x
    }  
    cylinder
    {
       <S,-20,-R-w>
       <S,20,-R-w>
       R
       rotate (xx+45)*x
    }  
      
    #declare xx = xx + 90;  
    #end
  }
  texture{hiltGold}
  normal
  {
    bump_map 
    {
      tga "BigKnotI.tga"  
      once
      bump_size 2 
      interpolate 
      2
    } 
    translate<-0.5,-0.5,-0.5>
    scale <5,1,1>
  }
}  
#end

  
#declare Sword=
object
{
    union
    {
        object
        {
          Blade(.7,6,0.5,4)
          normal{bump_map{tga "DragonI.tga"once bump_size 2 interpolate 2} translate<-.5,-.5,0> scale 1.3 rotate 180*z translate<0,0.6,0>}
          translate<0,0.225,0>
        }     
        xBar(2.25,.2,.5,8,1) 
        Hilt          
    }
     scale 1.5
     rotate<0,30,-160>
     translate<-5,29,0>
}

