#include "colors.inc"                    

#declare outcrop =
height_field
{
    tga "Rocks.tga"       
    smooth
    translate<-0.5,-0.5,-0.5> 
}

#declare T_Earth =
texture
{ 
  pigment
  {
    bozo  
    turbulence   20
    color_map        
    {
          [ 0 MediumGoldenrod ]
          [ .7 MediumGoldenrod ]
          [ .7 DarkBrown] 
          [ 1 DarkBrown ]
    }
    scale 5
  }
  normal{ bumps bump_size 2 scale 1/10 } 
} 

#declare T_Grass =
texture
{ 
  pigment
  {
    bozo  
    turbulence   .1
    color_map        
    {
          [ 0 ForestGreen ]
          [ 1 GreenYellow ]
    }
    scale <.05,1,1>
  }
} 

#declare T_Land = 
texture
{
  bozo 
  turbulence 1
  texture_map
  {
    [0   T_Earth]
    [1   T_Grass]
  }
}

#declare Earth = 
union
{

  object
  {
    height_field
    {
        tga "land.tga"   
        smooth
        scale <260,27,80>
        translate <-100,4.25,-20>
    } 
    texture{T_Land}
  }
}
 
#declare T_Stone2 =
texture
{
    pigment
    {
        bozo
        pigment_map
        {
            [0 Gray45]
            [1 Gray60]
        }  
        scale .05
    }
    finish{ phong 0 }
    normal{ granite bump_size 3 scale 10 }
}
 
#declare Land = 
union
{
  object
  {
    outcrop 
    rotate 160*z
    scale <50,10,30>  
    rotate -30*z
    texture{T_Stone2}
    rotate 10*y
    translate<-24,23,5>
  }         
  
  object
  {
    outcrop 
    rotate -20*z
    scale <80,12,40>
    rotate -183*z
    rotate 190*y
    rotate -6*x  
    texture
    { 
      gradient y
      texture_map
      {
        [0     T_Land      scale 1/5]
        [0.25  T_Land      scale 1/5]
        [0.4   T_Stone2    scale 1/5]
        [1     T_Stone2    scale 1/5]
      }
      scale 5 
      rotate -2.5*x  
      translate 6*y 
    } 
    translate<-1,11.5,30>
  }      

  object
  {
    outcrop 
    rotate -20*z
    scale <80,12,40>
    rotate -183*z
    rotate 190*y
    rotate -6*x  
    texture
    { 
      gradient y
      texture_map
      {
        [0     T_Land      scale 1/5]
        [0.25  T_Land      scale 1/5]
        [0.4   T_Stone2    scale 1/5]
        [1     T_Stone2    scale 1/5]
      }
      scale 5 
      rotate -2.5*x  
      translate 6*y 
    } 
    translate<-25,14.5,30>
  }
  
  Earth
}












