// POV-Ray ver 3.5 bata
// Satellite weapon Scene File
// By S.Nishimura


#include "coordinate_color.mcr.inc"


//global_settings { assumed_gamma 2.2 }


// CAMERA
camera { location < 0, 0, -200 > 
         look_at 0 
         angle 50 }

// LIGHT
light_source { < 0,  200, -800 > color rgb 0.6 shadowless }
light_source { < 0, -200, -800 > color rgb 0.6 shadowless }

//**********************************************************************************
coordinate_color( 360, 0, 1, 1, 0 ) //coordinate_color( 120, 0.3, 0.5, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
//plane { z, 0 clipped_by { superellipsoid { < 0.24, 0.24 > } scale <1,0.8,1> }
plane { z, 0 clipped_by { box { <-1,-1,-1>,<1,1,1> } scale <0.37,0.26,1> }
 pigment { image_map { png "Beam_first" map_type 0 interpolate 2 once } scale 1.8 translate < -1-0.1, -1+0.1, 0 > }
 finish { diffuse 0.8 }
 scale < 4/3, 1, 1 >*68
 translate <56.5,50,-1e-12>
 //no_shadow
}
//----------------------------------------------------------------------------------
plane { z, 0 clipped_by { box { <-1,-1,-1>,<1,1,1> } scale <0.64,0.26,1> }
 pigment { image_map { png "Beam_second" map_type 0 interpolate 2 once } scale 1.5 translate < -1+0.2, -1+0.2, 0 > }
 finish { diffuse 0.8 }
 scale < 4/3, 1, 1 >*68
 translate <-33,50,0>
 //no_shadow
}
//----------------------------------------------------------------------------------
plane { z, 0 clipped_by { box { <-1,-1,-1>,<1,1,1> } scale <1,0.72,1> }
 pigment { image_map { png "Beam_third" map_type 0 interpolate 2 once } scale 2 translate < -1, -1-0.1, 0 > }
 finish { diffuse 0.9 }
 scale < 4/3, 1, 1 >*68
 translate <-0.5,-19,1e-12>
 //no_shadow
}
//**********************************************************************************
// Signature
//#include "Sealpositive.sgn.inc"
#local Ls=< 0, 0, -200 >; #local La=< 0, 0, 0 >; #local Ag=50;
#local Sz=0; #local Lz=-vlength(Ls-La); #local Vx=(1-Sz)*Lz*tan(radians(Ag/2));
#local Tx=Vx+La.x+4; #local Ty=Vx+La.y+5; #local Tz=Sz*Lz+La.z;
#local Rx=degrees(atan2((Ls.y-La.y),sqrt(pow((Ls.x-La.x),2)+pow((Ls.z-La.z),2))));
#local Ry=180+degrees(atan2((Ls.x-La.x),(Ls.z-La.z))); #local Rz=0;
//object { Sealing scale 0.8 translate < Tx,Ty*3/4,Tz > rotate < Rx,Ry,Rz > }
//----------------------------------------------------------------------------------