//************************************************
// Curved line macro Ver 0.2r000906e include file
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura
//************************************************


//***************************************************
#macro Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local A=2*(Mx*(Px1-Px2)-(Pz1-Pz2));
 #local B=2*(Px1-Px2)*(Mx*Pz1+Px1);
 #local C=(pow(Px2,2)-pow(Px1,2))+(pow(Pz2,2)-pow(Pz1,2));
 #if(A=0) #local A=pow(0.000001,10); #end //#if(A=0) #local Ox0=Px1+(Pz1-Pz2); #local Oz0=Pz1+(Px1-Px2); #end
 #local Oz0=(B+C)/A; #local Ox0=Mx*(Pz1-Oz0)+Px1;
#end
//***************************************************
#macro Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
// radius line
#local Vx1=Px1;
#if(Px1!=Ox0) #local Vz1= ((Pz1-Oz0)/(Px1-Ox0))*(Vx1-Px2)+Pz2; #else
 #if(Px1=Px2) #local Vz1=Pz1; #else #local Vz1=1/pow(0.000001,10); #end #end
// vartical line
#local Vx2=Px2; 
#if(Pz1!=Oz0) #local Vz2=(-(Px1-Ox0)/(Pz1-Oz0))*(Vx2-Px1)+Pz1; #else
 #if(Px1=Px2) #local Vz2=Pz2; #else #local Vz2=1/pow(0.000001,10); #end #end
// center point
#local Clipped_type=0;
#if(Vz1!=Pz1 & Vz2!=Pz2) 
 #local A=2*(Px2-Px1)*(Px1-Ox0)+2*(Pz2-Pz1)*(Pz1-Oz0);
 #local B=2*(Pz1-Pz2)*(Px1*Oz0-Pz1*Ox0);
 #local C=(Px1-Ox0)*(pow(Px1,2)-pow(Px2,2)+pow(Pz1,2)-pow(Pz2,2));
 #local Ox = (B-C)/A;                                 // center x
 #local Oz = ((Pz1-Oz0)/(Px1-Ox0))*(Ox-Px1)+Pz1;      // center z
 #local Tr=sqrt(pow(Px2-Ox,2)+pow(Pz2-Oz,2));         // radius r
 //
 #local Mc=Px1-Ox; #local Ms=Pz1-Oz;
 #if(Mc!=0) #local Mtan=Ms/Mc; #else #local Mtan=tan(pi/2); #end
 #local Vxv=(pow(Mtan,2)*Px2+Mtan*(Pz1-Pz2)+Px1)/(pow(Mtan,2)+1);
 #local Vzv=(pow(Mtan,2)*Pz1+Mtan*(Px1-Px2)+Pz2)/(pow(Mtan,2)+1);
 #local Vs=Vzv-Pz1; #local Vc=-(Vxv-Px1);
 //
 #if(Mc!=0)
  #if(Mc*Vs>0) #local Clipped_type=1; #end
  #if(Mc*Vs<0) #local Clipped_type=2; #end
 #else
  #if(Ms*Vc>0) #local Clipped_type=1; #end
  #if(Ms*Vc<0) #local Clipped_type=2; #end 
 #end
 //
#end
// 
#switch(Clipped_type)
 #case(0)
  #local Ox = Ox0+(Px2-Px1);
  #local Oz = Oz0+(Pz2-Pz1);
  cylinder { < Px1, 0, Pz1 >,< Px2, 0, Pz2 >,Lw }
 #break
 #case(1)
  #local Ra1=-degrees(atan2(Pz1-Oz,Px1-Ox))+180;
  #local Ra2=-degrees(atan2(Pz2-Oz,Px2-Ox));
  torus { Tr,Lw
  clipped_by { plane { z, 0 } rotate (Ra1)*y }
  clipped_by { plane { z, 0 } rotate (Ra2)*y }
  translate < Ox, 0, Oz > }
 #break
 #case(2)
  #local Ra1=-degrees(atan2(Pz1-Oz,Px1-Ox));
  #local Ra2=-degrees(atan2(Pz2-Oz,Px2-Ox))+180;
  torus { Tr,Lw
  clipped_by { plane { z, 0 } rotate (Ra1)*y }
  clipped_by { plane { z, 0 } rotate (Ra2)*y }
  translate < Ox, 0, Oz > }
 #break
#end
//
 #local Ox0 = Ox;
 #local Oz0 = Oz;
#end // macro end
//*****************************************************
//*****************************************************
//sample functions
//#macro Curve_function(Sp,Px0,Pz0,Func_type)
// #switch(Func_type)
// #case( 0) #local Px0= 2*cos(radians(45*Sp)); #local Pz0= 2*sin(radians(45*Sp)); #break // octagon
// #case( 1) #local Px0= Sp; #local Pz0= 1/3*pow(Px0,2)+Px0-1; #break // x^2
// #case( 2) #local Px0= Sp; #local Pz0= 1/3*pow(Px0,3); #break       // x^3
// #case( 3) #local Px0= Sp; #local Pz0= sin(Sp); #break // sin
// #case( 4) #local Px0= Sp; #local Pz0= cos(Sp); #break // cos
// #case( 5) #local Px0= 3*cos(Sp); #local Pz0= 2*sin(Sp); #break   // ellipse
// #case( 6) #local Px0= Sp*cos(Sp); #local Pz0= Sp*sin(Sp); #break // spiral
// #case( 7) #local Rr= cos(2*Sp); #local Px0= 3*Rr*cos(Sp); #local Pz0= 2*Rr*sin(Sp); #break // 4leafs
// #case( 8) #local Rr= cos(3*Sp); #local Px0= 3*Rr*cos(Sp); #local Pz0= 2*Rr*sin(Sp); #break // 3leafs
// #case( 9) #local Rr= cos(4*Sp); #local Px0= 3*Rr*cos(Sp); #local Pz0= 2*Rr*sin(Sp); #break // 8leafs
// #case(10) #local Px0= (2+3*cos(Sp))*cos(Sp)-2; #local Pz0= (1.5+3*cos(Sp))*sin(Sp); #break // carjioid
// #case(11) #local Px0= 3*pow(cos(Sp),3); #local Pz0= 2*pow(sin(Sp),3); #break // asteloid
// #case(12) #local Rr= sin(Sp/2); #local Px0= 3*Rr*cos(Sp); #local Pz0= 2*Rr*sin(Sp); #break // leafs
// #case(13) #local Px0= Sp; #local Pz0= log(Sp); #break // log
// #case(14) #local Px0= Sp-sin(Sp); #local Pz0= 1-cos(Sp); #break // cycloid
// #case(15) #local Px0= 3*pow(0.99,6*Sp)*cos(Sp); #local Pz0= 3*pow(0.99,6*Sp)*sin(Sp); #break
// #case(16) #local Px0= Sp; #local Pz0= 2*Px0; #break   // 2x
// #end
//#end
//*****************************************************
#macro Curved_line(Lw,Bp,Ep,Ap,Mx,Func_type)
 #local Px0=0; #local Pz0=0; #local Ox0=0; #local Oz0=0;

 #local Sp=Bp; #while(Sp<Ep) // while start
 Curve_function(Sp,   Px0,Pz0,Func_type) #local Px1=Px0; #local Pz1=Pz0;
 Curve_function(Sp+Ap,Px0,Pz0,Func_type) #local Px2=Px0; #local Pz2=Pz0;
 #if(Sp=Bp) Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #end
 Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Sp=Sp+Ap; #end       // while end

#end  // macro end
//*****************************************************
//sample parameters Lw:Bp:Ep:Ap:Mx:Func_type
//Curved_line(0.1,-pi,pi*2.6,pi/8,tan(radians(135)),0)
//Curved_line(0.1,-pi,pi,pi/8,2/3*(-pi)+1,1)
//Curved_line(0.1,-pi,pi,pi/8,pow(-pi,2),2)
//Curved_line(0.1,-pi,pi,pi/8,cos(-pi),3)
//Curved_line(0.1,-pi,pi,pi/8,-sin(-pi)+pow(0.1,10),4)
//Curved_line(0.1,-pi,pi,pi/6,(-2/3)*(cos(-pi)/sin(-pi)),5)
//Curved_line(0.1,-pi,pi,pi/38,tan(radians(111)),6)
//Curved_line(0.1,-pi,pi,pi/76,tan(radians(90)),7)
//Curved_line(0.1,-pi,pi,pi/76,tan(radians(270)),8)
//Curved_line(0.1,-pi,pi,pi/120,(-2/3)*(sin(4*-pi)*sin(-pi)+cos(-pi)*cos(4*-pi))/(sin(4*-pi)*cos(-pi)+sin(-pi)*cos(4*-pi)),9)
//Curved_line(0.1,-pi,pi,pi/36,tan(radians(90)),10)
//Curved_line(0.1,-pi,pi,pi/38,tan(radians(180+1.0e-12)),11)
//Curved_line(0.1,-pi*2,pi*2,pi/30,tan(radians(180)),12)
//Curved_line(0.1,0.1,3,pi/16,1/0.1,13)
//Curved_line(0.1,-pi,pi,pi/32,tan(radians(182)),14)
//Curved_line(0.1,-pi*0,pi*8,pi/32,tan(radians(90)),15)
//union { Curved_line(0.1,-pi*1,pi*1,pi/6,2,16) pigment { color rgb < R1, G1, B1 > } rotate -90*x scale 30 }
//*****************************************************
//*****************************************************
#macro Contact_curve_function(Sp,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px0,Pz0)
 #local Px0=(X0*pow(1-Sp,2)+(2+E1)*Xc*Sp*(1-Sp)+(1+E1+E2)*X1*pow(Sp,2))/(1+E1*Sp+E2*pow(Sp,2));
 #local Pz0=(Z0*pow(1-Sp,2)+(2+E1)*Zc*Sp*(1-Sp)+(1+E1+E2)*Z1*pow(Sp,2))/(1+E1*Sp+E2*pow(Sp,2));
#end
//*****************************************************
//-----------------------------------------------------
#macro Contact_line(Lw,E1,E2)
#local Px0=0; #local Pz0=0; #local Ox0=0; #local Oz0=0;

#local i=0; #while(i<Pmax-2) // while start
 #local X0=Vp[i].x;   #local Z0=Vp[i].y;
 #local Xc=Vp[i+1].x; #local Zc=Vp[i+1].y;
 #local X1=Vp[i+2].x; #local Z1=Vp[i+2].y; 
// curve segment
#local Sp=0; #local Ep=1; #local Ap=1/(10-1e-14); #local Mx=(Zc-Z0-1e-14)/(Xc-X0-1e-14);
#while(Sp<Ep)          // while start
 Contact_curve_function(Sp,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px0,Pz0)
 #local Px1=Px0; #local Pz1=Pz0;
 Contact_curve_function(Sp+Ap,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px0,Pz0)
 #local Px2=Px0; #local Pz2=Pz0;
 #if(Sp=0) Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #end
 Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Sp=Sp+Ap; #end // while end
#local i=i+2; #end     // while end

#end  // macro end
//-----------------------------------------------------
//*****************************************************
#macro Contact_curve(Lw,E1,E2)
#local Px0=0; #local Pz0=0; #local Ox0=0; #local Oz0=0;

#local i=0; #while(i<Pmax-1) // while start
 #local X0=Vp[i].x;   #local Z0=Vp[i].z;
 #local X1=Vp[i+1].x; #local Z1=Vp[i+1].z;
 #local M0=tan(radians(Vp[i].y));  #if(Vp[i].y=90)   #local M0=tan(pi/2+1e-14); #end
 #local M1=tan(radians(Vp[i+1].y));#if(Vp[i+1].y=90) #local M1=tan(pi/2+1e-14); #end
 #local Xc=(M0*X0-M1*X1-Z0+Z1)/(M0-M1); #local Zc=M0*(Xc-X0)+Z0;
  
// curve segment
#local Sp=0; #local Ep=1; #local Ap=1/(10-1e-14); #local Mx=M0;
#while(Sp<Ep)          // while start
 Contact_curve_function(Sp,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px0,Pz0)
 #local Px1=Px0; #local Pz1=Pz0;
 Contact_curve_function(Sp+Ap,E1,E2,X0,Z0,Xc,Zc,X1,Z1,Px0,Pz0)
 #local Px2=Px0; #local Pz2=Pz0;
 #if(Sp=0) Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #end
 Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Sp=Sp+Ap; #end // while end
#local i=i+1; #end     // while end

#end  // macro end
//*****************************************************
//*****************************************************
#macro Trammel_function(Sp,Tl,Vl,Px0,Pz0)
 #local Px0=Vl*cos(Sp); #local Pz0=(Tl-Vl)*sin(Sp);
#end
//*****************************************************
#macro Trammel(Lw,Tl,Vl)
 #local Sp=-pi; #local Ep= pi; #local Ap= pi/42;
 #if(Vl=0) #local Mx=tan(pi/2+1e-12); #else #local Mx=-(Tl-Vl)/Vl*cos(Sp)/sin(Sp); #end
 #local Px0=0; #local Pz0=0; #local Ox0=0; #local Oz0=0;

 #while(Sp<Ep)         // while start
 Trammel_function(Sp,Tl,Vl,Px0,Pz0)   #local Px1=Px0; #local Pz1=Pz0;
 Trammel_function(Sp+Ap,Tl,Vl,Px0,Pz0)#local Px2=Px0; #local Pz2=Pz0;
 #if(Sp=-pi) Beginning_center(Mx,Px1,Pz1,Px2,Pz2,Ox0,Oz0) #end
 Curve_element(Lw,Px1,Pz1,Px2,Pz2,Ox0,Oz0)
 #local Sp=Sp+Ap; #end // while end

#end  // macro end
//*****************************************************