// POV-Ray ver 3.5 bata
// Satellite weapon Scene File
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 }


// CAMERA
camera { location < -30, 1, -200 > 
         look_at 0 
         angle 50 }

// LIGHT
light_source { < 200, 350, -340 > color rgb 1 fade_distance 400 fade_power 1 }
light_source { <   0,   0, -240 > color rgb 1 shadowless }

//**********************************************************************************
coordinate_color( 120, 0.3, 0.5, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
#local P_Cloud_a =
 pigment { bozo
           turbulence 0.65
           octaves 6
           omega 0.7
           lambda 2
           color_map { [0.0, 0.1 color rgb <.85, .85, .85> color rgb <.75, .75, .75> ]
                       [0.1, 0.5 color rgb <.75, .75, .75> color rgbf <1, 1, 1, 1> ]
                       [0.5, 1.0 color rgbf <1, 1, 1, 1>   color rgbf <1, 1, 1, 1> ] }
 }
#local P_Cloud_b =
 pigment { bozo
           turbulence 0.8
           octaves 10
           omega .5
           lambda 2.5
           color_map { [0.0, 0.4 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
                       [0.4, 0.6 color rgbf<.9, .9, .9, .9>   color rgbf<1, 1, 1, 1> ]
                       [0.6, 1.0 color rgbf<1, 1, 1, 1>       color rgbf<1, 1, 1, 1> ] } scale <1, 0.3, 10>
 }
#local P_Cloud_c =
 pigment { bozo
           turbulence 0.6
           octaves 10
           omega .5
           lambda 2.5
           color_map { [0.0, 0.4 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
                       [0.4, 0.7 color rgbf<.9, .9, .9, .9>   color rgbf<1, 1, 1, 1> ]
                       [0.7, 1.0 color rgbf<1, 1, 1, 1>       color rgbf<1, 1, 1, 1> ] } scale <1, 0.3, 10>
 }
#local P_Cloud_d =
 pigment { bozo
           turbulence 1.5
           octaves 10
           omega .5
           lambda 2.5
           color_map { [0.0, 0.5 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
                       [0.5, 0.7 color rgbf<.9, .9, .9, .9>   color rgbf<1, 1, 1, 1> ]
                       [0.7, 1.0 color rgbf<1, 1, 1, 1>       color rgbf<1, 1, 1, 1> ] } scale <1, 0.3, 10>
 }
//----------------------------------------------------------------------------------
coordinate_color(120,0.19,0.35,1,1)
sky_sphere { 
  pigment { rgb <R1,G1,B1> }
  pigment { P_Cloud_d }
  pigment { P_Cloud_c } //
  pigment { P_Cloud_b }
  pigment { P_Cloud_a } //
  rotate 180*y
}
//**********************************************************************************
// planet
coordinate_color(330,1,0.5,1,1)
coordinate_color(120,1,0.5,1,2)
coordinate_color(360,1,1.0,1,3)
#local T_Gradient =
texture {
 pigment { gradient x
           color_map { [0.00 rgb < R1,G1,B1 > ]
                       [0.33 rgb < R2,G2,B2 > ]                     
                       [0.66 rgb < R3,G3,B3 > ] } }
 finish { ambient 0 diffuse 0 reflection 0.8 }
}
//
coordinate_color(255,0.90,0.90,1,4)
coordinate_color(255,0.91,0.78,1,5)
coordinate_color(255,0.92,0.56,1,6)
#local T_Lightening =
texture {
 pigment { granite 
           turbulence 0.5
           color_map { [0.00 rgbf <1,1,1,0>]
                       [0.10 rgbf <R4, G4, B4, 0.65>]
                       [0.20 rgbf <R4, G4, B4, 0.65>]
                       [0.30 rgbf <R5, G5, B5, 0.85>]
                       [0.45 rgbf <R5, G5, B5, 0.85>]
                       [0.65 rgbf <R6, G6, B6, 0.95>] } }
 finish { ambient 1 }
}
//
#local Planet_seg = sphere { 0,60 texture { T_Gradient } texture { T_Lightening scale 30 } rotate 180*y }
//**********************************************************************************
// Flare
coordinate_color( 30+120, 0.6, 0.5, 3, 1 )
#local T_flare =
texture {
 pigment { wood
           color_map { [ 0.0 rgbt < 1, 1, 1, 1 > ]
                       [ 0.3 rgbt < R1, G1, B1,0.8 > ]
                       [ 0.4 rgbt < R2, G2, B2,0.6 > ]
                       [ 0.5 rgbt < R3, G3, B3,0.4 > ]
                       [ 0.6 rgbt < R2, G2, B2,0.6 > ]
                       [ 0.7 rgbt < R3, G3, B3,0.8 > ]
                       [ 1.0 rgbt < 1, 1, 1, 1 > ] } }
 finish { ambient 0.6 diffuse 0.6 reflection 0 }
}
//----------------------------------------------------------------------------------
#local Flare_org =
union {
 disc { 0, z, 16, 10 texture { T_flare scale 15*2 } }
 disc { 0, z, 35, 20 texture { T_flare scale 30*2 } }
 disc { 0, z, 60, 40 texture { T_flare scale 60*2 } }
}
//
#local Ra1=78; #local Ra2=102;
#local Flare_s01 =
 object { Flare_org
 clipped_by { plane { y,0 } rotate -(Ra1+180)*z }
 clipped_by { plane { y,0 } rotate -(Ra2)*z } 
}
//
#local Ra1=88.5; #local Ra2=91.5;
#local Flare_s02 =
 object { Flare_org
 clipped_by { plane { y,0 } rotate -(Ra1+180)*z }
 clipped_by { plane { y,0 } rotate -(Ra2)*z } 
}
//
#local Ra1=89.08; #local Ra2=90.02;
#local Flare_s03 =
 object { Flare_org
 clipped_by { plane { y,0 } rotate -(Ra1+180)*z }
 clipped_by { plane { y,0 } rotate -(Ra2)*z } 
}
//
#local Flare_seg =
union {
#local Ei=11; #local Si=0; #while(Si<Ei)
 #if (mod(Si,2)=0) object { Flare_s01 rotate 360*Si/Ei*z } #end
 object { Flare_s02 rotate (360*Si/Ei+360/Ei/2+360/Ei/4)*z }
 object { Flare_s02 rotate (360*Si/Ei+360/Ei/2+360/Ei/16)*z }
 object { Flare_s02 rotate (360*Si/Ei+360/Ei/2-360/Ei/16)*z }
#local Si=Si+1; #end
no_shadow
}
//**********************************************************************************
// smoke
coordinate_color(120,1,0.5,3,2)
#local P_lightening =
 pigment { granite
           turbulence 0.49
           color_map { [0.00 rgbf < 1,1,1,1 > ]
                       [0.28 rgbf < 1,1,1,1 > ]
                       [0.29 rgbf < R2,G2,B2,0 > ]
                       [0.30 rgbf < R3,G3,B3,0 > ]
                       [0.32 rgbf < R4,G4,B4,0 > ]
                       [0.33 rgbf < 1,1,1,1 > ]
                       [1.00 rgbf < 1,1,1,1 > ] } rotate <-90-50,90-90,-90-36> }
//
#local Smoke_org = sphere { 0,40 pigment { P_lightening scale 680 } }
#local Smoke_seg =
difference {
 object { Smoke_org }
 box { <40,0,40>,<-40,-40,-40> pigment { color rgbt 1 } scale 1.0001 }
 scale 3
 no_shadow
}
//**********************************************************************************
// weapon
coordinate_color( 90, 0.1, 0.9, 1, 3 )
#local T_satellite =
 texture {
  pigment { hexagon color rgbt < R3, G3, B3, 0.1 >,color rgbt < R3, G3, B3, 0.2 >,color rgbt < R3, G3, B3, 0.3 > }
  finish { metallic reflection 0.4 brilliance 8 phong 0.75 phong_size 80 }
}
//----------------------------------------------------------------------------------
#include "Beam_weapon.def.inc"
//----------------------------------------------------------------------------------
#local Satellite_weapon =
union {
 object { Beam_weapon texture { T_satellite } }
 //object { Beam_violet rotate 180*x translate 88*x } object { Beam_yellow translate 88*x }
 object { Beam_seg scale <0.99,1,1> rotate 180*x translate 88*x } object { Beam_seg scale <0.99,1,1> translate 88*x }
}
//**********************************************************************************
// astrobio
coordinate_color(150,0.3,0.9,1,5) 
#local T_astrobio =
texture {
  pigment { color rgbf <R5,G5,B5,1> }
  finish { ambient 0.1
           diffuse 0.1
           reflection 0.2
           specular 1
           roughness 0.001
           irid { 0.2 thickness 0.1 turbulence 0.8 } }
}
#local I_astrobio = interior { ior 1.25 fade_distance 50 fade_power 1 caustics 0.8 }
//----------------------------------------------------------------------------------
#include "Astrobio.def.inc"
//
#local Astrobio_body = object { Astrobio_seg texture { T_astrobio } interior { I_astrobio } scale 0.6 rotate -90*y }
//**********************************************************************************
union {
 object { Astrobio_body translate <160-70,40,0> rotate 30*y }
 object { Astrobio_body rotate 30*y translate <160+80,-50,0> }
 object { Satellite_weapon rotate 180*y translate 160*3*x }
 object { Astrobio_piece rotate <0,30,90> translate 160*x }
 object { Smoke_seg translate 160*x }
 union { object { Spark_seg scale 20/150 } object { Flare_seg scale 1.8 } rotate -90*y translate 160*x }
 object { Satellite_weapon }
 rotate -50*y translate -30*x
}
//
object { Planet_seg translate <180,-110,250> scale 6 }
//**********************************************************************************
// Signature
//#include "Sealpositive.sgn.inc"
#local Ls=< -30, 1, -200 >; #local La=< 0, 0, 0 >; #local Ag=50;
#local Sz=0; #local Lz=-vlength(Ls-La); #local Vx=(1-Sz)*Lz*tan(radians(Ag/2));
#local Tx=Vx+La.x+5; #local Ty=Vx+La.y+6; #local Tz=Sz*Lz+La.z;
#local Rx=degrees(atan2((Ls.y-La.y),sqrt(pow((Ls.x-La.x),2)+pow((Ls.z-La.z),2))));
#local Ry=180+degrees(atan2((Ls.x-La.x),(Ls.z-La.z))); #local Rz=0;
//object { Sealing scale 0.8 translate < Tx,Ty*3/4,Tz > rotate < Rx,Ry,Rz > }
//----------------------------------------------------------------------------------