
global_settings{ max_trace_level 10 }

#version unofficial MegaPov 0.5;

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"      
#include "golds.inc"        
#include "woods.inc"



// ******* Stein ****************************************************

#declare Fa=function{pigment{
                           bozo
                           turbulence 0.2
                           color_map { [0 rgb 1] [1 rgb 0] }
                           scale 0.5
                           }
                         }

#declare STONE = isosurface {
                             function { x^2 + y^2 +z^2 -1 + Fa(x,y,z)*0.3 }
                             method 2
                             max_gradient 3.5
                             accuracy 0.0001
                             contained_by{box <-1,-1,-1> <1,1,1>  }
                    texture {
  pigment {
    granite
    turbulence 0.70
    color_map {
      [0.00 color rgb<0.20, 0.20, 0.20>]
      [0.31 color rgb<0.57, 0.56, 0.56>]
      [1.00 color rgb<0.77, 0.77, 0.76>]
    }
  }
  normal {
    bumps 0.05
    scale <0.20,0.20,0.20>
  }
  finish {
    ambient 0.50
    diffuse 1.00
    crand 0.250
  }
}

}

// ******* Einzelner Pfeil *******************************************

#declare FEDER = prism {
linear_sweep
linear_spline
-0.015, 0.015, 5, 
<0,0>, <0.6,0>, <0.8,0.2>, <0.2,0.2>, <0,0>
texture { pigment {
   bozo   
   turbulence 0.8
   color_map {
      [0.0 0.3   color White color White]
      [0.3 1.001 color White color red 1.0]
   }}
   scale 0.2
   }
scale 0.1
rotate <0,0,90>
rotate <0,90,0>
}



#declare PFEIL = union {

cylinder {<0,0,0> <0,1.3,0> 0.005
         texture {
   pigment {
      wood
      turbulence 0.1
      colour_map {
         [ 0.0 0.55 colour red 0.45 green 0.25
         colour red 0.45 green 0.25 ]
         [ 0.55 1.0 colour red 0.30 green 0.16
         colour red 0.30 green 0.16 ]
      }
      scale <0.006, 1, 0.006>
      }
   finish {
      specular 1
      roughness 0.02
   }
}
}

object {FEDER rotate <0,   0,0> translate <0,1.24,0>}
object {FEDER rotate <0, 126,0> translate <0,1.24,0>}
object {FEDER rotate <0, 253,0> translate <0,1.24,0>}
}
// ******* Kcher Mit Pfeilen ****************************************

#declare KOECHER = union {

cone { <0,0,0> 0.1
       <0,1,0> 0.12
       open 
       texture { pigment {
           bozo
           turbulence 0.8
         color_map
         {
             [0.00 color rgb <0.22, 0.1, 0.04> * 2]
             [1.00 color rgb <0.35, 0.1, 0.05> * 2]
         }
       scale .1
     }
       normal {  crackle 0.1
               slope_map {
	        [0 <0,1>]
	        [.05 <1,0>]
	        [.95 <1,0>]
	        [1  <0,-1>]
	     }

            turbulence .1  scale .1 }
            finish { specular 0.45 }
        }
      scale <1,1,0.3>
     }
     
torus { 0.12, 0.01 
         texture {
           pigment { color <0.8,0.8,0.9> }
         normal {
                  average
                  normal_map {
                     [
                        bumps 0.3*2
                        warp {turbulence 1}
                        scale 0.1
                     ]
                     [
                        bumps 0.2*2
                        warp {turbulence 0.5}
                        scale 0.0005
                     ]
                  }
               }
        
       }
       scale   <1,3,1>
       scale   <1,1,0.3>
       translate <0,1,0>  
      }
object {PFEIL rotate <6,90,0>}      
object {PFEIL rotate <5,95,0>}      
object {PFEIL rotate <4,96,0>}      
object {PFEIL rotate <5,86,0>}      
object {PFEIL rotate <6,88,0>}      
object {PFEIL rotate <4,84,0>}      
}     

// ******* Bogen  ********************************************
#declare BOGEN = union {

//------------------
cylinder {< 1, 0, -0.166>
          <-1, 0, -0.166>
          0.003
          pigment {Black}
          }
//------------------
prism {
linear_sweep
linear_spline
-0.02, 0.02, 66

#declare i = -16;           
#while (i <= 16)
 ,<i/16, cos(i / 5)/6>    
#declare i = i + 1;
#end

#declare i = 16;
#while (i >= -16)
 ,<i/16, cos(i / 5)/6 - 0.01>    
#declare i = i - 1;
#end

texture {
pigment {
    wood
    turbulence 0.05
    octaves 6
    scale <0.075, .075, 1>
    color_map {
        [0.0, 0.1 color rgb <0.30, 0.10, 0.050>
                  color rgb <0.30, 0.10, 0.050>]
        [0.1, 0.9 color rgb <0.30, 0.10, 0.050>
                  color rgb <0.25, 0.07, 0.038>]
        [0.9, 1.0 color rgb <0.25, 0.07, 0.038>
                  color rgb <0.25, 0.07, 0.038>]
    }
}}
}
//------------------
cylinder {
  < 0.15,0,0>
  <-0.15,0,0>
  0.03
  scale     <1,1,0.5>
  translate <0,0,0.158>
  pigment {White}
}
}
// ******* Waffen Komplett ********************************************

#declare WEAPONS = union {
object   {STONE   scale <1.5,1,1>}
object   {KOECHER translate <0,0,-0.9>}
object   {BOGEN   scale 1.5 rotate <0,80,0> rotate <-20,0,0> translate <-0.5,0.7,-0.9>}
}


// ******* TestRender *******************
/*
camera
{
	location  <-5, 0, 0>
	look_at   <0, 0,  0>
}

light_source { <2,20,-20> color red 1  green 1  blue 1}
              

#declare sonnenuntergang1 =
  pigment {
    gradient y
    cubic_wave 
    colour_map {
      [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
      [1.00 rgbt <0.0, 0.0, 1.0, 0.8>]
    }
  }


sky_sphere {
  pigment { sonnenuntergang1 }
  translate -0.15*y
}

object {WEAPONS}
*/