
global_settings{ max_trace_level 10 }

#version unofficial MegaPov 0.5;

#include "colors.inc"
#include "textures.inc"

// ******* Stein ****************************************************

#declare Fa=function{pigment{
                           bozo
                           turbulence 0.4
                           color_map { [0 rgb 1] [1 rgb 0] }
                           scale 0.5
                           }
                         }

#declare STONE = isosurface {
                             function { x^2 + y^2 +z^2 -1 + Fa(x,y,z)*0.6 }
                             method 2
                             max_gradient 3.5
                             accuracy 0.0001
                             contained_by{box <-1,-1,-1> <1,1,1>  }
                    texture {
  pigment {
    granite
    turbulence 0.70
    color_map {
      [0.00 color rgb<0.18, 0.22, 0.21>]
      [0.31 color rgb<0.57, 0.56, 0.56>]
      [1.00 color rgb<0.77, 0.77, 0.76>]
    }
  }
  normal {
    bumps 0.02
    scale <0.15,0.15,0.15>
  }
  finish {
    ambient 0.50
    diffuse 1.00
    crand 0.250
  }
}

}


#declare TEMPLE = union {
object   {STONE   scale <1.1,1,1>   translate <0,0,0> }
object   {STONE   scale <1.8,0.5,0.8> rotate <0,0,25 > translate <-1.2,0.85,0>}
}


// ******* TestRender *******************
/*
camera
{
	location  <0, 1, -5>
	look_at   <0, 0,  0>
}

light_source { <2,20,-20> color red 1  green 1  blue 1}
              

#declare sonnenuntergang1 =
  pigment {
    gradient y
    cubic_wave 
    colour_map {
      [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
      [1.00 rgbt <0.0, 0.0, 1.0, 0.8>]
    }
  }


sky_sphere {
  pigment { sonnenuntergang1 }
  translate -0.15*y
}

object {TEMPLE }
*/