
global_settings{ max_trace_level 10 }

#version unofficial MegaPov 0.5;

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"      
#include "golds.inc"          


// ******* Schale ****************************************************

#declare SCHUESSEL =
difference {
sphere {<0,0,0>   0.5 scale <1,0.5,1>}
sphere {<0,0.3,0> 0.5 scale <1,0.6,1>}
      texture{
    pigment 
  {wood
   turbulence 0.06
   octaves 3
   scale <0.05, .75, 1>
   color_map 
    {[0.00, 0.10 color red 0.888 green 0.600 blue 0.3
                 color red 0.888 green 0.600 blue 0.3]
     [0.10, 0.90 color red 0.888 green 0.600 blue 0.3
                 color red 0.7 green 0.35 blue 0.2]
     [0.90, 1.0  color red 0.7 green 0.35 blue 0.2
                 color red 0.7 green 0.35 blue 0.2]
    }
  }
}
}

// ******* Schale ****************************************************

#declare SCHUESSELWASSER =
difference {
sphere {<0,0.3,0> 0.5 scale <1,0.6,1> scale 0.18 rotate <-15,20,-10> translate <0.13,0.06,0.13>}
 box   {<1,1,1> <-1,0.05,-1>}
     pigment { Clear } interior {ior 1.33}
}
// ******* Kleine Decke  *********************************************

#declare DECKE_KLEIN  = 
height_field { tga "blanket.tga"
	smooth
	texture {
            pigment { color <0.9,0.8,0.8> }
            finish  { diffuse 0.8 }
	}
	scale <0.5,0.03,0.5>
	translate <-0.25,0,-0.25>
}

// ******* Orange *****************************************************

#declare ORANGE  = blob {
	threshold 0.6
	sphere {
		<0,-0.2,0>,0.5,1
	}
	sphere {
		<0,0.2,0>,0.2,-1
	}
	sphere {
		<0,-0.6,0>,0.2,-1
	}
	texture {
		pigment {
			color rgb <1,0.6,0.0>
		}
		finish { phong 0.2 }
		normal {
			crackle 1
			turbulence 0.5
			scale 0.05
		}
	}
}

// ******* Orange *****************************************************

#declare FLUTE = union {

difference {
   cylinder { <  0,0,0>,
              <0.5,0,0>,
              0.01
              open
              texture { T_Silver_3B }
            }
   
   #declare hole = 0.1;
   #while (hole < 0.4 )
      cylinder { <hole,0,0>,
                 <hole,1,0>,
                 0.003}
      #declare hole = hole + 0.04;
   #end
   
   sphere {<0,-0.012,0> 0.020}
}
torus { 0.005, 0.008
        texture { T_Gold_4E }
        rotate <0,0,90> translate <0.03,0,0>
  }
torus { 0.005, 0.008
        texture { T_Gold_4E }
        rotate <0,0,90> translate <0.08,0,0>
  }
torus { 0.005, 0.0102 
        texture { T_Gold_4E }
        rotate <0,0,90> translate <0.48,0,0>
  }

}

// ******* Picnic Komplett ********************************************

#declare PICNIC = union {
object {DECKE_KLEIN}
object {SCHUESSEL scale 0.18 rotate <-15,20,-10>  translate <0.13,0.06,0.13>}
object {SCHUESSELWASSER}
object {ORANGE scale 0.2 translate <-0.1,0.09,-0.1>}
object {FLUTE scale 0.6 rotate <0,55,5> translate <-0.1,0.018,0.1>}
}


// ******* TestRender *******************
/*
camera
{
	location  <0, 0.4, -0.8>
	look_at   <0, 0,  0>
}

light_source { <2,20,20> color red 1  green 1  blue 1}
              

#declare sonnenuntergang1 =
  pigment {
    gradient y
    cubic_wave 
    colour_map {
      [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
      [1.00 rgbt <0.0, 0.0, 1.0, 0.8>]
    }
  }


sky_sphere {
  pigment { sonnenuntergang1 }
  translate -0.15*y
}

object {PICNIC}
*/