#version unofficial MegaPov 0.5;

#include "colors.inc"
#include "stones1.inc"

#declare FlameMedia=
 sphere {0,1.1
   pigment {color transmit 1.0}
        interior {
              media {
                method 2 intervals 2 samples 3,3  // megapov, or increase intervals and samples
              absorption <.33,.5,.67>*2 
           //   emission <.33,.5,.67>*3 // .67
              emission <1.33,.5,.67>*12 // .67
              //scattering {2,<.75,.67,.5>*2 extinction .133}
                density {spherical turbulence <.1,.2,.15>*1.5
                        density_map {
                        [0 rgb 0]
                        [.15 rgb <1.5,1,.5>*3 /6 ]
                        [.5 rgb <1.25,.5,.75>*2 /6]
                        [.7 rgb<1,1.5,.5>*6 /6]
                        } scale <.85,.9,.85>  translate -.25*y}
                }
                media {
                method 2 intervals 2 samples 3,3 
              absorption <.36,.33,.167>*3 
              //emission <.25,.5,.75>*3
              emission <1.25,.5,.75>*10
              //scattering {1,<.25,.33,.75>*3 extinction .67}
                density {spherical turbulence <.1,.2,.15>*.5
                        density_map {
                        [0 rgb 0][.6 rgb <1,1,0.1>*3 / 4]
                        } scale <.7,.3,.7>  translate -.9*y}
                }
       }
 scale <.9,1.5,.9>*.25 rotate 45*y translate .225*y
 hollow
 }

// ------- Stein - Textur -------------
#declare Granite_Texture =
texture{T_Grnt9 scale <1.2, 2.4, 1.2> rotate <0, 0, -30> rotate <40, 0, 0>}
texture{T_Crack1 scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 0.2 phong_size 90 ambient 0.2}
}


// ------- Einzelner Stein ------------
#declare FireStone = blob {

  sphere {<0,0,0> 1 ,1.2 translate <0,0,0>
  texture {Granite_Texture}}
  
  #declare RXRot = seed(10);
  #declare RYRot = seed(10);
  
  
  #declare i_bump = 0;
  #while (i_bump < 50)
  
  sphere {<0,0,0> (0.3 * rand(RXRot)) ,0.8 translate <0,0,0.15> rotate <rand(RXRot) * 360, 0, rand(RYRot) * 360>
  texture {Granite_Texture}}
  
  #declare i_bump = i_bump + 1;
  #end
  
}

// ------- Steinring ------------------

#declare Stone_Ring = union {
   
   #declare RXRot = seed(20);
   #declare v_i = 0;
   #while (v_i < 20)
     object {FireStone scale  (rand(RXRot) * 0.5) + 0.75
                       rotate <rand(RXRot) * 360,0,0> 
                       translate <0,0,2> 
                       rotate <0,v_i * (360 / 20),0>}   
   #declare v_i = v_i + 1;
   #end

}

 
#declare FIRE = 
object{
   light_source {<0,0.2,0> color <1,0.6,0.6>
             fade_distance 2
             fade_power 1
     looks_like {FlameMedia translate <0,-0.2,0>}
   }}

   
   
