
global_settings{ max_trace_level 10 }

#debug "Including ...\n"

#version unofficial MegaPov 0.5;

#include "colors.inc"
#include "golds.inc"
#include "stones1.inc"

// ------- Switch Stuff on an of -------------------------------------------------------------------

#declare Elf         = 1;
#declare GrassOn     = 1;
#declare Horse       = 1;
#declare Unicorn     = 1;
#declare SplineTrees = 1;
#declare VegPlants   = 1;
#declare FireOn      = 1;
#declare PicnicOn    = 1;
#declare GroundOn    = 1;
#declare WeaponsOn   = 1;
#declare TempleOn    = 1;
#declare ClothingOn  = 1;

#debug "\nCamera & Light...\n"

camera
{
        location  <0, 8.5, -199>
	look_at   <0, 7,  -180>
}

// ******* Lichtquellen *******************

// ------- Sonne ----------------------
light_source { <100, 1000, 40000> color red 1  green 0.2  blue 0.2
//          area_light <-900,    0, 40000>, 
//                     <1100, 2000, 40000>,
//                     5,5 adaptive 1
             looks_like { sphere  { <100,1000,40000> 2000  
                             texture {
                                pigment 
                                { bozo
                                turbulence -3
                                octaves 2
                                lambda 6
                                color_map
                                { [0.0 0.2 color Firebrick * 4 color Firebrick * 4]
                                  [0.2 1.0 color Firebrick * 4 color Orange * 4]
                                }
                                }
                                finish  { diffuse 1
                                          ambient 2
                                        }
                            }
                          }
                         }
}
              
             
             
// ------- Lagerfeuer -----------------
#if (FireOn = 1) 

    #include "fire.inc"

    object {FIRE scale 1 translate <0.3,7.8,-196.2> }
    object { Stone_Ring scale 0.1 translate <0.3,7.9,-196.2> }  

#end // Fire

#debug "Background ...\n"

// *************************************************************************************************
// ** Hintergrund                                                                                 **
// *************************************************************************************************

// ------- Himmel ----------------------------------------------------------------------------------

#declare sonnenuntergang1 =
  pigment {
    gradient y
    cubic_wave 
    colour_map {
      [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
      [1.00 rgbt <0.0, 0.0, 1.0, 0.8>]
    }
  }

#declare sonnenuntergang2 =
  pigment {
    boxed
    scale <1, 0.7, 1>
    pigment_map {
      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
      [0.000000000001
        gradient y
        cubic_wave
        colour_map {
          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
          [1.00 rgbt <0.0, 1.0, 0.0, 1.0>]
        }
      ]
    }
  }

#declare sonnenuntergang3 =
  pigment {
    boxed
    scale <1, 0.6, 1>
    pigment_map {
      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
      [0.000000000001
        gradient y
        cubic_wave
        colour_map {
          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
          [1.00 rgbt <1.0, 0.0, 0.0, 1.0>]
        }
      ]
    }
  }

sky_sphere {
  pigment { sonnenuntergang1 }
  pigment { sonnenuntergang2 }
  pigment { sonnenuntergang3 }
  translate -0.15*y
}

#declare T_Cloud3_Lo =
texture {
    pigment { bozo
        turbulence 0.8 
        octaves 10
        omega 0.5
        lambda 2.5
        color_map { [0.0 color rgbf<0.95, 0.95, 0.95, 0.00>]
                    [0.4 color rgbf<0.90, 0.90, 0.90, 0.90>]
                    [0.7 color rgbf<1, 1, 1, 1> ]
                    [1.0 color rgbf<1, 1, 1, 1> ] }
           }
    finish {ambient 1.0 diffuse 0.0 }
}
texture {
    pigment { bozo
        turbulence 0.8 
        octaves 10
        omega 0.5
        lambda 2.5
        color_map { [0.00, color rgbf<.85, .85, .85, 0.5>*1.2 ]
                    [0.35 color rgbf<.95, .95, .95, .95>]
                    [0.5 color rgbf<1, 1, 1, 1> ]
                    [1.0 color rgbf<1, 1, 1, 1> ] }
    }
    finish { ambient 0.95 diffuse 0.0}
scale 0.9
translate y*-0.15
}


plane { <0,1,0>, 1000 hollow //!!!!
        texture { T_Cloud3_Lo  scale 500}}
// ------- Wasser ----------------------------------------------------------------------------------

plane   {
                            y, 5
                            texture
                            {
                              pigment { color rgb < 0.3, 0.3, 0.7 > }
                              normal { bumps 0.1 scale < .5, 0.25, 0.15 > }
                              finish { phong 1 reflection 1.0 ambient 0.2 diffuse 0.2 specular 1.0 }
                            }
                            
                          } 


// ------- Nebel -----------------------------------------------------------------------------------
       
#declare F_FOG = fog  {
                        fog_type 2
                        distance 50
                        
                        fog_offset 3
                        fog_alt 2
                        color rgbf <1 ,.7 ,.7 , 1.0>
                      }
       
                      

// fog { F_FOG }

// ------- Insel -----------------------------------------------------------------------------------

#if (GroundOn = 1) 

height_field { tga "landscape_hf.tga"
	smooth
	texture {
            pigment { color <1,1,1> }
	}

        translate <-.5, -0.249, -.5>
	scale <63.000, 16.537, 63.000>
}


#debug "Foreground ...\n"

// ------- Boden Vordergrund -----------------------------------------------------------------------
height_field
{
	tga "foreground_hf.tga"
	smooth
        texture {
          pigment { image_map { png "grasstex.png" /*interpolate 2*/ }
          rotate x*90 scale 0.02 }
           }
	scale <100, 10, 100>
	translate <-50,1,-210>
}

#end //GroundOn

// *************************************************************************************************
// ** Pflanzen im Vordergrund                                                                     **
// *************************************************************************************************

// ------- Einzelne ( placed by Genesis Toolkit ) --------------------------------------------------

#if (VegPlants = 1)

     #include "fern.inc"

     object {Ferns translate <-50,1,-210>}
     object {Grantraes translate <-50,1,-210>}
     
#end //VegPlants     

// ------- Baum links hinter Einhorn ---------------------------------------------------------------

#if (SplineTrees = 1 ) 

     #include "leafdefs.inc"
     #include "splinetree.inc"
     
     #declare recursionmax = 5; // Defines the complexity of the tree
     #declare divisions = array[5] {6,5,4,4,3}
     init_rand (48,148,157)     // Supply seeds to initialize the random variable
     // Variables modeled exponentially
     // Use: init_variable (start_size, end_size, base)
     init_tdev (0.4, 0.8, 0.9)
     init_rdev (70, 40, 1)
     init_twigprob (0.2, 0.8, 0.7)
     init_branchl (3.4, 0.2, 0.6)
     init_branchw (0.35, 0.003, 0.4)
     
     // Odd variables
     init_roots (2)			// Use: init_roots (rootrecursionmax)
     init_splinedev (0.15,0.3)	// Use: init_splinedev (min_dev, max_dev)
     init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)
     
     // Add some gravity
     #declare tendancy = <0,-0.1,0>;
     
     // Variables for leaves
     #declare leafarray = array[4] {maple1,maple2,maple3,pinkflower}
     #declare leafprob = array[4] {0.1,0.1,0.1,0.3}
     #declare leafscale = array[4] {0.2,0.2,0.2,0.2}
     #declare leafnoise = array[4] {1,1,1,0.5}
     
     // Assign the branch texture
     #declare branchtexture = texture { standard_branch } // standard_branch is defined in leafdefs.inc
     
     // Define transformations assigned to the whole tree here.
     #declare global_transform = transform {
     	scale <0.6,0.6,0.6>
     	rotate <0,0,0>
     	translate <-2,7,-194>
     }
     
     // Provide feedback in the first 2 recursion levels
     #declare feedback = 1;
     
     // Call the macro
     splinetree(0,0)
     
     // ------- Bltenbaum 2 ----------------------------------------------------------------------------
     
     init_rand (30,141,140)
     
     #declare global_transform = transform {
     	scale <0.6,0.6,0.6>
     	rotate <0,90,0>
     	translate <-1,7,-190>
     }
     
     splinetree(0,0)
     
     // ------- Bltenbaum 3 ----------------------------------------------------------------------------
     
     init_rand (20,150,156)
     
     #declare global_transform = transform {
     	scale <0.6,0.6,0.6>
     	rotate <0,90,0>
     	translate <-3,7,-189>
     }
     
     splinetree(0,0)

     // Variables for leaves
     #declare leafarray = array[4] {maple1,maple2,maple3,fallmaple1}
     #declare leafprob  = array[4] {0.1,0.1,0.1,0.3}
     #declare leafscale = array[4] {0.2,0.2,0.2,0.2}
     #declare leafnoise = array[4] {1,1,1,0.5}

     // ------- Bltterbaum 1 ---------------------------------------------------------------------------

     init_rand (22,140,110)
     
     #declare global_transform = transform {
     	scale <0.7,0.7,0.7>
     	rotate <0,90,0>
     	translate <4,7.5,-180>
     }
     
     splinetree(0,0)
     
     // ------- Bltterbaum 2 ---------------------------------------------------------------------------

     init_rand (10,160,90)
     
     #declare global_transform = transform {
     	scale <0.6,0.6,0.6>
     	rotate <0,90,0>
     	translate <10,7.5,-182>
     }
     
     splinetree(0,0)

     // ------- Bltterbaum 3 ---------------------------------------------------------------------------

     init_rand (20,130,110)
     
     #declare global_transform = transform {
     	scale <0.6,0.6,0.6>
     	rotate <0,90,0>
     	translate <7.3,7.5,-187>
     }
     
     splinetree(0,0)

#end //Splinetrees 

// ------- Grassteppich ( Random ) -----------------------------------------------------------------

#if (GrassOn = 1) 

     #include "grass.inc"
     #include "grassII.inc"
     
     #declare RMirror = seed(10);
     #declare RX      = seed(0);
     
     #declare c_z = 0;
     #while (c_z < 50)
        
        #declare c_x = -25;
        #while (c_x < 25)
        
           #declare TGMirror = rand(RMirror);
           #switch (TGMirror)
              #range(0, 0.25)
                 object {Little_Grass scale <1,1,1> rotate <-90,0,0> translate <c_x / 2.7  , 7.88,(-200 + (c_z / 4))> 
                        	texture { pigment { gradient y
     		                    turbulence 0.5
     		                       color_map {
     		                       [0.0 color <0.3,0.9,0.2>]
     		                       [0.5 color <0.3,0.7,0.2>]
     		                       [1.0 color <0.7,0.7,0.4>]
     		                       }
     		                    } 
     		          }}
              #break
              #range(0.25,0.5)
                 object {Little_Grass scale <-1,1,1> rotate <-90,0,0> translate<c_x / 2.7  , 7.88,(-200 + (c_z / 4))> 	texture { pigment { gradient y
     		                    turbulence 0.5
     		                       color_map {
     		                       [0.0 color <0.3,0.9,0.2>]
     		                       [0.5 color <0.3,0.7,0.2>]
     		                       [1.0 color <0.7,0.7,0.4>]
     		                       }
     		                    } 
     		          }}
              #break
              #range(0.5,0.75)
                 object {Little_Grass scale <-1,1,-1> rotate <-90,0,0> translate<c_x / 2.7 , 7.88,(-200 + (c_z / 4))> 	texture { pigment { gradient y
     		                    turbulence 0.5
     		                       color_map {
     		                       [0.0 color <0.3,0.9,0.2>]
     		                       [0.5 color <0.3,0.7,0.2>]
     		                       [1.0 color <0.7,0.7,0.4>]
     		                       }
     		                    } 
     		          }}
              #break
              #range(0.75,1)
                 object {Little_Grass scale <1,1,-1> rotate <-90,0,0> translate<c_x / 2.7 , 7.88,(-200 + (c_z / 4))> 	texture { pigment { gradient y
     		                    turbulence 0.5
     		                       color_map {
     		                       [0.0 color <0.3,0.9,0.2>]
     		                       [0.5 color <0.3,0.7,0.2>]
     		                       [0.9 color < 1, 1,0.2>]
     		                       }
     		                    } 
     		          }}
              #break
           #end
             
           #declare c_x = c_x + 1;
        
        #end
     
        #declare c_z = c_z + 1;
     
     #end
     
     
     #declare RBGrass = seed (20);
     
     #declare c_i = 0;
     #while (c_i < 60)
        #declare p_x = (rand(RBGrass) * 30) - 15.5;
        #declare p_z = (rand(RBGrass) * 25) + 191;
          object {Big_Grass scale <1,1,1> rotate <-90,0,0> translate <p_x, 8.0, - p_z>
                  texture { pigment { gradient y 
     		                    turbulence 0.5
     		                       color_map {
     		                       [0.0 color <0.4,0.7,0.5>]
     		                       [0.5 color <0.6,0.8,0.3>]
     		                       [0.9 color <1.0,1.0,0.2>]
     		                       }
     		                    } 
     		          } }
        #declare c_i = c_i + 1;
     #end
#end //Grass

// *************************************************************************************************
// ** "Wesen" im Vordergrund                                                                      **
// *************************************************************************************************

// ------- PFERD -----------------------------------------------------------------------------------

#if (Horse = 1)
     
     #include "Horse.inc"
     #include "hair.inc"
     
     #declare  Horse_1  = object { union {
        object { Horse_Begging }
        object { TAIL }
         }
     }
     
     object { Horse_1 rotate <0,-60,0> translate <1.2,7.825,-195.5> } 

# end //Horse

// ------- EINHORN ---------------------------------------------------------------------------------

#if (Unicorn = 1)

     #include "unicorn.inc"
     #include "unicorn_hair.inc"
     
     #declare Uni_Horn = blob {
     
        #declare i_horn = 0;
        
        #while (i_horn < 220)
           #declare diameter = (10 - (i_horn / 27.5) );
           sphere { <0,0,0> diameter * 0.6 , 1.2 translate <  (diameter * 0.10), i_horn / 2 ,0> rotate <0, i_horn * 5, 0>
             texture { T_Stone17 }
           }
           sphere { <0,0,0> diameter * 0.3 , 1.2 translate <- (diameter * 0.40), i_horn / 2 ,0> rotate <0, i_horn * 5, 0>
             texture { T_Stone13 }
           }
           sphere { <0,0,0> diameter * 0.2  , 1.2 translate < (diameter * 0.50), i_horn / 2 ,0> rotate <0, i_horn * 5, 0>
             texture { T_Gold_4C finish {ambient 2.5}}
           }
           #declare i_horn = i_horn + 1;
        #end
     }
     
      
     #declare UNICORN_1 = union{
        object { Unicorn }
        object { unicorn_tail }
        object { Uni_Horn scale 0.0025 rotate <60,0,0> translate <0,0.65,.48>}
     }
     
     object { UNICORN_1 rotate <0,120,0> translate <-0.95, 7.825, -197> }

#end //Unicorn

// ------- ELF -------------------------------------------------------------------------------------

#if (Elf = 1)

     #include "elf.inc"
     object{ ELF rotate <0,-100,0> translate <-0.31, 7.850, -197.35> }
     
#end //Elf

// ------- STUFF  ----------------------------------------------------------------------------------

#if (PicnicOn = 1)
     
     #include "picnic.inc"
     object {PICNIC rotate <0,30,0> scale 0.55  translate <0.3,7.91,-197.3>}

#end //Picnic

#if (WeaponsOn = 1)

     #include "weapons.inc"
     object {WEAPONS scale 0.2 rotate <0,40,0> translate <0.6,7.81, -197.6>}

# end //Weapons

#if (TempleOn = 1)
     
     #include "temple.inc"
     object {TEMPLE rotate <0,30,0> translate <5.0,7.3,-190>}
#end //Temple

#if (ClothingOn = 1)

     #include "clothing.inc"
     object {CLOTHING rotate<0,20,0> scale 0.3 translate <0.75,7.9,-197.2>}
     
#end //Clothing