//Jungle Temple   (c) Ch. Gerber, 2001

#version unofficial MegaPov 0.7;

global_settings {assumed_gamma 2.6 max_trace_level 150}

#declare VegeOn = true;
#declare CloudsOn = true;
#declare FigureOn = true;

#include "colors.inc"
#include "mytextures.inc"
#include "temple.inc"
#include "bird.inc"
#if (VegeOn = true) #include "plants.inc" #end

camera {
  location <0,15,-120>
  direction 1.5*z
  right 4/3*x
  look_at <-5,27,0>
  rotate 30*y
}


//--- Sun and sky ---

light_source {-10000*z color rgb 1.25*<1.2,1.0,0.8>  rotate 45*x}
light_source {<-1000,1000,-1000> color Orange*0.5 shadowless media_interaction off}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 color rgb <1,0.8,0.3>] 
      [0.1 color rgb <1,0.8,0.3>]
      [0.5 color SkyBlue]
      [1.0 color Blue]
    }    
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 7
    omega 0.5
    lambda 2.5
    color_map {
      [0.0 color rgbf <0.75,0.75,0.75,0.1>]
      [0.4 color rgbf <0.9,0.9,0.9,0.9>]
      [0.7 color rgbf <1,1,1,1>]
    }
    scale 0.6
    scale <1,0.3,0.3>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 8
    omega 0.5
    lambda 2.6
    color_map {
      [0.0 color rgbf <0.375,0.375,0.375,0.2>]
      [0.4 color rgbf <0.45,0.45,0.45,0.9>]
      [0.6 color rgbf <0.5,0.5,0.5,1>]
    }
    scale 0.6
    scale <1,0.3,0.3>
  }
}

#if (CloudsOn = true)

box {
  <-30000,2000,-30000> <30000,2300,30000> hollow
  material {
    texture {pigment {rgbf 1}}
    interior {
      media {
        scattering {5, 0.0005 extinction 0.5 eccentricity 0.1}
        method 3
        intervals 1
        samples 25,25
        aa_level 4
        jitter 0.1                                 
        density {
          bozo
          color_map {
            [0.0  rgb 0]
            [0.55 rgb 0]
            [0.55 rgb <0.7,0.7,0.9>]
            [1.0  rgb <0.9,0.9,1.0>]
          }
          scale <500,200,400>
          octaves 6
          lambda 2
          omega 0.65
          turbulence 0.5
          scale <2.5,2,2.5>
          translate <0,850,0>
        }
      }
    }
  } 
  scale 0.8
}

#end

fog {
  fog_type 2
  color rgb <1,0.88,0.79>
  distance 2000
  fog_alt 50
  fog_offset 1
}


//--- Water ---

box {
  <-5000,-15,-1000> <5000,0,5000> hollow
  material {
    texture {WaterTex}
    interior {
      ior 1.33
      caustics 0.5
      media {
        absorption <1,0.3,0.6>
        method 3
        intervals 1
      }
    }
  }      
}
 
plane {y, -15 texture {MossTex scale 0.01}}


//--- Background mountains ---

#declare VegeObject = height_field {
  tga "Range.tga" smooth translate <-0.5,0,-0.5> scale <2500,600,2500> translate -15*y 
  texture {
    slope y
    texture_map {
      [0.0  RockTex]
      [0.55 RockTex]
      [0.65 MossTex scale 0.01]
    }
  }
}
 
#if (VegeOn = true)

#declare VegeList = array[3] 
#declare VegeList[0] = object {Shrub2 scale 50} 
#declare VegeList[1] = object {Shrub1 scale 50}
#declare VegeList[2] = object {Shrub3 scale 50}
#declare VegeSeed = seed(2001);
#declare VegeNumber = 10000;
#declare VegeWaterLevel = -1.0;
#declare VegeTimberLine = 565;
#declare VegeMaxSlope = 90;
#declare VegeMaxScale = 1.5; 
#declare VegeMinScale = 0.5; 
#declare VegeTypesGauss = on;
#declare VegeMinBox =  <-1250,0>;
#declare VegeMaxBox =  < 1250,1250>;

#declare Range = union {
  object {VegeObject}
  union {#include "vegetate.inc"}
}  

#else

#declare Range = object {VegeObject}

#end

object {Range rotate  280*y translate <1400,0,1000>}  
object {Range rotate -220*y translate < 700,0,2300>}


//--- Small background islands ---
 
#declare VegeObject = height_field {
  tga "island_1.tga" smooth translate <-0.5,0,-0.5> scale <60,20,60> translate -15*y 
  texture {
    slope y
    texture_map {
      [0.0 RockTex]
      [0.7 RockTex]
      [0.9 MossTex scale 0.01]
    }
  }
}

#if (VegeOn = true)

#declare VegeList = array[7] 
#declare VegeList[0] = object {Bush_large} 
#declare VegeList[1] = object {Bush_small}
#declare VegeList[2] = object {Shrub2 scale 5}
#declare VegeList[3] = object {Shrub1 scale 5}
#declare VegeList[4] = object {Shrub1 scale 5}
#declare VegeList[5] = object {Shrub3 scale 5}
#declare VegeList[6] = object {Bush_small}
#declare VegeSeed = seed(1531);
#declare VegeNumber = 500;
#declare VegeWaterLevel = -1.0;
#declare VegeMaxSlope = 75;
#declare VegeMaxScale = 1.5; 
#declare VegeMinScale = 0.5;
#declare VegeTypesGauss = on;
#declare VegeMinBox =  <-30,-30>;
#declare VegeMaxBox =  < 30, 30>;

#declare Island_1 = union {
  object {VegeObject}
  union {#include "vegetate.inc"}
}

#else

#declare Island_1 = object {VegeObject}

#end  

object {Island_1 rotate 90*y translate <150,0,100>}  
object {Island_1 translate <-20,0,200>}

#if (VegeOn = true)

#declare Inter = trace(Island_1,<0,50,5>,<0,-1,0>);
object {Tree scale 0.9 rotate 100*y translate Inter rotate 90*y translate <150,0,100>} 

#declare Inter = trace(Island_1,<5,50,5>,<0,-1,0>);
object {Bush_large rotate 60*y scale 1.4 translate Inter translate <-20,0,200>} 

#declare Inter = trace(Island_1,<-5,50,-5>,<0,-1,0>);
object {Bush_large rotate -60*y scale 1.8 translate Inter translate <-20,0,200>} 

#end


//--- Main island and temple ---

#declare Island_2 = height_field {
  tga "island_2.tga" smooth translate <-0.5,0,-0.5> scale <120,20,120> translate -15*y 
  texture {
    slope y
    texture_map {
      [0.0 RockTex]
      [0.7 RockTex]
      [0.9 MossTex scale 0.01]
    }
  }
}


union {
  object {Island_2}
  object {
    Temple
    texture {
      gradient y
      turbulence 0.1
      lambda 6
      texture_map {
        [0.0  MossTex scale 0.01 scale 1/50]
        [0.22 MossTex scale 0.01 scale 1/50]
        [0.32 WallTex scale 1/50]
        [1.0  WallTex scale 1/50]
      }  
      scale 50 translate -13*y
    }
    translate <2,0.5,5>  
  }
  #if (VegeOn=true)
  object {Rose1 rotate -90*y scale 12 translate <-18.52, 0, 1> translate <2,0.5,5>}
  object {Rose1 rotate  90*y scale 17 translate <-18.52,-2,-8> translate <2,0.5,5>}
  object {Rose1 rotate -90*y scale 13 translate <-18.52, 0, 5> translate <2,0.5,5>}
  object {Rose2 scale 20 translate <-16,-6,-16> translate <2,0.5,5>}
  #end
}

#if (VegeOn = true)

#declare VegeObject = object {Island_2}
#declare VegeList = array[7] 
#declare VegeList[0] = object {Bush_large} 
#declare VegeList[1] = object {Bush_small}
#declare VegeList[2] = object {Grass}
#declare VegeList[3] = object {Grass}
#declare VegeList[4] = object {Grass}
#declare VegeList[5] = object {Fern}
#declare VegeList[6] = object {Grass}
#declare VegeSeed = seed(1968);
#declare VegeNumber = 1000;
#declare VegeWaterLevel = -1.0;
#declare VegeMaxSlope = 75;
#declare VegeMaxScale = 1.5; 
#declare VegeMinScale = 0.5;
#declare VegeTypesGauss = on;
#declare VegeMinBox =  <-60,-60>;
#declare VegeMaxBox =  < 60, 60>;
#declare VegeExcludeBox = array[1][2] 
#declare VegeExcludeBox[0][1] = <-18,-15>; 
#declare VegeExcludeBox[0][0] = < 22, 25>;

#include "vegetate.inc"

#declare VegeList = array[3] 
#declare VegeList[0] = object {Shrub2 scale 5} 
#declare VegeList[1] = object {Shrub1 scale 5}
#declare VegeList[2] = object {Shrub3 scale 5}
#declare VegeSeed = seed(1291);
#declare VegeWaterLevel = 0.0;

#include "vegetate.inc"

#declare Inter = trace(Island_2,<-30,50,5>,<0,-1,0>);
object {Tree scale 0.8 translate Inter} 

#declare Inter = trace(Island_2,<5,50,40>,<0,-1,0>);
object {Tree rotate 90*y translate Inter} 

#declare Inter = trace(Island_2,<-5,50,50>,<0,-1,0>);
object {DeadTree rotate <95,-30,0> translate Inter}
 
#end


//--- Birds ---

#declare BoxMin = <-300, 15, 50>;
#declare BoxMax = < 300,200,500>;
#declare NBirds = 150;
#declare BirdSeed = seed(1);
#declare Count = 0;
#while (Count<NBirds)
  object {
    Bird scale 0.3
    rotate <-10+20*rand(BirdSeed),360*rand(BirdSeed),-10+20*rand(BirdSeed)>
    translate (BoxMax-BoxMin)*<rand(BirdSeed),rand(BirdSeed),rand(BirdSeed)>+BoxMin
  }
  #declare Count = Count + 1;
#end  


//--- Figure ---

#if (FigureOn = true)

#include "boat.inc"
object {Boat scale 1.5 rotate 90*y translate <2,2.5,-30>} 

#include "figure.inc"
object {Figure scale 7 rotate 90*y translate <-2.8, -2.5, 0.05> scale 1.5 rotate 90*y translate <2,2.5,-30>}

#end
