#include "roundbox.mcr"

#macro Arc(WallRad,ArcRad,Rad,Height)
  #local SP = <-ArcRad,0,0>;
  #local Count = 0;
  #local Inc = 5;
  #while (Count < 36)
    #local Rot = Inc*Count;
    #local P1 = vaxis_rotate(SP,z,-Rot);
    #local P1 = P1+<0,0,-sqrt(WallRad*WallRad-ArcRad*cos(radians(Rot))*ArcRad*cos(radians(Rot)))>;
    #if (Count=0) cylinder{P1,P1+y*Height,Rad} #end
    #local Rot = Inc*(Count+1);
    #local P2 = vaxis_rotate(SP,z,-Rot);
    #local P2 = P2+<0,0,-sqrt(WallRad*WallRad-ArcRad*cos(radians(Rot))*ArcRad*cos(radians(Rot)))>;
    sphere {P1+y*Height,Rad}
    cylinder {P1+y*Height,P2+y*Height,Rad}
    #local Count = Count + 1;
  #end
  sphere {P2+y*Height,Rad}
  cylinder{P2,P2+y*Height,Rad}
#end  

#declare Dome = union {
  difference { //wall
    difference {
      cylinder {<0, 0,0>,<0,27,0>,12}
      cylinder {<0,-2,0>,<0,29,0>,11.4}
    }
    box {<-3,0,-13>,<3,7,-10>}
    cylinder {<0,7,-13>,<0,7,-10>,3}
  } 
  superellipsoid {<1,0.01> rotate 90*x scale 13 translate -13*y texture {WallTex}} //socket
  union { //stairs
    cylinder {<0,0,0>,<0,0.3,0>,12}
    cylinder {<0,0,0>,<0,0.6,0>,11.7}
    cylinder {<0,0,0>,<0,0.9,0>,11.4}
    texture {MarbleTex}
  }  
  union { //door
    union {Arc(12.0,3.0,0.3,7)}
    union {Arc(11.7,2.7,0.3,7)}
    union {Arc(11.4,2.4,0.3,7)}  
    texture {MarbleTex}
  }
  sphere {0,1 scale <0.4,0.8,0.4> translate <0,11.5,-12> texture {GoldTex}} //door ornament
  union { //roof base
    torus {12.0,0.5 translate 27.0*y}
    torus {12.4,0.5 translate 27.5*y}
    torus {12.7,0.5 translate 28.0*y}
    texture {GoldTex}
  }
  sphere {0,15 scale <1,0.8,1> translate 34*y texture {RoofTex scale 0.3}} //roof
}


#declare Tower = union {
  difference { //wall
    difference {
      cylinder {<0,-15,0>,<0,28,0>,3.5}
      cylinder {<0,  0,0>,<0,29,0>,3.1}
    }
    box {<-1,21,-4>,<1,24,-2>}
    cylinder {<0,24,-4>,<0,24,-2>,1}
  }
  object {RoundBox(<-1.2,-0.2,-0.2>,<1.2,0.2,0.4>,0.1) translate <0,21,-3.5> texture {MarbleTex}} //window shelf
  union { //roof ornament
    torus {3.5,0.25}
    #local N = 16;
    #local RT = 3.5;
    #local RS = RT*sin(radians(360/(2*N)));
    #local Count = 0;
    #while (Count < N)
     sphere {0,RS scale <1,1,0.5> translate -RT*z rotate Count*360/N*y translate (0.25+RS)*y}
     #local Count = Count + 1;
    #end
    torus {3.5,0.3 translate (0.25+2*RS+0.3)*y}
    translate 26*y
    texture {MarbleTex}
  }
}

#declare TowerRoof = object {
  lathe {
    cubic_spline
    11,
    <0.000000,0.200000>,
    <0.000000,0.200000>,
    <0.010000,0.195000>,
    <0.030000,0.180000>,
    <0.050000,0.150000>,
    <0.060000,0.100000>,
    <0.050000,0.050000>,
    <0.030000,0.020000>,
    <0.011000,0.005000>,
    <0.000000,0.000000>,
    <0.000000,0.000000>
  }
  scale <70,65,70> 
  translate 24.75*y
}

#declare Orn_1_a = union {
   box {<-1,0,-0.7>,<1,0.5,0.7>}
   cylinder {<0,0.5,-0.7>,<0,0.5,0.7>,1}
   texture {MarbleTex}
}   

#declare Orn_1_b = union {
   box {<-0.8,-1,-0.5>,<0.8,0.5,0.5>}
   cylinder {<0,0.5,-0.5>,<0,0.5,0.5>,0.8}
}

#declare Orn_1 = union {
   difference {
      object {Orn_1_a}
      object {Orn_1_b scale <1,1,2>}
   }
   object {Orn_1_b}
}

#declare Orn_2_a = union {
   cylinder {<0,0,-0.7>,<0,0,0.7>,0.6}
   box {<-0.6,0,-0.7>,<0.6,3.5,0.7>}
   cylinder {<0,3.5,-0.7>,<0,3.5,0.7>,1.1}
   texture {MarbleTex}
}

#declare Orn_2_b = union {
   cylinder {<0,0,-2>,<0,0,2>,0.4}
   box {<-0.4,0,-2>,<0.4,3.5,2>}
   cylinder {<0,3.5,-2>,<0,3.5,2>,0.9}
}

#declare Orn_2 = difference {
   object {Orn_2_a}
   object {Orn_2_b}
}   

#declare Orn_3 = union {
   box {<-1,0,-2>,<1,1,2>}
   cylinder {<0,1,-2>,<0,1,2>,1}
}   

#declare Orn_4 = union {
   box {<-0.3,-1,-2>,<0.3,2,2>}
   box {<-0.5,-0.3,-2>,<0.5,0.3,2>}
   cylinder {<0,-1,-2>,<0,-1,2>,0.3}
   cylinder {<0,2,-2>,<0,2,2>,0.3}
   cylinder {<0,2.8,-2>,<0,2.8,2>,0.3}
   cylinder {<-0.5,0,-2>,<-0.5,0,2>,0.3}
   cylinder {<0.5,0,-2>,<0.5,0,2>,0.3}
}   

#declare Door_a = union {
   cylinder {<0,9,-0.7>,<0,9,0.7>,4.4}
   box {<-4.4,-2,-0.7>,<4.4,9,0.7>}
   #local Count = 0;
   #while (Count<10)
    cylinder {<0,0,-0.7>,<0,0,0>,0.3 translate 4.7*x rotate Count*20*z translate 9*y}
    #local Count = Count + 1;
   #end
   #local Count = 0;
   #while (Count<5)
    cylinder {<0,0,-0.7>,<0,0,0>,0.3 translate < 4.7,7.4-1.6*Count,0>}
    cylinder {<0,0,-0.7>,<0,0,0>,0.3 translate <-4.7,7.4-1.6*Count,0>}
    #local Count = Count + 1;
   #end   
   texture {MarbleTex}
}
   
#declare Door_b = union {
   cylinder {<0,9,-2>,<0,9,2>,4}
   box {<-4,-2,-2>,<4,9,2>}
}

#declare Door_c = union {
   difference {
      union {               
         cylinder {<0,9,-0.2>,<0,9,0.2>,4.4}
         box {<-4.4,1.5,-0.2>,<4.4,9,0.2>}
      }
      box {<0,-2,-1>,<6,15,1>}
      texture {WoodTex scale <1.5,10,1.5>}
   }
   #local Count = 0;
   #while (Count<9)
    cylinder {<0,2,0>,<0,-1.8,0>,0.15 translate (-4.2+Count*0.5)*x texture {MetalTex}}
    #local Count = Count + 1;
   #end
   object {RoundBox(<-4.1,0.2,-0.17>,<-0.1,0.4,0.17>,0.05) texture {MetalTex}}
}        
   
#declare Door = union {
   difference {
      object {Door_a}
      object {Door_b}
   }
   object {Door_c translate 4.4*x rotate -60*y translate -4.4*x}
   object {Door_c rotate 180*y translate -4.4*x rotate 60*y translate 4.4*x}   
}
   
#declare Side = union {
   difference {
     box {<-16,-15,-0.5>,<16,20.5,0.5>}
     object {Orn_2_b translate <-10.5,15,0>}
     object {Orn_2_b translate < 10.5,15,0>}
   }  
   object {RoundBox(<-16.2,20.5,-0.7>,<16.2,21,0.7>,0.1) texture {MarbleTex}}
   #local Count = 0;
   #while (Count<9)
    object {Orn_1 translate <-12+3*Count,21,0>}
    #local Count = Count + 1;
   #end
   object {Orn_2 translate <-10.5,15,0>}
   object {Orn_2 translate < 10.5,15,0>}   
}   

#declare Front = union {
   difference {
      object {Side}
      object {Door_b}
      #local Count = 0;
      #while (Count<5)
       object {Orn_3 translate <-6+3*Count,15,0>}
       #local Count = Count + 1;
      #end
      object {Orn_4 translate <-6.5,2.6,0>}
      object {Orn_4 translate < 6.5,2.6,0>}
   }
   object {Door}
}   

#declare Temple = union {
  object {Dome}
  object {Tower translate < 16,0,-16>}
  object {Tower translate <-16,0,-16>}
  object {Tower rotate 180*y translate < 16,0,16>}
  object {Tower rotate 180*y translate <-16,0,16>}
  union {
    object {TowerRoof translate < 16,0,-16>}
    object {TowerRoof translate <-16,0,-16>}
    object {TowerRoof rotate 180*y translate < 16,0,16>}
    object {TowerRoof rotate 180*y translate <-16,0,16>}
    texture {RoofTex scale 0.3}
  }
  object {Front translate -18*z}
  object {Side translate 18*z}
  object {Side rotate 90*y translate  18*x}
  object {Side rotate 90*y translate -18*x}
}

  