#version unofficial MegaPov 0.7;

#declare Paint = function {
  pigment {
    granite scale 30
    color_map {
      [0.0  rgb 0.0]
      [0.1  rgb 0.1]
      [0.15 rgb 0.7]
      [0.2  rgb 0.75]
      [0.21 rgb 1.0]
      [0.25 rgb 0.6]
      [0.7  rgb 0.0]
      [1.0  rgb 0.5]
    }
  }
}
                 
#declare B = 1.0;
                 
#declare RoofTex = texture {
  pigment {
    granite scale 60
    color_map {
      [0.1  rgb B*<0.694, 0.474, 0.454>]
      [0.18 rgb B*<0.725, 0.495, 0.451>]
      [0.2  rgb B*<0.694, 0.474, 0.454>]
      [0.21 rgb B*<0.800, 0.491, 0.457>]
      [1.0  rgb B*<0.796, 0.435, 0.437>]
    }
  }
  normal {function {Paint} 0.5}
  finish {ambient 0.2 diffuse 0.8 crand 0.05}
}

#declare WallTex = texture {
  pigment {
    granite
    turbulence 0.4
    octaves 3
    lambda 4
    omega 0.7
    color_map {
      [0.000, 0.154 color rgb B*<0.800, 0.791, 0.757> color rgb B*<0.796, 0.735, 0.737>]
      [0.154, 0.308 color rgb B*<0.796, 0.735, 0.737> color rgb B*<0.800, 0.791, 0.757>]
      [0.308, 0.444 color rgb B*<0.800, 0.791, 0.757> color rgb B*<0.694, 0.674, 0.654>]
      [0.444, 0.615 color rgb B*<0.694, 0.674, 0.654> color rgb B*<0.800, 0.791, 0.757>]
      [0.615, 0.812 color rgb B*<0.800, 0.791, 0.757> color rgb B*<0.725, 0.695, 0.651>]
      [0.812, 1.001 color rgb B*<0.725, 0.695, 0.651> color rgb B*<0.800, 0.791, 0.757>]
    }
    scale 2
  } 
  normal {function {Paint} 0.5}
  finish {ambient 0.2 diffuse 0.8 crand 0.05}
}

#declare MarbleTex = texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000, 0.154 color rgb <0.996, 0.969, 0.800> color rgb <0.996, 0.682, 0.604>]
      [0.154, 0.308 color rgb <0.996, 0.682, 0.604> color rgb <0.906, 0.820, 0.714>]
      [0.308, 0.444 color rgb <0.906, 0.820, 0.714> color rgb <0.816, 0.631, 0.537>]
      [0.444, 0.615 color rgb <0.816, 0.631, 0.537> color rgb <0.890, 0.792, 0.675>]
      [0.615, 0.812 color rgb <0.890, 0.792, 0.675> color rgb <0.973, 0.627, 0.627>]
      [0.812, 1.001 color rgb <0.973, 0.627, 0.627> color rgb <0.996, 0.969, 0.800>]
    }
  }
  finish {ambient 0.15 diffuse 0.8}
  scale <2, 3, 2> rotate 40*z
}
texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000, 0.034 color rgbf <0.027, 0.012, 0.012, 0.000> color rgbf <0.851, 0.812, 0.741, 0.235>]
      [0.034, 0.342 color rgbf <0.851, 0.812, 0.741, 0.235> color rgbf <0.792, 0.694, 0.690, 0.839>]
      [0.342, 0.462 color rgbf <0.792, 0.694, 0.690, 0.839> color rgbf <0.631, 0.506, 0.471, 0.608>]
      [0.462, 0.632 color rgbf <0.631, 0.506, 0.471, 0.608> color rgbf <0.851, 0.812, 0.741, 0.922>]
      [0.632, 0.983 color rgbf <0.851, 0.812, 0.741, 0.922> color rgbf <0.647, 0.655, 0.655, 0.282>]
      [0.983, 1.001 color rgbf <0.647, 0.655, 0.655, 0.282> color rgbf <0.027, 0.012, 0.012, 0.000>]
    }
  }
  finish {ambient 0.15 diffuse 0.8}
  scale <2, 3, 2> rotate -30*z
}
texture {
  pigment {
    marble
    turbulence 0.85
    color_map {
      [0.0,  0.04  color Black   filter 0.6  color Black   filter 1.0]
      [0.04, 0.97  color Scarlet filter 0.8  color DimGray filter 0.9]
      [0.97, 1.001 color Black   filter 0.9  color Black   filter 1.0]
    }
  }
  scale <1, 2, 1.4> rotate <10, 0, -20>
  finish {phong 1.0 phong_size 90 ambient 0.2 diffuse 0.9}
}

#declare GoldTex = texture {
  wrinkles scale 0.1 warp {reset_children}
  texture_map {
    [0 pigment { rgb <1,0.7,0.3>}
       finish {ambient 0.15 diffuse 0.7 reflection_max 0.4 reflection_min 0.2 reflect_metallic metallic specular 1 roughness 0.01 brilliance 5}
       normal {dents 0.35 scale 0.05}
    ]
    [1 pigment {rgb <1,0.75,0.4>}
       finish {ambient 0.2 diffuse 0.8 reflection_max 0.3 reflection_min 0.1 reflect_metallic metallic specular 0.7 roughness 0.04 brilliance 5}
       normal {dents 0.5 scale 0.01}
    ]
  }
}

#declare WoodTex = texture {
  pigment {
    bozo
    turbulence 0.04
    color_map {
      [0.000 rgb <0.404, 0.310, 0.278>]
      [0.256 rgb <0.431, 0.325, 0.290>]
      [0.393 rgb <0.447, 0.333, 0.290>]
      [0.581 rgb <0.404, 0.310, 0.275>]
      [0.726 rgb <0.459, 0.322, 0.302>]
      [0.983 rgb <0.431, 0.325, 0.286>]
      [1.000 rgb <0.404, 0.310, 0.278>]
    }
    scale <0.5, 0.5, 1>
    translate <10, 0, 0>
  }
  finish {ambient 0.2 diffuse 0.8 crand 0.05}
}
texture {
  pigment {
    wood
    turbulence 0.04
    color_map {
      [0.000 rgbf <0.745, 0.549, 0.447, 1.000>]
      [0.139 rgbf <0.000, 0.000, 0.000, 0.008>]
      [0.148 rgbf <0.000, 0.000, 0.000, 0.004>]
      [0.287 rgbf <0.745, 0.549, 0.447, 1.000>]
      [0.443 rgbf <0.745, 0.549, 0.447, 1.000>]
      [0.626 rgbf <0.000, 0.000, 0.000, 0.008>]
      [0.635 rgbf <0.000, 0.000, 0.000, 0.008>]
      [0.843 rgbf <0.745, 0.549, 0.447, 1.000>]
    }
    scale <0.5, 0.5, 1>
    translate <10, 0, 0>
  }
  finish {ambient 0.2 diffuse 0.8 crand 0.05}
}

#declare MetalTex = texture {  
  pigment {rgb <0.39,0.41,0.43>} 
  normal {wrinkles 1 turbulence 0.5 scale 0.05} 
  finish {ambient 0.2 diffuse 0.8 phong 0.15 phong_size 5 brilliance 4 metallic}
}

#declare B = 0.7;

#declare MossTex = texture {
  pigment {
    bozo
    color_map {
      [0.00 color rgb B*<0.200, 0.412, 0.247>]
      [0.12 color rgb B*<0.345, 0.600, 0.325>]
      [0.32 color rgb B*<0.020, 0.322, 0.067>]
      [0.49 color rgb B*<0.557, 0.761, 0.600>]
      [0.59 color rgb B*<0.192, 0.694, 0.298>]
      [0.80 color rgb B*<0.118, 0.412, 0.051>]
      [1.00 color rgb B*<0.420, 0.667, 0.455>]
    }
    scale 0.025
  }
  finish {ambient 0.2 diffuse 0.8}
}
texture {
  pigment {
    agate
    agate_turb 0.8
    color_map {
      [0.00 color rgbf <B*0.780, B*0.941, B*0.729, 0.761>]
      [0.22 color rgbf <B*0.561, B*0.757, B*0.580, 0.278>]
      [0.50 color rgbf <B*0.592, B*0.737, B*0.604, 0.098>]
      [0.64 color rgbf <B*0.098, B*0.761, B*0.329, 0.761>]
      [0.79 color rgbf <B*0.357, B*0.675, B*0.251, 0.506>]
      [0.87 color rgbf <B*0.102, B*0.490, B*0.204, 0.694>]
      [1.00 color rgbf <B*1.000, B*1.000, B*1.000, 0.365>]
    }
    scale 0.05
  }
  finish {ambient 0.2 diffuse 0.8 crand 0.1}
}

#macro m_strata (freq, amnt)
  function {noise3d(y*freq+noise3d(y+noise3d(x*4,y*4,z*4),z,x)*amnt,0,0)}
#end

#declare RockTex = texture {
  pigment {
    m_strata (5, 1)
    turbulence 0.5
    color_map {
      [0.00 0.29 color Gray80*B color Gray85*B]
      [0.29 0.31 color Gray85*B color Gray80*B]
      [0.31 0.43 color Gray80*B color White*B ]
      [0.43 0.64 color White*B  color Gray80*B]
      [0.64 0.69 color Gray80*B color Gray95*B]
      [0.69 1.00 color Gray95*B color Gray80*B]
    }
  }
  finish {ambient 0.2 diffuse 0.8}
  normal {crackle 0.4 turbulence 0.5 scale <2, 4, 2>}
  rotate 10*z
}
texture {
  pigment {
    crackle
    turbulence 0.5
    form <1, 0, 0>
    color_map {
      [0.0 color rgbf <0.9, 0.8, 0.8, 0.6>]
      [0.2 color Gray85*B filter 0.6]
      [0.4 color Gray75*B filter 0.6]
      [0.6 color White*B  filter 0.6]
      [1.0 color rgb <0.9, 0.8, 0.7>*B filter 0.6]
    }
    scale <1, 3, 1>   
  }
  finish {ambient 0.2 diffuse 0.8}
  normal {crackle 0.4 turbulence 0.5 scale <2, 4, 2>}
  rotate 10*z
}

#declare BushBarkTex = texture {
  pigment {
    granite
    color_map {
      [0.00 color rgb <0.608, 0.596, 0.424>]
      [0.24 color rgb <0.588, 0.514, 0.392>]
      [0.51 color rgb <0.651, 0.639, 0.451>]
      [0.52 color rgb <0.506, 0.408, 0.071>]
      [0.59 color rgb <0.498, 0.396, 0.071>]
      [0.60 color rgb <0.710, 0.698, 0.490>]
      [1.00 color rgb <0.718, 0.706, 0.490>]
    }
    scale 2
  }
  finish {ambient 0.2 diffuse 0.8}
  normal {wrinkles 0.8 turbulence 0.3}
  scale <0.05,0.05,0.1>
}

#declare BushLeafTex = texture {
  pigment {
    bozo
    warp {turbulence 0.1 octaves 3}
    scale 0.1
    warp {turbulence 0.01 octaves 3}
    pigment_map {
      [0.85 bozo turbulence 0.5 color_map {[0.3 color rgb <0.2,0.7,0.1>] [1 color rgb <0.4,0.5,0.1>]}]
      [0.86 color rgb <0.2,0.3,0.1>]
      [0.87 color rgb <0.2,0.3,0.1>]
      [0.90 color rgb <0.4,0.7,0.1>]
    }
  }
  normal {bumps 0.2 turbulence 0.4 scale 0.05}
  finish {ambient 0.2 diffuse 0.8 crand 0.1 phong 0.3 phong_size 30}
  scale 0.2
}

#declare Green1 = color rgb <0.393,0.745,0.118>;
#declare Green2 = color rgb <0.157,0.471,0.031>;

#declare PSpotted = pigment {
  spotted
  color_map {
    [0.0, 0.2  color Tan*0.1 color Tan*0.4]
    [0.2, 0.3  color Tan*0.4 color Green1]
    [0.3, 1.01 color Green1  color Green1*1.2]
  }
}

#declare PEarth = pigment {
   spotted
   color_map {
     [0   color Tan*0.3]
     [0.6 color Tan*0.3]
     [0.6 color Green1*0.4]
     [1   color Green1*0.4]
  }
}

#declare PGreen = pigment {Green2*1.3}

#declare GrassTex = texture {                  
  pigment {
    gradient y
    turbulence 0.2
    pigment_map {                                
      [0.0 PEarth]
      [0.3 PGreen]
      [0.9 PSpotted]
      [1.0 PEarth]
    }
  }
  finish {ambient 0.2 diffuse 0.8 specular 0.2 roughness 0.015}
  scale <0.06, 60, 0.06>
}

#declare FernTex = texture {BushLeafTex scale 100}

#declare Green3 = color rgb <0.46,0.80,0.16>;
#declare Green4 = color rgb <0.26,0.80,0.52>;

#declare TreeLeafTex = texture {
  pigment {
    agate 
    color_map {
      [0.0 color Green3]
      [0.3 color Green4] 
      [0.7 color Green4]
      [1.0 color Green3] 
    }
  }       
  finish {ambient 0.2 diffuse 0.8 specular 0.3 roughness 0.01} 
  scale 10
} 

#declare Brown1 = color rgb <2.0,1.6,1.02>;

#declare TreeBarkTex = texture {
  pigment {
    crackle 
    turbulence 0.4 
    lambda 3.2 
    color_map {
      [0.0 color Brown1*0.3]
      [0.1 color Brown1*0.4]
      [0.6 color Brown1*0.8] 
      [1.0 color Brown1*1.2]
    }
  }       
  finish {ambient 0.2 diffuse 0.8} 
  scale <0.2,0.7,0.2>
}

#declare DarkGreen = color rgb <0,0.5,0.2>;
#declare LightGreen = color rgb <0.2,1,0.2>;
#declare YellowGreen = color rgb <0.7,1,0>;

#declare ShrubTex1 = texture {
  pigment {
    radial
    turbulence 1  
    octaves 6  
    omega 8
    frequency 2 
    color_map {
      [0.0 color DarkGreen*0.7]
      [0.1 color DarkGreen] 
      [0.2 color DarkGreen*1.2] 
      [0.2 color Clear]
      [1.0 color Clear]
    }
  }
  finish {ambient 0.2 diffuse 0.8}
}    
 
#declare ShrubTex2 = texture {
  pigment {
    radial
    turbulence 1  
    octaves 6  
    omega 8
    frequency 2
    color_map {
      [0.05 color LightGreen*0.8]
      [0.1  color Brown]
      [0.15 color Brown]
      [0.2  color Clear]
      [1.0  color Clear]
    }
  }
  finish {ambient 0.2 diffuse 0.8}
}  

#declare ShrubTex3 = texture {
  pigment {
    radial
    turbulence 1
    octaves 6
    omega 8
    frequency 2 
    color_map {
      [0.05 color YellowGreen] 
      [0.15 color DarkGreen]
      [0.2  color Clear]
      [1.0  color Clear]
    }
  }
  finish {ambient 0.2 diffuse 0.8}
}

#declare _water = texture {
  pigment {color rgbf <0.8,1.0,0.9,0.9>}
  finish {
    ambient 0.0
    diffuse 0.0
    reflection_type 1
    reflection_min 0.4
    reflection_max 0.9
    conserve_energy
    phong 1
    phong_size 120
  }
  normal {
    bumps 0.15 
    turbulence 0.3
    frequency 50
    scale <4,1,2>
  }
}

#declare _waterlillies = texture {
  pigment {
    granite
    turbulence 0.5
    color_map {
      [0.0 color Green*0.35]
      [0.3 color Green*0.35]
      [0.3 color Clear]
      [1.0 color Clear]
    }
    scale 0.01
  }
  finish {
    ambient 0.2
    diffuse 0.8
    reflection_type 1
    reflection_min 0.4
    reflection_max 0.9
    conserve_energy
    phong 0.5
    phong_size 30
  }
}

#declare WaterTex = texture {
  granite
  turbulence 0.5
  texture_map {
    [0.0  _waterlillies]
    [0.05 _waterlillies]
    [0.1  _water]
    [1.0  _water]
  }
  scale 100
  warp {reset_children}
}    

#declare DeadTreeTex = texture {
  bozo
  turbulence 0.5
  texture_map {
    [0.0 MossTex scale 0.02]
    [0.6 MossTex scale 0.02]
    [0.9 TreeBarkTex scale 2]
    [1.0 TreeBarkTex scale 2]
  }
  scale 0.5
}

#declare B_Tex = texture {
  pigment {
    gradient x
    turbulence 0.3 octaves 2 omega 0.12 lambda 2.5
    color_map {
      [0.50 color rgb <1.0, 0.7, 0.0>]
      [1.00 color rgb <0.5, 0.4, 0.3>]
    }
    frequency 5
  }
  finish {
    ambient 0.2
    diffuse 0.8
    specular 1
    metallic
    reflection 0.15
  }
  rotate z*90
  scale <0.15, 0.15, 0.05>
}

#declare LeatherTex = texture {
  pigment {color Gray35}
  normal {wrinkles 0.2 turbulence 0.5 scale 0.001}
  finish {ambient 0.2 diffuse 0.8}
}

#declare TissueTex = texture {
  pigment {color rgbt <0.118, 0.757, 0.576, 0.6>}
  normal {wrinkles 0.5 turbulence 0.5 scale 0.01}
  finish {ambient 0.2 diffuse 0.8}
}  

#declare BrightGoldTex = texture {
  pigment {color BrightGold}
  finish {metallic 0.7 ambient 0.25 diffuse 0.9 brilliance 6 reflection 0.35 phong 0.75 phong_size 80}
}  