// includes
#declare metal01p = pigment {
        color rgb <0.7,0.7,0.7>
        turbulence 0
        omega 0.7
        octaves 7
        lambda 2
        scale <1,1,1>
        }
#declare metal01f = finish {
        ambient .1
        diffuse .5
        specular .1
        roughness 0.04
        reflection 0.23
        metallic
        }
#declare metal01n = normal {
        bumps 0.05
        scale <0.1,0.1,0.1>
        }
#declare wood01p = pigment {
        granite
        color_map {
                [ 0.33 color rgb <0.6,0.5,0.35> ]
                [ 0.66 color rgb <0.5,0.45,0.4> ]
                [ 0.99 color rgb <0.7,0.55,0.45> ]
                }
        turbulence 0
        omega 0.7
        octaves 7
        lambda 2
        scale <0.2,0.2,0.2>
        }        
#declare wood01f = finish {
        ambient .1
        diffuse .8
        specular .01
        roughness 0.01
        reflection 0.0
        }
#declare wood01n = normal {
        bumps 0.1
        scale <0.1,0.1,0.1>
        }
#declare man01p = pigment {
        granite
        color_map {
                [ 0.33 color rgbt <0.75,0.7,0.65,0.65> ]
                [ 0.66 color rgbt <0.68,0.65,0.6,0.85> ]
                [ 0.99 color rgbt <0.8,0.75,0.68,0.45> ]
                }
        turbulence 0
        omega 0.7
        octaves 7
        lambda 2
        scale <2,2,2>
        }        
#declare man01f = finish {
        ambient .1
        diffuse .8
        specular .01
        roughness 0.01
        reflection 0.0
        }
#declare man01n = normal {
        wrinkles 0.3
        scale <0.1,0.1,0.1>
        }
#declare blood01p = pigment {
        granite 
        pigment_map {
                [ 0.5 metal01p ]
                [ 0.6 color rgb <0.5,0.1,0.2> ]
                [ 0.7 metal01p ]
                }
        turbulence 0
        omega 0.7
        octaves 7
        lambda 2
        scale <2,2,2>
        }
#declare je01f = finish {
        ambient 0.1
        diffuse 0.8
        specular  0.2
        roughness 0.04
        reflection 0.3
        irid {
                0.35
                thickness 0.5
                turbulence 0.9
                }
        }
#declare rust01p = pigment {
        granite 
        pigment_map {
                [ 0.3 metal01p ]
                [ 0.5 color rgb <0.7,0.55,0.40> ]
                [ 0.6 color rgb <0.75,0.55,0.40> ]
                [ 0.8 metal01p ]
                }
        turbulence 0
        omega 0.7
        octaves 7
        lambda 2
        scale <0.2,0.2,0.2>
        }
#declare axe = union {
difference {        
        intersection {
                sphere { <0.22,0,0>,1 scale <0.2,1,1> }
                sphere { <-0.22,0,0>,1 scale <0.2,1,1> }
                }
        sphere { <0,0,0>,1 scale <1,1,1> translate <0,1.2,0> }
        sphere { <0,0,0>,1 scale <1,1,1> translate <0,-1.2,0> }
        texture { pigment { metal01p } pigment { blood01p } }
        finish { metal01f }
        normal { metal01n }
        }
        cone { 
                <0,0.5,0>,0.1,<0,-5.5,0>,0.1
                pigment { wood01p }
                finish { wood01f }
                normal { wood01n }
                }         
        blob {
                threshold 1
                #declare a=0;
                #while (a<35)
                #declare b=0;
                #while (b<5)
                sphere { 
                        <0,0,0>,0.1,2 
                        translate <0,-1.7-(0.1*a),0.08> 
                        rotate <0,360/5*b,0>
                        }
                #declare b=b+1;
                #end
                #declare a=a+1;
                #end
                pigment { wood01p }
                finish { wood01f }
                normal { wood01n }
                }
        translate <0,2,0> 
        }
#declare top = difference {
        object { axe }
        union {
                cone { <0,-2.5,0>,0.4,<0,-6.0,0>,0.4 }
                cone { <0,-2.6,0>,0.05,<0,-6.0,0>,0.05 }
                cone { <0.25,-2,0>,0.1,<-0.9,-6.0,0>,0.1 }
                cone { <0.1,-2,0.1>,0.1,<-0.2,-6.0,0>,0.1 }
                translate <0,2,0>
                pigment { wood01p }
                finish { wood01f }
                normal {
                        bumps 0.5
                        scale <0.1,0.1,0.1>
                        }
                }
        } 
#declare down = intersection {
        object { axe }
        union {
                cone { <0,-2.5,0>,0.4,<0,-6.0,0>,0.4 }
                cone { <0,-2.6,0>,0.05,<0,-6.0,0>,0.05 }
                cone { <0.25,-2,0>,0.1,<-0.9,-6.0,0>,0.1 }
                cone { <0.1,-2,0.1>,0.1,<-0.2,-6.0,0>,0.1 }
                translate <0,2,0>
                pigment { wood01p }
                finish { wood01f }
                normal {
                        bumps 0.5
                        scale <0.1,0.1,0.1>
                        }
                }
        }
#declare man = blob {
        threshold 1
        sphere { <0,0,0>,1.2,1.3 scale <0.9,1,1> }
        sphere { <0,0,0>,1,1 scale <0.9,1,1> translate <0,-0.2,-0.5>}
        sphere { <0,0,0>,1,1 scale <0.9,1,1> translate <0,-0.2,-0.5>}
        sphere { <0,0,0>,1,2 scale <0.9,0.5,0.6> translate <0.5,-0.8,0> }
        sphere { <0,0,0>,1,2 scale <0.9,0.5,0.6> translate <-0.5,-0.8,0> }
        sphere { <0,0,0>,2,2 scale <1,1,0.5> translate <0,-1.5,0> }
        sphere { <0,0,0>,2,2 scale <1,1,0.6> translate <0,-3,0> }
        sphere { <0,0,0>,2,2 scale <1,1,0.7> translate <0,-4,0> }
        cylinder { <0.8,-0.8,0>,<1.15,-5,0>,0.4,1.5 rotate <0,30,0> }
        cylinder { <0.8,-0.8,0>,<1.2,-5,0>,0.5,1.5 rotate <0,0,0> }
        cylinder { <0.6,-0.8,0>,<1.25,-5,0>,0.5,1.5 rotate <0,-30,0> }
        cylinder { <0.4,-0.8,0>,<1.15,-5,0>,0.55,1.5 rotate <0,-60,0> }
        cylinder { <0.25,-0.8,0>,<1.2,-5,0>,0.5,1.5 rotate <0,-90,0> }
        cylinder { <0.4,-0.8,0>,<1.2,-5,0>,0.45,1.5 rotate <0,-120,0> }
        cylinder { <0.6,-0.8,0>,<1.3,-5,0>,0.55,1.5 rotate <0,-150,0> }
        cylinder { <0.8,-0.8,0>,<1.25,-5,0>,0.5,1.5 rotate <0,-180,0> }
        cylinder { <0.8,-0.8,0>,<1.2,-5,0>,0.4,1.5 rotate <0,150,0> }
        pigment { man01p }
        finish { man01f }
        normal { man01n }
        }
#declare mud = height_field {
        tga "height01.tga" 
        smooth
        pigment { color rgb <0.7,0.6,0.45> }
        translate <-0.5,-0.5,-0.5>
        scale <60,2,70>
        normal {
                average
                turbulence 0.1
                scale <0.15,0.15,0.15>
                normal_map {
                        [ 0.5 bozo 0.15 ]
                        [ 0.5 granite 0.07 scale <0.1,0.1,0.1> ]
                        [ 1 bumps 0.05 ]
                        }
                }
        }
#declare rocks = height_field {
        tga "height01.tga" 
        smooth
        pigment { color rgb <0.7,0.7,0.7> }
        translate <-0.5,-0.5,-0.5>
        scale <60,8,70>
        normal {
                average
                turbulence 0.3
                scale <0.5,0.5,0.5>
                normal_map {
                        [ 0.33 bozo ]
                        [ 0.66 granite ]
                        [ 0.99 bumps ]
                        }
                }
        }
#declare mountain = height_field {
        tga "height02.tga"
        smooth
        pigment { color rgb <0.5,0.5,0.5> }
        translate <-0.5,-0.5,-0.5>
        rotate <0,180,0>
        scale <800,60,45>
        normal {
                average
                turbulence 0.3
                scale <0.5,0.5,0.5>
                normal_map {
                        [ 0.33 bozo 0.4 ]
                        [ 0.66 granite 0.4 ]
                        [ 0.99 bumps 0.4 ]
                        }
                scale <100,100,100>
                }
        }
#declare part = blob {
        threshold 1
        cylinder { <0.4,0,0.25>,<-0.4,0,0.25>,0.18,2 }
        cylinder { <0.4,0,-0.25>,<-0.4,0,-0.25>,0.18,2 }
        cylinder { <0.4,0,0.25>,<0.4,0,-0.25>,0.18,2 }
        cylinder { <-0.4,0,0.25>,<-0.4,0,-0.25>,0.18,2 }
        sphere { <0.4,0,0.25>,0.18,-2 }
        sphere { <0.4,0,-0.25>,0.18,-2 }
        sphere { <-0.4,0,0.25>,0.18,-2 }
        sphere { <-0.4,0,-0.25>,0.18,-2 }
        texture { 
                pigment { rust01p }
                }
        normal { metal01n }
        finish { 
                ambient .1
                diffuse .7
                specular .01
                roughness 0.01
                reflection 0.0
                }
        }
#declare chain = union {
        #declare a=0;
        #while (a<24)
        object { 
                part 
                rotate <360/4*a+(a*3)-20,0,0> 
                #if (a>5)
                #if (a<15)
                rotate <0,2*a-5,0>
                #end
                #end
                translate <0.55*a,0,0> 
                #if (a>5)
                #if (a<15)
                rotate <0,2*a-10,0>
                #else
                rotate <0,2*15-10,0>
                #end
                #end
                }
        #declare a=a+1;
        #end
        scale <0.5,0.5,0.5>
        translate <-4,0,0>
        }

               