#version unofficial MegaPov 0.7;

#include "colors.inc"
#include "alignthosestupidfeathers.pov" 
#include "Phoenix_nest.pov"

camera {
  location <3, -7, -72.5>
  look_at <0, 0, 1000>
}

//light_source {<0, 300, -200> White shadowless}
light_source {<5, 0, -55> White}

sky_sphere {
  pigment {
    image_map {
      png "stars.png"
      interpolate 2
    }
  rotate z*30
  scale .5
  }
}

/*#declare Smoke_Plane = plane {z, -60
  no_shadow
  pigment {
    marble
    scale 5
    turbulence 1
    color_map{
      [0.0 rgb 0.6]
      [0.2 rgbt 1]
      [1.0 rgbt 1]
    }
  }
}

#macro Smoke()
  #local sd = seed (56341);
  #local Position = 30;
  #while (Position < 360)
    //#local Rotation = 5*rand(sd);
    #local Rotation = 0;
    plane {z, (-72.5 + Position)
      no_shadow
      hollow
      texture {
        gradient y
        scale 100
        texture_map {
      [0.0 pigment {
        marble
        scale 1/20
        turbulence 1
        color_map{
          [0.0 rgb 0.6]
          [0.2 rgbt 1]
          [1.0 rgbt 1]
        }
      }]
      [1.0 pigment {rgbt 1}]
      }}
      rotate y*Rotation
    }
    #local Position = Position + 120;
  #end
#end*/

//Smoke()  

#declare Phoenix_Mountain = height_field {
  tga "phoenix_hf.tga"
  smooth
  water_level .3
}

object {Phoenix_Mountain
  translate -.5
  rotate y*15
  scale <180, 60, 360>
  texture {
    normal {granite scale 10}
    pigment {Gray10}
    finish {
      specular .25
      roughness .1
      reflection .25
      ambient .4
      diffuse .6
    }
  }
}

//Dale likes this one
/*object {Phoenix_Mountain
  translate -.5
  rotate y*15
  scale <180, 60, 360>
  texture {
    normal {granite scale 10}
    pigment {Gray20}
    finish {
      specular 1
      roughness .1
      reflection .75
    }
  }
}*/  

//moon
#declare PMoonMare=pigment {
  wrinkles 
  turbulence 0.2
  scale 0.5
  color_map { [0 rgb 1] [1 rgb 0] }
}

#declare PMoonCraters=
pigment {
  granite
  scale 0.2
  color_map{
    [0 rgb 1]
    [1 rgb 0]
  }
}

#declare TMoon=
texture{
  pigment {
    average
    pigment_map{
      [0.85 PMoonMare]
      [0.15 PMoonCraters]
    }
  }
  finish {ambient 0.001 diffuse 0.9}
}

union {
  light_source {
    0, color rgb <0.8, 0.8, 1>
    looks_like {
      sphere {0, 200
        texture {TMoon scale 200}
        rotate <0, 290, 30>
        translate <-1160, 1650, 5000>
      }
    }
  }

  sphere {0, 180
    translate <-1020, 1610, 4640>
    pigment {Black}
  }
}

//black hardened lava 
plane {y, -12
  texture {
    crackle
    turbulence 0.5
    scale 5
    texture_map {
      [0.0 pigment {rgbt 1}]
      [0.15 pigment {rgb 0.3} normal {granite scale .8 bump_size 1}]
      [1.0 pigment {rgb 0} normal {granite scale .8 bump_size 1}]
    }
  }  
}

//glowing lava
plane {y, -12.1
  pigment {
    crackle
    turbulence 2
    scale 2
    color_map {
      [0.0 Red]
      [0.5 OrangeRed]
      [1.0 Yellow]
    }
  }
  finish {ambient .9 diffuse 0}
}

fog {
  distance -50
  color rgbt<0.0, 0.25, 1.0, 0>
  fog_type 2
  fog_offset -10
  fog_alt 2
}

object {Phoenix translate <7, -7, -45>}

//glowing head feathers
#declare _r1 = 0;
#declare seed1 = seed (143);
#while (_r1 < 60)
  #local randnum = rand (seed1);
  glow {
    type 0
    location <0, 2.5, 0>
    size 0.03-randnum/100
    radius 1.4
    fade_power 1.24
    color Red
    rotate <_r1+2*randnum, 0, 5*randnum>
    rotate <30, 45, 0>
    translate y*5.15
    rotate y*30
    translate <7, -7, -45>
  }
  #declare _r1 = _r1 + 4;
#end

object {Nest translate <5, -13, -45>}

object {PhoenixEgg scale .375 translate <5.75, -10.75, -45>}

//scattered crystals
#declare xCrystal = -90;
#declare zCrystal = 180;
#declare cr_sd1 = seed (248); //4224
#declare cr_sd2 = seed (41);
#declare cr_sd3 = seed (98723);
#while (zCrystal != -70)
  #while (xCrystal != 90)
    #declare cr_rand1 = int(rand(cr_sd1)*4.999999+1);
    #declare yCrystal = (hf_height_at ((xCrystal+90)/180, (zCrystal+180)/360, Phoenix_Mountain)-.5) * 60;
    #if (cr_rand1 = 2 & yCrystal > -9.5)
      #declare cr_rand2 = int(rand(cr_sd2)*5.999999+1);
      #declare cr_counter = 1;
      #while (cr_counter < cr_rand2)
        #declare cr_rand3 = int(rand(cr_sd3)*2.999999);
        #switch (cr_rand3)
          #case (0)
            #declare Crystal = object {Crystal1}
            #declare CrystalRadius = .4;
          #break
          #case (1)
            #declare Crystal = object {Crystal2}
            #declare CrystalRadius = .3;
          #break
          #case (2)
            #declare Crystal = object {Crystal3}
            #declare CrystalRadius = .26;
          #break
        #end
        object {Crystal rotate <(cr_rand3-1.5)*35, (cr_rand3-1.5)*35, 0> translate <xCrystal, yCrystal, zCrystal>}
        #declare cr_counter = cr_counter + 1;
      #end
    #end
    #declare xCrystal = xCrystal + 2.5;
  #end
  #declare xCrystal = -90;
  #declare zCrystal = zCrystal - 2.5;
#end
      
//glows around the wings
#declare glow_array = array [2][12] {
  {0, 1, 2, 3, 4.75, 6, 8, 9, 10, 11, 12, 13},
  {-3, -2.75, -2.25, -.25, 1, 1.5, 2, 3.5, 4, 5, 6, 7}
}

#declare glow_sd = seed(6721);
#declare glow_num = 0;
#declare glow_counter = 1;
#declare WingNum = 1;
#declare WingDir = 1;
#while (WingNum < 3)
  #while (glow_counter <= 8)
    #while (glow_num <= 11)
      #declare glow_rand = rand(glow_sd);
      #if (glow_array[0][glow_num] >= glow_num)
        #declare glow_height = glow_array[1][glow_num];
      #end
      glow {
        type 0
        location <WingDir*(glow_num + (rand(glow_sd)-0.5)), ((glow_rand-1)*(5+glow_height))+glow_height, (glow_rand-0.5)*2>
        size .015
        fade_power 1
        color rgb<1, glow_rand, 0>
        rotate y*30
        translate <(WingDir*1.2)+7, -7, -45>
      }
      #declare glow_num = glow_num + 1;
    #end
    #declare glow_counter = glow_counter + 1;
    #declare glow_num = 0;
  #end
  #declare WingDir = -1;
  #declare WingNum = WingNum + 1;
  #declare glow_counter = 1;
#end

//smoke
/*media {
  scattering { 1, .1 extinction .1 }
  //emission rgb 1
  intervals 10
  samples 20, 100
  ratio .999
  confidence .9
  variance 1/1000
  density {
    marble
    scale 5
    turbulence 1
    color_map {
      [0.0 rgb 0.6]
      [0.01 rgb 0]
      [1.0 rgb 0]
    }
  }
}*/

/*media {
  scattering { 1, .2 extinction .1 }
  //emission rgb 1
  intervals 30
  samples 1, 10
  ratio .999
  confidence .9
  variance 1/1000
  density {
    marble
    //scale 5
    turbulence 1
    color_map {
      [0.0 rgb 1]
      [0.2 rgb 0]
      [1.0 rgb 0]
    }
  }
}*/

//define edges of the lake
/*#declare Xc = 0;
#declare Zc = 0;

#while (Zc<=1)
  #if (hf_height_at (Xc, Zc, Phoenix_Mountain) <= .3 & Rand <= .3)
  
  #end
  #declare Xc = Xc + .01;
  #if (Xc > 1)
    #declare Xc = 0;
    #declare Zc = Zc + .005;
  #end
#end

#debug concat("c1 = ", str(c1, 0, 0),"\n")*/