// ====  Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "gems.inc"

global_settings {
	max_trace_level 15
	ambient_light rgb 1.0
}

#declare ran=seed(12321);

#version unofficial MegaPov 0.7;
// ================== TEXTURES AND PIGMENTS =================
// Angry_Sky - red-fringed black clouds in a purple sky
#declare Angry_Sky = pigment {
	agate
	color_map {
		[0.3 rgb <0.3, 0.1, 0.6>]
		[0.7 rgb <0.4, 0.1, 0.3>]
		[1.0 rgb 0.2]
		}
	}


#declare Tabletop_Texture=texture{
	pigment {
		granite
		color_map {
			[ 0.0 rgb <0.7, 0.5, 0.5> ]
			[ 0.3 rgb 0.6 ]
			[ 0.85 rgb 0.8 ]
		}
	}
	finish {
		ambient 0.3
		diffuse 0.7
		specular 0.1
		roughness 0.7
	}
	normal {
		dents 1.0
		scale <2.0, 2.0, 2.0>
	}

}

#declare Tableleg_Texture=texture{
	pigment {
		rgb <0.3, 0.3, 0.3>
	}
	finish{
		ambient rgb <0.2, 0.2, 0.2>
		diffuse 0.8
		specular 0.1
		roughness 0.7
	}
}


#declare Floor_Texture = texture{
	pigment {
		granite
		color_map {
			[ 0.1 rgb 0.2 ]
			[ 0.4 rgb 0.8 ]
			[ 1 rgb 1 ]
		}
	}
	finish {
		ambient rgb <0.2, 0.2, 0.2>
		diffuse 0.8
		specular 0.1
		roughness 0.7
	}
	normal {
		dents 0.5
		scale <2.0, 2.0, 2.0>
	}

}

#declare Ceiling_Texture = texture{
	pigment {
		granite
		color_map {
			[ 0.1 rgb 1 ]
			[ 0.7 rgb 0.8 ]
			[ 1 rgb 1 ]
		}
	}
	finish {
		ambient rgb <0.2, 0.2, 0.2>
		diffuse 0.8
		specular 0.1
		roughness 0.7
	}
	normal {
		dents 0.5
		scale 2
	}

}

#declare Column_Texture = texture {
	pigment {
		marble
		color_map {
			[0 rgb 0.2]
			[0.2 rgb <0.4, 0.4, 0.6>]
			[0.8 rgb <0.8, 0.8, 0.9>]
			[1 rgb 1]
		}
		turbulence 1
		scale 12
	}
	finish {
		ambient .2
		diffuse .8
		specular .5
		reflection .1
	}
}

#declare Brimstone=texture { 
	pigment {
		marble
		turbulence 1.0
		rotate 90*z
		color_map {
			[ 0.0 rgb <0.000000, 0.000000, 0.000000> ]
			[ 0.1 rgb <0.000000, 0.000000, 0.000000> ]
			[ 0.8 rgb <0.7, 0.0, 0.0> ]
			[ 1.0 rgb <1.0, 0.5, 0.0> ]
		} // color_map
		scale 0.25
		quick_color  rgb <0.000000, 0.000000, 0.000000> 
	} // pigment
	finish {ambient 1.0}
} // Brimstone texture

#declare Ground_Texture=texture{
	pigment {
		crackle
		color_map {
			[ 0 rgb <0.3, 0.2, 0.15> ]
			[ 1 rgb <0.5, 0.4, 0.3> ]
		}
		scale 20
	}

	finish {
		ambient .5
		diffuse .5
	}
}


#declare Gold_Ring=texture {
	pigment {color rgb <1, 0.85, 0.65>}
	finish {
		ambient 0.2
		diffuse 0.7
		reflection 0.3
		metallic
		specular 0.2
		roughness 0.1
	}
}



//  ===================  MACROS ===================

// Calculate the width of a textobject - Thanks to Ron Parker
#macro TextWidth( Text, Font, Size )
  #local TextObj = text { ttf Font concat(".",Text,".") 1 0 scale 
     <Size, Size, 1> }
  #local TextObj2 = text { ttf Font ".." 1 0 scale <Size, Size, 1>}
  ((max_extent(TextObj).x-min_extent(TextObj).x)-
   (max_extent(TextObj2).x-min_extent(TextObj2).x))
#end  

#macro isdelim(txt)
	#if (strlen(txt) = 0)
		#local foo=0;
	#else
		#local foo= (!strcmp(substr(txt,1,1),"|"));
	#end
	foo
#end

#macro textincircle(txt,font,siz,dpth,rdius)
	#declare charnum=1;
	union {
	#declare rot=0;
	#while (strlen (txt)>0)
		#while (isdelim(txt))
			#declare txt = substr(txt,2,strlen(txt)-1)
		#end
		#declare thischar=""
		#while (strlen(txt) * !isdelim(txt))
			#declare thischar = concat (thischar, substr(txt,1,1))
			#declare txt = substr(txt,2,strlen(txt)-1)
		#end
		#declare chrwid=TextWidth(thischar,font,siz);
		#declare R=(rot+chrwid/2)*180/(pi*rdius);
		#declare rot=rot+chrwid;
		text {ttf font,thischar,dpth,0
			scale <siz,siz,1> translate <-chrwid/2,0,rdius> rotate (R*y)}
	#end
	}
#end

#macro ring (halfheight,od,id)
	difference {
		cylinder {-halfheight*y,halfheight*y,od}
		cylinder {-1.1*halfheight*y,1.1*halfheight*y,id}
		}
#end

#macro ring2 (hh,od,id)
	intersection {
		intersection {
			sphere {0 od}
			torus {id+od, od}
			}
		cylinder {-hh*y hh*y od*1.1}
		}
#end

#macro ring3 (hh,od,id)
	// a toroidal ring with major axis (od+id)/2, and minor axis (od-id)/2,
	// scaled vertically by hh/(minor axis)
	#local majoraxis=(od+id)/2;
	#local minoraxis=(od-id)/2;
	torus 
	{
		majoraxis 
		minoraxis 
		scale <1,hh/minoraxis,1>
	}
#end

#macro ring4(hh,od,id)
	#local u1=id;
	#local u2=(2*id+od)/3;
	#local u3=(id+2*od)/3;
	#local u4=od;
	#local v1=-hh;
	#local v2=-hh*.75;
	#local v3=hh*.75;
	#local v4=hh;

	lathe {
		linear_spline
		9
		<u1,v2>
		<u1,v3>
		<u2,v4>
		<u3,v4>
		<u4,v3>
		<u4,v2>
		<u3,v1>
		<u2,v1>
		<u1,v2>
	}
#end


#macro liss (FX,FY,FZ,PHX,PHY,PHZ,AX,AY,AZ,N,D)
	#local P=0;
	 #ifdef (OLDPOINT)
		#undef OLDPOINT
	#end
	#local AX=AX-D;
	#local AY=AY-D;
	#local AZ=AZ-D;
	#local PHX=PHX*2*pi;
	#local PHY=PHY*2*pi;
	#local PHZ=PHZ*2*pi;
	union {
	#while (P<N+1)
		#local THETA = P * 2.0 * pi / N;
		#local X=sin(FX*THETA+PHX)*AX;
		#local Y=sin(FY*THETA+PHY)*AY;
		#local Z=sin(FZ*THETA+PHZ)*AZ;
		#local NEWPOINT=<X,Y,Z>;
		#ifdef (OLDPOINT)
			cylinder { OLDPOINT NEWPOINT, D}
		#end
		sphere {NEWPOINT, D }
		#local OLDPOINT=NEWPOINT;
		#local P=P+1;
	#end
	}
#end

#macro board (wide,thick,long,tex)
#local rt=-long/2+long*rand(ran);
#local rr=5+3*rand(ran);
superellipsoid {<0.1, 0.02>
	scale <wide,thick,long>/2
	texture {tex rotate rr*y translate rt*z}
}
#end

#macro WobblyCone(StartDiam,Steps,Drift,Randomness)
union {
	#ifndef (Ranseed)
		#declare Ranseed=seed(42315);
	#end
	#local Diam=StartDiam;
	#local Step=0;
	#local Pos=<0,0,0>;
	#while (Pos.y < 1)
		#local Xran=Randomness*(2*rand(Ranseed)-1);
		#local Zran=Randomness*(2*rand(Ranseed)-1);
		#local NewDiam=Diam+1/Steps;
		cone {0, Diam, 1/Steps*y, NewDiam
			matrix <1, 0, 0, Drift.x+Xran,1,Drift.z+Zran, 0, 0, 1, 0, 0, 0>
			translate Pos
		}
		#local Pos=Pos+(Drift+<Xran, 1, Zran>)/Steps;
		#local Diam=NewDiam;
	#end
	}
#end




// ================ SHAPE DEFINITIONS ====================

#declare Redlight=light_source {
	0 
	color rgb <.09,0,0>
	jitter
	fade_distance 12
	fade_power 2
}




#declare Table=box {
<-16,0,-12> <14,36,12>
texture {Tabletop_Texture}
}

#declare Windowshape=union{
	cylinder {
		0, 24*z, 12
	}
	box {
	<-12,-36,0> <12,0,24>
	}
}


#declare Column=difference {
	cone {
		0, 8, 
		8*12*y, 5/6*8
	}
	#declare counter=0;
	#declare max_count=12;
	#while (counter < max_count)
		cone {0, 1,
			8*12*y, 5/6
			translate 8*z
			matrix <
				1, 0, 0,
				0, 1, -2/(8*12),
				0, 0, 1,
				0, 0, 0
			>
			rotate (360*counter/max_count)*y
		}
		#declare counter = counter + 1;
	#end
}

#declare Floor=cylinder {
	0,-12*y
	9*12
	texture {Floor_Texture}
}

#declare Tower_Rail=union {
	object {
		ring (3,104, 98)
		translate 21*y
	}
	#declare COUNT=0;
	#declare MAX_COUNT=48;
	#while (COUNT < MAX_COUNT)
		cylinder {
			0, 18*y
			2
			translate 101*z
			rotate 360*COUNT/MAX_COUNT*y
		}
		#declare COUNT=COUNT+1;
	#end
	texture {Floor_Texture}
}

#declare Ceiling=cylinder{
	8*12*y, 9*12*y
	8*12
	texture {Ceiling_Texture}	
}

#declare Tower=union{
	object {Floor}
	object {Tower_Rail}
	object {Ceiling}
	#declare counter=0;
	#declare max_count=8;
	#while (counter < max_count)
		object {Column
			translate 7*12*z
			rotate (22.5+45*counter)*y
			texture {
				Column_Texture
				translate 40*counter
			}
		}
		#declare counter = counter + 1;
	#end
	cylinder {
		-240*y,-12*y
		6*12
		texture {Floor_Texture}
	}
}


// The seven Dwarf Rings
#declare dwarfring1=object {
	liss (7,23,7,0,0,0.25, 0.7, 0.15, 0.7,  644, 0.036)
	texture {Gold_Ring}
}


#declare dwarfring2 = union
{
	#local counter=0;
	#local nrings=56;
	#while (counter < nrings)
		torus
		{
		0.12, 0.015
		rotate 90*x
		translate 0.7*z
		rotate (360*counter/nrings)*y
		}
		#local counter = counter + 1;
	#end
	torus 
	{
		0.7, 0.015
		translate 0.12*y
	}
	torus 
	{
		0.7, 0.015
		translate -0.12*y
	}
	texture {Gold_Ring}
}

#declare dwarfring3 = difference {
	object {
		ring2 (0.14, 0.72, 0.66)
		texture {Gold_Ring}
	}
	#local counter=0;
	#local maxcount=70;
	#while (counter < maxcount)
	sphere {
		0, 1 
		scale <0.02, 0.11, 0.02> 
		translate 0.71*z 
		rotate 360*counter/maxcount*y
		texture {Silver_Metal}
	}
	#local counter = counter + 1;
	#end
}

#declare dwarfring4=difference
{
	object {
		ring3 (0.15, 0.7, 0.64)
		texture {Gold_Ring}
	}
	
	object {
		liss (
			3, 23, 3,
			0, 0, .25,
			0.72, 0.12, 0.72,
			92,
			0.02)
		texture {Gold_Nugget}
	}
}
		
#declare dwarfring5=difference {
	object {
		ring2 (0.15, 0.66, 0.6)
		texture {Gold_Ring}
	}	
	object {
		liss (
		1, 7, 1
		0, 0, 0.25
		0.67, 0.08, 0.67
		112
		0.01)
		texture {Silver_Metal}
	}
	object {
		liss (
		1, 7, 1
		0, 0.2, 0.25
		0.67, 0.08, 0.67
		112
		0.01)
		texture {Silver_Metal}
	}
	torus {0.66, 0.01
		texture {Silver_Metal}
	}
}

#declare dwarfring6=difference
{
	object {
		ring4 (.15,.64,.7)
	}
	
	superellipsoid
	{
		3.0
		scale <.15, 3, .15>
		rotate <90,0,0>
	}
	superellipsoid
	{
		3.0
		scale <.15, 3, .15>
		rotate <90,30,0>
	}
	superellipsoid
	{
		3.0
		scale <.15, 3, .15>
		rotate <90,60,0>
	}
	superellipsoid
	{
		3.0
		scale <.15, 3, .15>
		rotate <90,90,0>
	}
	superellipsoid
	{
		3.0
		scale <.15, 3, .15>
		rotate <90,120,0>
	}
	superellipsoid
	{
		3.0
		scale <.15, 3, .15>
		rotate <90,150,0>
	}
	
	texture {Gold_Ring}
}

#declare dwarfring7=union
{
	#local counter=0;
	#local maxcount=126;
	#while (counter < maxcount)
		sphere {0, 0.0233
			translate 0.7*z
			rotate 360*counter/maxcount*y
			texture {Silver_Metal}
		}
		sphere {0, 0.0233
			translate <0,0.035,0.7>
			rotate 360*(counter+0.5)/maxcount*y
			texture {Gold_Ring}
		}
		sphere {0, 0.0233
			translate <0,-0.035,0.7>
			rotate 360*(counter+0.5)/maxcount*y
			texture {Gold_Ring}
		}
		sphere {0, 0.0233
			translate <0, 0.07, 0.7>
			rotate 360*counter/maxcount*y
			texture {Gold_Ring}
		}
		sphere {0, 0.0233
			translate <0, -0.07, 0.7>
			rotate 360*counter/maxcount*y
			texture {Gold_Ring}
		}
		sphere {0, 0.0233
			translate <0,0.105,0.7>
			rotate 360*(counter+0.5)/maxcount*y
			texture {Gold_Ring}
		}
		sphere {0, 0.0233
			translate <0,-0.105,0.7>
			rotate 360*(counter+0.5)/maxcount*y
			texture {Gold_Ring}
		}
		#local counter = counter + 1;
	#end
} // union (dwarfring7)
// The three Elven Rings - set with Ruby, Sapphire, and Adamant

#declare elfring1=union{
	object {
		liss (3,25,3
			0,0,.25
			0.9, 0.09, 0.9
			200, .03)
		texture {Gold_Ring}
	}
	union {
		cylinder {0, 0.001*y 0.05 texture {Chrome_Metal} translate 0.27*y}
		object {
			Brillant58
			scale 0.3
			texture {Blue_Diamond_Texture}
			translate 0.271*y
		}
		union {
			union {
				cylinder {0 <0.24, 0.27, 0.24> 0.01 }
				sphere {<0.24, 0.27, 0.24> 0.01}
				cylinder{<0.24,0.27,0.24> <0.19, 0.32, 0.19> 0.01}
			}
			union {
				cylinder {0 <0.24, 0.27, 0.24> 0.01 }
				sphere {<0.24, 0.27, 0.24> 0.01}
				cylinder{<0.24,0.27,0.24> <0.19, 0.32, 0.19> 0.01}
				rotate 90*y
			}
			union {
				cylinder {0 <0.24, 0.27, 0.24> 0.01 }
				sphere {<0.24, 0.27, 0.24> 0.01}
				cylinder{<0.24,0.27,0.24> <0.19, 0.32, 0.19> 0.01}
				rotate 180*y
			}
			union {
				cylinder {0 <0.24, 0.27, 0.24> 0.01 }
				sphere {<0.24, 0.27, 0.24> 0.01}
				cylinder{<0.24,0.27,0.24> <0.19, 0.32, 0.19> 0.01}
				rotate -90*y
			}
			sphere {0 0.01 scale <2,1,2>}
			texture{Gold_Ring}
		}
		rotate 90*x
		translate 0.9*z
	}
}

#declare elfring2=union{
	difference
	{
		object {ring2 (0.15, 0.9, 0.8) texture {Gold_Ring}}
		object {ring (0.1, 1.0, 0.85) texture {Chrome_Metal}}
	}
	union
	{
		#local counter=0;
		#local maxcount=22;
		#while (counter < maxcount)	
			object {Emerald_Stairs 
				scale <0.07, 0.05, 0.07>
				rotate 90*x
				translate 0.9*z
				rotate counter*360/maxcount*y
				texture {
					pigment { color rgbf <0.2, 0.1, 0.3, 0.95>}
					finish {
						ambient 0.1
						diffuse 0.5
						specular 0.6
						reflection 0.3
					}
				}
				interior { ior 1.76}
			}
			#local counter=counter+1;
		#end
	}
}

#declare elfring3=union{
	object {
		ring3 (0.15, 0.9, 0.76)
		texture {Gold_Ring}
	}
	union {
		object {
			Cabochon
			texture {StarRuby_Texture_1}
			texture {StarRuby_Texture_1 rotate 60*y}
			texture {StarRuby_Texture_1 rotate -60*y}
			texture {StarRuby_Texture_2}
			translate 0.01*y
		}
		cylinder 
		{
			0, 0.01*y 
			1
			texture {Gold_Ring}
		}
		intersection
		{
			torus {1.0, 0.05}
			box {<-2, 0, -2> <2,1,2>}
			texture {Gold_Ring}
		}
		scale <0.25,0.5,0.5>
		rotate 90*x
		translate 0.89*z
	}
}

// The nine Wraith Rings
#declare wraithring=union
{ 
	difference { 
		ring (0.2, 1.05, 0.95) // the ring
		ring (0.1, 1.11, 0.97) // a channel for the inlay
		texture {Gold_Ring}
	}
	
	// the inlay
	object {
		ring (0.1, 1.0, 0.97)
		texture {Brimstone}
	} // object (inlay)
} // union (wraithring)

// The One Ring
#declare onering=difference
{
	object
	{
		ring3 (0.3, 1.08, 0.95)
	}
	
	object 
	{
		textincircle (
		concat("A#| |5|,E|x| |2|6Y|w|1E|jY|z^Y| - |A#| |5|,E|x| |x|t%|w|1E|jY| - ",
			"A#| |5|,E|x| |!|6|zE|1E|jY|z^| |v#| |w|6Y|,|t^|=|A%|`B| |z|6|t%|q|1E|jY| - "),
			"noldor.ttf", 
			0.156, 	// text size
			0.02,  // extrusion depth
			0.94)	// diameter of front edges of text
		translate -0.06*y	// drop it half the text size to center vertically
		texture {Gold_Nugget}
	}
	
	texture {Gold_Ring}
}

#declare orb_main=union{
	light_source {0 color rgb <.03,.03,.03> jitter fade_distance 24 fade_power 2
		looks_like {elfring1}               translate <0.0, 1.25, 0.75> rotate  240*y}

	light_source {0 color rgb <.03,.03,.03> jitter fade_distance 24 fade_power 2
		looks_like {elfring2}               translate <0.0, 1.75, 0.75> rotate  0*y}

	light_source {0 color rgb <.03,.03,.03> jitter fade_distance 24 fade_power 2
		looks_like {elfring3}               translate <0.0, 1.5, 0.75> rotate  120*y}

	light_source {0 color rgb <.03,.03,.03> jitter fade_distance 24 fade_power 2
		looks_like {dwarfring1}             translate 3.5*y rotate   0*x rotate    0*y}

	light_source {0 color rgb <.03,.03,.03> jitter fade_distance 24 fade_power 2
		looks_like {dwarfring2}             translate 3.5*y rotate  36*x rotate    0*y}

	light_source {0 color rgb <.03,.03,.03> jitter fade_distance 24 fade_power 2
		looks_like {dwarfring3}             translate 3.5*y rotate  36*x rotate   60*y}

	light_source {0 color rgb <.03,.03,.03> jitter fade_distance 24 fade_power 2
		looks_like {dwarfring4}             translate 3.5*y rotate  36*x rotate  120*y}

	light_source {0 color rgb <.03,.03,.03> jitter fade_distance 24 fade_power 2
		looks_like {dwarfring5}             translate 3.5*y rotate  36*x rotate  180*y}

	light_source {0 color rgb <.03,.03,.03> jitter fade_distance 24 fade_power 2
		looks_like {dwarfring6}             translate 3.5*y rotate  36*x rotate -120*y}

	light_source {0 color rgb <.03,.03,.03> jitter fade_distance 24 fade_power 2
		looks_like {dwarfring7}             translate 3.5*y rotate  36*x rotate  -60*y}

	light_source {0 color rgb <.04, .00, .00> jitter fade_distance 24 fade_power 2
		looks_like {wraithring}             translate 3.5*y rotate 108*x rotate   45*y}

	light_source {0 color rgb <.04, .00, .00> jitter fade_distance 24 fade_power 2
		looks_like {wraithring}             translate 3.5*y rotate 108*x rotate  135*y}

	light_source {0 color rgb <.04, .00, .00> jitter fade_distance 24 fade_power 2
		looks_like {wraithring}             translate 3.5*y rotate 108*x rotate -135*y}

	light_source {0 color rgb <.04, .00, .00> jitter fade_distance 24 fade_power 2
		looks_like {wraithring}             translate 3.5*y rotate 108*x rotate  -45*y}

	light_source {0 color rgb <.04, .00, .00> jitter fade_distance 24 fade_power 2
		looks_like {wraithring}             translate 3.5*y rotate 144*x rotate    0*y}

	light_source {0 color rgb <.04, .00, .00> jitter fade_distance 24 fade_power 2
		looks_like {wraithring}             translate 3.5*y rotate 144*x rotate   90*y}

	light_source {0 color rgb <.04, .00, .00> jitter fade_distance 24 fade_power 2
		looks_like {wraithring}             translate 3.5*y rotate 144*x rotate  180*y}

	light_source {0 color rgb <.04, .00, .00> jitter fade_distance 24 fade_power 2
		looks_like {wraithring}             translate 3.5*y rotate 144*x rotate  -90*y}

	light_source {0 color rgb <.04, .00, .00> jitter fade_distance 24 fade_power 2
		looks_like {wraithring}             translate 3.5*y rotate 180*x rotate  120*y}

	light_source {0 color rgb <.09,.00,.00> jitter fade_distance 24 fade_power 2
		looks_like {onering}      scale 2.0 translate 0*y rotate -5*x}
		
	sphere {0 5 
		texture {
			Glass3
		}
	}
	
}

#declare frame_foot=intersection
{
	union{
		cylinder {-.5*y, .5*y, 2}
		cylinder {-.75*y, .75*y, 1.5}
		cylinder {-1.0*y, 1.0*y, 1}
	}
	box {<-4, -4, 0> <4, 4, 4>}
}

#declare frame1=union {
	difference {
		prism {
			linear_spline
			linear_sweep
			-0.5 	//Base height
			0.5, 	//Top height
			4,
			<-8, 0>,
			<0, 4>,
			<8, 0>,
			<-8, 0>
		}
		sphere {7*z,5}
	}
	object {frame_foot translate <-8,0,0>}
	object {frame_foot translate <8, 0, 0>}
	rotate -90*x
	texture {Rosewood rotate 90*y rotate 90*x  translate 24*z}
}

#declare frame=union{
	object{frame1}
	object {frame1 rotate 90*y translate -.01*y}
}

#declare orb_of_seeing = union {
	object {frame}
	object {orb_main translate 7*y}
}


// ======================== OBJECTS =======================


sky_sphere {pigment {Angry_Sky}}

plane
{
	y, 
	-240
	hollow on
	texture {Ground_Texture}
}


object {Tower}
object{Table}

object {orb_of_seeing translate <0, 36, 0>}


// ==================== CAMERA ====================
camera
{
	up y
	right 4/3*x
	direction 1.4*z
	location  <8, 47, -15> // position of camera <X Y Z>
	look_at   <0,43,0> // point center of view at this point <X Y Z>
}
