#include "colors.inc"
#include "metals.inc"
#include "textures.inc"   
#include "stones1.inc"
#include "woods.inc" 
#include "Razor.inc"
#include "LightSocket.inc"
#include "wings.inc"
#include "WoodenTable.inc"  
#include "1WoodFloor.inc"  
#include "sink.inc"  
#include "Drops.inc"
#include "Chair1.inc"  
#include "radiator.inc"  
#include "Frames.inc"   
#include "Containers.inc" 
#include "Staff.inc"

#declare Tom_Glass1 =
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 1.0> }
    finish  { F_Glass1 }
} 

global_settings { ambient_light rgb<.9,.9,.8> } 

// ====================================================================================
         /*

         
         media{
            emission rgb .01
            scattering {1, color rgb <.1,.2,.1> extinction 1}
            density { granite 
              color_map{
                        [ 0.000  0.270 color rgbf 1 color rgbf 1 ]
                        [ 0.270  0.280 color rgb 0 color rgb 0 ]
                        [ 0.280  0.470 color rgbf 1 color rgbf 1 ]
                        [ 0.470  0.480 color rgb 0 color rgb 0 ]
                        [ 0.480  0.680 color rgbf 1 color rgbf 1 ]
                        [ 0.680  0.690 color rgb 0 color rgb 0 ]
                        [ 0.690  0.880 color rgbf 1 color rgbf 1]
                        [ 0.880  0.890 color rgb 0 color rgb 0 ]
                        [ 0.890  1.000 color rgbf 1 color rgbf 1]
                }
              frequency 2
              turbulence .5
              scale .8 
             }
            }
   
          */
      
//media {
//	intervals 10
//	scattering { 3, color rgb .008 extinction 0.52 }
//	samples 1,1
//	variance 1/100
//	confidence .8
//        }
        
// ====================================================================================        

                 
sky_sphere {
        pigment {
                granite
                color_map {
                        [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
                        [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
                        [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
                        [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <1,1,1> ]
                        [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
                        [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <1,1,1> ]
                        [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0>2 ]
                        [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
                        [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
                        }
                turbulence 1
                sine_wave
                scale .2
                }
        }   
   
#declare moon =
        sphere {<0,0,0>,15
        pigment {
                granite
                color_map {
                        [0.00 color White]
                        [0.80 color White*.8]
                        [0.90 color White*.6]
                        [1.00 color White*.9]
                        }
                scale 20
                rotate -45*z
                }
        
                finish { diffuse .8 ambient .4 reflection .1 roughness 1  } 
        }
        
light_source {
        <-25, 65, 300>
        color White*.6
        looks_like {moon}
        }
  
light_source {
        <120, 90, 140>
        color White *.6
        spotlight
        radius 135
        tightness 40
        point_at <-25, 65, 300>
        }

//background{rgb 0}                     
                                                    
// ================================ PRODUCTION ========================================

camera {location <-16,9,-25> sky <-.1,1,0> look_at<0,5,10>}     // == THE ONE!! 
light_source {<95,55,-35> color White  *.55}                    // == other room
light_source {                                                  // == brightening things up a bit
        <-30,20,57>
        color White *.45
        area_light <35, 0, 0>, <0, 0, 51>, 3, 3
        adaptive 1
        jitter
        shadowless
        } 

// =============================== Testing lights and cameras ======================================   
                         
light_source {<-20,6,-80> color White *.5 shadowless}
light_source {<-28,35,80> color White *.5 shadowless}                    
                                   
//camera {location <13.05,-17,69> look_at<9.05,-18.95,70>}       // == f1 lookout     
//camera {location <-6,11,-12> look_at<-3,10,-13>}                 // == f2 closeup
//camera {location <-14,4.5, -2> look_at<-15,4, 2>}                // == f3 landing
camera {location <-9.25,-5.6,7> look_at <-9.25,-6.75,9.95>}   // == f4 scooping        
                                         

//camera {location <30.5,18,10> look_at <39.5,12,19>}
        
//light_source {<-15,60,-18> color White shadowless}
//light_source {<-150,50,-180> color White shadowless}  
//light_source {<500,-7,-1800> color White*.8 shadowless}

// ==================== Applying light to the ladies ==============================================
             /*
#include "f2.inc"            
#declare f2b =                                                                       // ======== f2 at window
        union {
                object {wings2 scale <1.35, 1.75, 1> rotate -8*z rotate -40*x rotate 84*y }     
                light_source {  
                        <0,0,0>
                        color LimeGreen *.75  
                        shadowless
                        fade_distance 2
                        fade_power 1.8
                        looks_like { body2}
                        } 
                }  
                
#declare f2a =                                                                        // ======== f2 close-up
        union {       
                object {wings2 scale <1.35, 1.75, 1> rotate -8*z rotate -45*x rotate 84*y translate <0, .25,0>}         
                light_source {                                                                                             
                        <0,0,0>
                        color LimeGreen *.65
                        shadowless
                        fade_distance 2
                        fade_power 1.8
                        looks_like { body2}
                        }
                object {staff scale .3 rotate 65*y rotate 10*z translate <-.83,-.7,-.39>}
                } 
                 
#include "f3.inc" 
#declare f3 =                                                                         // ======== f3 landing
        union {
                object {wings3 scale <1.35, 1.75, 1> rotate -40*x rotate -25*y rotate 5*z translate <.1,.75,.1>}
                light_source {  
                        <0,0,0>
                        color LimeGreen *.6  
                        shadowless
                        fade_distance 2
                        fade_power 1.8
                        looks_like { body3}
                        }
                object {jug1 rotate 80*y rotate -4*x rotate -5*z scale .145 translate <.35,-1.7,-.55>
                         texture {T_Glass4} interior {I_Glass} finish {phong 1}}               
                }
            
#include "f1.inc" 
#declare f1 =                                                                         // ======== f1 lookout
        union {
                object {wings1 scale <1.35, 1.75, 1> rotate 8*x rotate -60*y translate <-.1,.5,.15>}
                light_source {                                                                                             
                        <0,0,0>
                        color LimeGreen  *0//.6 
                        shadowless
                        fade_distance 2
                        fade_power 1.8
                        looks_like { body1}
                        }
                }
                  */
#include "f4.inc"            
#declare f4 =                                                                         // ======== f4 scooping
        union {
                object {wings4 scale <1.35, 1.75, 1> rotate -55*x rotate -20*y rotate-3*z translate <0.05,.45,-.5>}
                light_source {  
                        <0,0,0>
                        color LimeGreen *0//.6  
                        shadowless
                        fade_distance 2
                        fade_power 1.8
                        looks_like { body4}
                        }
                object {Ladel1 scale .15 rotate 100*y rotate 85*z rotate 30*y translate <.85,-1.15,-1> 
                        //texture { pigment { P_Chrome1 } finish { F_MetalE}}}
                        pigment {color White}  finish {phong 1}}
                }                                                                      
                    
object {f4 rotate 53*y translate <-9.25,-6.75,9.95>}                                   // ======== f4 scooping
//object {f2b rotate -90*y rotate -20*x  translate<-10.85, 32.5, 110>}                   // ======== f2 at window  
//object {f1 translate <9.05,-18.95,70>}                                                 // ======== f1 lookout     
//object {f2a translate <-3.85, 11.5, -12>}                                              // ======== f2 close-up  
//object {f3 rotate -10*y translate <-15,4, 9>}                                          // ======== f3 landing       
                
// ============================== Faery props for testing =========================================
 
//sphere {<0,0,0>,1 translate <-9.25,-6.75,9.75> pigment {color LimeGreen}}                 // ======== f4 scooping
//sphere {<0,0,0>,1 translate <-10.85, 32.5, 110> pigment {color LimeGreen}}                // ======== f2 at window
//sphere {<0,0,0>,1 translate <9.05,-18.95,70> pigment {color LimeGreen}}                   // ======== f1 lookout
//sphere {<0,0,0>,1 translate <-15,4, 9> pigment {color LimeGreen}}                         // ======== f3 landing 
//sphere {<0,0,0>,1 translate <-3.85, 10.5,-12.5> pigment {color LimeGreen transmit 0}}     // ======== f2 close-up                               
                                                            
// ========================== Distant faery stand-ins =============================================
         
#declare StandIn =
merge {
       sphere {<0,0,0>,1.5 scale <.25,.5,.25> }
       sphere {<0,0,0>.3 translate 1*y}
       cone {<.1,-.2,0>,.2<.5,-2.25,0>,.05}
       cone {<-.1,-.2,0>,.2<-.5,-2.25,0>,.05}
       hollow
       texture {pigment {rgbf <.81,.71,.23,.7>} finish {Dull}}
       }    

         
light_source {
        <-21.85, 31.5, 190>
        color Yellow *3.5
        //color LimeGreen 4.5
        shadowless 
        fade_distance 2
        fade_power 10
        looks_like { StandIn }
        } 

light_source {
        <-23, 30.5, 210>
        //color LimeGreen 4.6
        color Yellow *3.5
        shadowless 
        fade_distance 2
        fade_power 10
        looks_like { StandIn }
        } 
        
light_source {
        <-21, 22.5, 200>
        color Yellow *3.5
        //color LimeGreen 4.5
        shadowless 
        fade_distance 2
        fade_power 10
        looks_like { StandIn }
        }         
           
//================================ More objects ===================================================                                                                          
                
#declare mirror_glass =
        union {
                difference {
                        box {<.2,0.2,-.26><6.3,9.8,-.01> texture {pigment {P_Chrome1} finish { reflection 1.0 ambient 0 diffuse 0 }}}
                        prism {
                                cubic_spline
                                0, // sweep the following shape from here ...
                                1, // ... up through here
                                6, // the number of points making up the shape ...
                                < 3, -5>, // point#1 (control point... not on curve)
                                < 3,  5>, // point#2  ... THIS POINT ...
                                <-5,  0>, // point#3
                                        < 3, -5>, // point#4
                                < 3,  5>, // point#5 ... MUST MATCH THIS POINT
                                <-5,  0>  // point#6 (control point... not on curve)
                                scale .75
                                rotate 90*x rotate -165*z 
                                translate <0,1,-.3>
                                }
                        }
                prism {
                        cubic_spline
                        0, // sweep the following shape from here ...
                        1, // ... up through here
                        6, // the number of points making up the shape ...
                        < 3, -5>, // point#1 (control point... not on curve)
                        < 3,  5>, // point#2  ... THIS POINT ...
                        <-5,  0>, // point#3
                                < 3, -5>, // point#4
                        < 3,  5>, // point#5 ... MUST MATCH THIS POINT
                        <-5,  0>  // point#6 (control point... not on curve)
                        scale .75
                        rotate 90*x rotate -165*z 
                        rotate 1.2*y
                        translate <0,1,-.26>
                        
                        }
                clipped_by {box {<.2,0.2,-1.26><6.3,9.8,1.01>}}
        }
                
                        
                
#declare Mirror1 =
        union { 
                difference {
                        object {Frame1 pigment {P_Copper2} finish {F_MetalA}} 
                        box {<.2,0.2,-.26><6.3,9.8,.01> pigment {P_Chrome1} finish {F_MetalE}}  
                        }
                object {mirror_glass texture {pigment {P_Chrome1} finish { reflection 1.0 ambient 0 diffuse 0 }}}
                scale 1.5
                }

#declare Fill2 =
        prism {
                conic_sweep
                linear_spline
                .4,
                1.1,
                7,
                <-3,0>,<-1.5,-2.598>,<1.5,-2.598>,<3,0>,<1.5,2.598>,<-1.5,2.598>,<-3,0>
                scale <.8,12,.8> translate -6*y
                texture {pigment {color Scarlet} normal {bumps 500 scale .5}}  
                hollow off
                clipped_by {box {<-10,.3,-10><10,5,10>}}  
                }
     
#declare Bannister = 
        union {
                sphere {<0,47.8,0>,4}
                difference {
                        cylinder {<0,40,0><0,48,0>,2.2}
                        torus {2.1,.5 translate 43.75*y}
                        }
                torus {2.3,.5 translate 42.5*y}
                prism {
                        conic_sweep
                        linear_spline
                        0, // height 1
                        1, // height 2
                        5, // the number of points making up the shape...
                        <5,5>,<-5,5>,<-5,-5>,<5,-5>,<5,5>
                        rotate <180, 0, 0>
                        translate <0, 14.5, 0>
                        scale <1, 3, 1>
                        }
                        box {<-5,0,-5><5,40.6,5>}            
                }

#declare MainWindow =
        union {
                difference {
                        union {
                                box {<-40,0,-.6><-37,40,.6>}
                                box {<-3,0,-.6><0,40,.6>}
                                box {<-36.9,37,-.6><-3.1,40,.6>}
                                box {<-36.9,0,-.6><-3.1,3,.6>}
                                cylinder {<-37,2,0>,<-37,38.0>,.5} 
                                cylinder {<-3,2,0>,<-3,38,0>,.5}
                                cylinder {<-38,37,0>,<-2,37,0>,.5}
                                cylinder {<-38,3,0>,<-2,3,0>,.5} 
                                pigment {color White}
                                }
                        box {<-37,3,-.1><-3,37,.1> pigment {color White}}
                        }
                box {<-37,3,-.1><-3,37,.1> texture {Tom_Glass1}finish { reflection 0}}

                }

#declare OtherWindow =
        union {
                difference {
                        union {
                                box {<-60,0,-.6><-57,45,.6>}
                                box {<-3,0,-.6><0,45,.6>}
                                box {<-56.9,42,-.6><-3.1,45,.6>}
                                box {<-56.9,0,-.6><-3.1,3,.6>}
                                cylinder {<-57,2,0>,<-57,43.0>,.5} 
                                cylinder {<-3,2,0>,<-3,43,0>,.5}
                                cylinder {<-58,42,0>,<-2,42,0>,.5}
                                cylinder {<-58,3,0>,<-2,3,0>,.5} 
                                pigment {color White}
                                }
                        box {<-57,3,-.1><-3,42,.1> pigment {color White}}
                        }
                box {<-57,3,-.1><-3,42,.1> texture {Tom_Glass1}finish { reflection 0}}

                }
                
#declare shutterSmall = 
        union {
                object {Board texture { T_Wood7 scale 2} translate 3.2*x} 
                object {Board texture { T_Wood7 scale 2} scale <1,.5,1> rotate 180*y translate .1*x} 
                object {Board texture { T_Wood7 scale 2} translate -3*x}
                box {<-4.5,0,6.5>,<4.5,.4,8> rotate -90*y texture { T_Wood7 scale 2} rotate 90*y} 
                box {<-4.5,0,-6.5>,<4.5,.4,-8> rotate -90*y texture { T_Wood7 scale 2}rotate 90*y}
                scale 2
                }
                 
#declare shutterLarge = 
        union {
                object {Board texture { T_Wood7 scale 2} translate 4.2*x} 
                object {Board texture { T_Wood7 scale 2} rotate 180*y translate .1*x} 
                object {Board texture { T_Wood7 scale 2} translate -4*x}
                box {<-5.5,0,6.5>,<5.5,.4,8> rotate -90*y texture { T_Wood7 scale 2} rotate 90*y} 
                box {<-5.5,0,-6.5>,<5.5,.4,-8> rotate -90*y texture { T_Wood7 scale 2}rotate 90*y}
                scale <2.2,2,2>
                } 
                 
#declare room =  
        union {
             
// ======= right x wall============================================================================ 

                difference {                                                       
                        union {
                                box {<40,-58,149.0001>,<200,70,151> pigment {color LightBlue}}                                          
                                object {baseboard scale 5*x translate <90,-37,149.0001> pigment {color White}}
                                }
                        box {<70,5,148>,<130,50,155> pigment {color White}} 
                        }

                object {shutterSmall rotate -90*x translate<-35,30,155>}
                object {shutterSmall rotate <-90,50,0> translate<-12.5,30,163>}
                object {shutterLarge rotate <-90,60,0> translate<124,28,164>}
                object {MainWindow rotate -105*y translate <-5.5,10,151>}  
                object {OtherWindow translate <130,5,151>}
                
// ======== wood floor=============================================================================
                
                difference {                                                       
                        object {Floor1 translate<-55,-37,120>}                     
                        box {<146,-58,110>,<180,-30,250> pigment {color White }}
                        }
                        
// ======== ...floor backing======================================================================= 
               
                difference {                                                       
                        plane {y,-38 pigment {color Black}}                        
                        box {<146,-58,110>,<180,-30,250> pigment {color White }}
                        }
                        
// ======== ceiling================================================================================
                        
                //plane {y,70 pigment {color White }}  
                plane {y,60 pigment {color White }}
                                                
// ======== left z wall (out of view) =============================================================  

                plane {x,-99 texture {pigment {gradient z color_map {[0.5  color Wheat][0.5  rgb <0.660784,0.660784,0.737255>]}}scale 10 translate -100*z}} 
                
// ======== centre z wall =========================================================================   

                difference {                                                       
                        union {                                                    
                                plane {x,40 texture {pigment {gradient z color_map {[0.5  color Wheat][0.5  rgb <0.660784,0.660784,0.737255>]}}scale 10 translate -100*z}} 
                                box {<40.001,-39,66.001><41,50,70> pigment {color White}}
                                object {baseboard rotate 90*y scale 50*z  translate <40,-37,0> pigment {color White}} 
                                }
                        box {<39,-37,66>,<41,45,30> pigment {rgbt <1,1,1,1>}}
                        }
                box {<39,-37,65>,<121,45,30> scale .01                         // == doorframe
                        texture {pigment { image_map { gif "Smear.gif" map_type 0 }}} 
                        inverse  
                        scale 100 
                        clipped_by {box{<39.5,-38,66>,<45,46,31>}}
                        } 
                
// ======== left x wall ===========================================================================  
              
                difference {                                                       
                        union {                                                    
                                plane {z,150 texture {pigment {gradient x color_map {[0.5  color Wheat][0.5  rgb <0.660784,0.660784,0.737255>]}}scale 10 translate -100*x}}
                                object {baseboard scale 10*x translate <-5,-37,150> pigment {color White}} 
                                }
                        box {<-25,-25,-10>,<15,15,10> pigment {rgbt <1,1,1,1>}translate <-20,35,150>}
                        box {<80,5,148>,<200,50,155> pigment {rgbt <1,1,1,1>}}
                        }
                box {<-25,-25,149>,<15,15,156>pigment {rgb<1,1,1>} clipped_by {box{<-25,-26,150>,<15,16,155>}} translate <-20,35,0>}   // == small windowframe 
                                        
                        
                clipped_by {box{<-100,-58,-200>,<200,71,185>}}  hollow
                }

// ======== And... ================================================================================
       
object {sink rotate -110*y scale <1.5,1,1.5> translate <6,0,-6>}
object {Razor scale 2.5 rotate <90,-50,0> translate <-7.1,-7.73,2>}
object {Cup rotate 20*y translate <-11.5,-5,.25>}
object {Tabletop scale 2.5 rotate 90*y translate <12,-8,-3.5>} 
object {chair1 scale 2 rotate -90*y rotate 86*x rotate -4*z rotate -10*y translate <8,-26.5,77.5>                   // ==== toppled chair
        finish {phong 1}} 
object {chair1 scale 2 rotate 80*y translate <34,-7.75,125>                                                         // ==== upright chair
        finish {phong 1}}                                                                                           
object {thrownpants  
        scale 2 
        rotate 80*y 
        translate <34,-7.75,125> 
        pigment {quilted control0 .6 control1 1 scale 1 
                color_map {[1 rgb<0.59,0.41,0.31>]}}
        finish{Dull}}        
object {LightSocket rotate 20*y translate <-3.25,20,10> finish {phong 1 ambient 1.5}}   
object {radiator translate <-40.5,-21,145> texture {
                        crackle 
                                texture_map { 
                                [ 0.0 pigment {rgb<1,1,.9> *.9} ] 
                                [ 0.01 pigment {rgb<1,1,.9> *.75} ] 
                                [ 0.04 pigment {rgb<1,1,.9>}  ]
                                [ 0.9 pigment {color White}  ]
                                }
                        scale .4
                        }
                }
object {Frame2 rotate -3*x rotate 90*y translate <39.75,14,108>}                        
object {Bannister translate <138,-37,149> scale .01 texture {pigment { image_map { gif "Smear2.gif" map_type 0 }}}scale 100}//pigment {color White} finish {phong 1}}  
object {Bannister translate <138,-37,106>  pigment {color White} finish {phong 1}}
cylinder {<138,0,106><250,0,106>,1.5  pigment {color White}}
cylinder {<148,-38,106>,<148,0,106>,.75  pigment {color White}}
cylinder {<154,-38,106>,<154,0,106>,.75  pigment {color White}} 
cylinder {<160,-38,106>,<160,0,106>,.75  pigment {color White}}
cylinder {<166,-38,106>,<166,0,106>,.75  pigment {color White}}
object {Stairs translate <145,-37,149> pigment {color White}}
object {SingleRound scale <.9,1,1>translate <-10,-8,9> finish{Shiny phong 1 phong_size 50 ambient .2}} 
object {SingleRound scale <.6,1,.8>translate <-11.5,-8,6>  finish{Shiny phong 1 phong_size 50 ambient .2}}
object {DoubleUnequal scale 2 rotate 40*y translate <-7.5,-8,10.5> finish{Shiny phong 1 phong_size 50 ambient .2}}
object {TripleUnequal scale 2.5 rotate 80*y translate <-4.25,-8,14> finish{Shiny phong 1 phong_size 50 ambient .2}}
object {SingleRound scale .6 translate <-9.5,-8,4.75> finish{Shiny phong 1 phong_size 50 ambient .2}}
object {SingleRound scale .4 translate <2,-8,11> finish{Shiny phong 1 phong_size 50 ambient .2}}
object {SingleRound scale .5 translate <-12,-8,4> finish{Shiny phong 1 phong_size 50 ambient .2}} 
object {SingleRound rotate -45*y scale <.2,10,.3> translate <-1.1,-.7,3.8> finish{Shiny phong 1 phong_size 50 ambient .2}}
object {DoubleUnequal scale <1,5,.5> rotate 20*x rotate -90*y translate <-1.25,.78,4.9> finish{Shiny phong 1 phong_size 50 ambient .2}}
object {Mirror1 rotate -10*x rotate 90*y translate <39.5,12,19>}
object {jug2 rotate 95*y scale .15 translate <-12,-8,9> texture {T_Glass4} interior {I_Glass} finish {phong 1}} 
object {Fill2 rotate 95*y scale .15 translate <-12,-8,9>}  
object {jug1 rotate -25*y scale .15 translate <-11,-8,10.5> texture {T_Old_Glass} interior {I_Glass}}

object {room}    

