#version unofficial MegaPov 0.7;

global_settings {
	hf_gray_16 on
	ini_option "+w200 +h500"
}

plane {
	y,0
	pigment {
		bozo
		color_map {
			[0 color rgb .75]
			[1 color rgb 1]
		}
	}
	finish {ambient 1}
}

camera {
	up y
	right x/5
	location y*100
	look_at 0
	orthographic
}

#declare Wall1 = pigment {
	gradient x
	color_map {
		[0 color transmit .05]
		[1/3 color transmit .3]
		[2/3 color transmit .7]
		[1 color transmit 1]
	}
	cubic_wave
	scale 8.01
}

#declare Wall2 = pigment {
	gradient x
	color_map {
		[0 color transmit 0]
		[1 color transmit 1]
	}
	scale 8.01
}

polygon {
	4 <-8,5,-55>,<8,5,-55>,<8,5,25>,<-8,5,25>
	pigment {
		gradient z
		pigment_map {
			[0 Wall2]
			[1/4 Wall1]
			[1 Wall1]
		}
		cubic_wave
		scale <1,1,35>
		translate z*25
	}
}

intersection {
	disc {0,y,18,2}
	box {0,18}
	pigment {
		onion
		color_map {
			[0 color transmit 0]
			[1/9 color transmit 1]
			[5/9 color transmit 0]
			[1 color transmit 1]
		}
		scale 18
	}
	translate <-10,5,25>
}