#version unofficial MegaPov 0.7;

#declare HeadThick = .5;
#declare NeckThick = .4;
#declare ArmUpperThick = .6;
#declare ArmLowerThick = .5;
#declare LegUpperThick = .7;
#declare LegLowerThick = .6;
#declare EyeSize = .15;

#declare GoodRobotTex = texture {
	pigment {color transmit 1.25}
	finish {specular .5}
}

#declare BadRobotTex = texture {
	pigment {color red 1}
	finish {specular 1}
}

#declare RobotInterior = interior {
	ior 4/3
//	dispersion 1.3
//	disp_nelems 50
}

// Figure #1
#declare NeckR = <0,-60,0>;
#declare HeadR = <0,-30,0>;
#declare LeftArmUpperR = <30,0,90>;
#declare LeftArmLowerR = <0,0,0>;
#declare RightArmUpperR = <-5,0,-30>;
#declare RightArmLowerR = <60,0,30>;
#declare LeftLegUpperR = <5,0,10>;
#declare LeftLegLowerR = <-30,0,0>;
#declare RightLegUpperR = <5,0,-10>;
#declare RightLegLowerR = <-20,0,0>;
#declare BodyR = <0,60,0>;

#declare NeckT = <0,1,0>;
#declare HeadT = <0,2,-.25>;
#declare LeftArmUpperT = <1.5,1.2,0>;
#declare LeftArmLowerT = <0,-3,0>;
#declare RightArmUpperT = <-1.5,1.2,0>;
#declare RightArmLowerT = <0,-3,0>;
#declare LeftLegUpperT = <1,-2,0>;
#declare LeftLegLowerT = <0,-3,0>;
#declare RightLegUpperT = <-1,-2,0>;
#declare RightLegLowerT = <0,-3,0>;
#declare BodyT = <0,9,15>;
union {
	merge {
		// Main Torso
		blob {
			cylinder {<-1,1,0>,<1,1,0>,1 .5}
			cylinder {<-1,1,0>,<-1,-2,0>,1 .5}
			cylinder {<0,1,0>,<0,-2,0>,1 .5}
			cylinder {<1,1,0>,<1,-2,0>,1 .5}
			threshold .1
		}
		// Neck
		merge {
			cylinder {0,3/2*y,NeckThick}
			sphere {0,NeckThick}
			sphere {3*y/2,NeckThick}
			bounded_by {box{-NeckThick,NeckThick+3*y/2}}
			rotate NeckR translate NeckT
		}
		// Head
		merge {
			cylinder {0,y/2,HeadThick}
			sphere {0,HeadThick}
			sphere {y/2,HeadThick}
			bounded_by {box {-HeadThick,HeadThick+3*y/2}}
			rotate HeadR translate HeadT
			rotate NeckR translate NeckT
		}
		// Left Arm Upper
		merge {
			cylinder {0,y*-3,ArmUpperThick}
			sphere {0,ArmUpperThick}
			sphere {y*-3,ArmUpperThick}
			bounded_by {box {-ArmUpperThick-y*3,ArmUpperThick}}
			rotate LeftArmUpperR translate LeftArmUpperT
		}
		// Left Arm Lower
		merge {
			cylinder {0,y*-2,ArmLowerThick}
			sphere {0,ArmLowerThick}
			sphere {y*-2,ArmLowerThick}
			bounded_by {box {-ArmLowerThick-y*2,ArmLowerThick}}
			rotate LeftArmLowerR translate LeftArmLowerT
			rotate LeftArmUpperR translate LeftArmUpperT
		}
		// Right Arm Upper
		merge {
			cylinder {0,y*-3,ArmUpperThick}
			sphere {0,ArmUpperThick}
			sphere {y*-3,ArmUpperThick}
			bounded_by {box {-ArmUpperThick-y*3,ArmUpperThick}}
			rotate RightArmUpperR translate RightArmUpperT
		}
		// Right Arm Lower
		merge {
			cylinder {0,y*-2,ArmLowerThick}
			sphere {0,ArmLowerThick}
			sphere {y*-2,ArmLowerThick}
			bounded_by {box {-ArmLowerThick-y*2,ArmLowerThick}}
			rotate RightArmLowerR translate RightArmLowerT
			rotate RightArmUpperR translate RightArmUpperT
		}
		// Left Leg Upper
		merge {
			cylinder {0,y*-3,LegUpperThick}
			sphere {0,LegUpperThick}
			sphere {y*-3,LegUpperThick}
			bounded_by {box {-LegUpperThick-y*3,LegUpperThick}}
			rotate LeftLegUpperR translate LeftLegUpperT
		}
		// Left Leg Lower
		merge {
			cylinder {0,y*-3,LegLowerThick}
			sphere {0,LegLowerThick}
			sphere {y*-3,LegLowerThick}
			bounded_by {box {-LegLowerThick-y*3,LegLowerThick}}
			rotate LeftLegLowerR translate LeftLegLowerT
			rotate LeftLegUpperR translate LeftLegUpperT
		}
      // Right Leg Upper
      merge {
      	cylinder {0,y*-3,LegUpperThick}
			sphere {0,LegUpperThick}
			sphere {y*-3,LegUpperThick}
			bounded_by {box {-LegUpperThick-y*3,LegUpperThick}}
      	rotate RightLegUpperR translate RightLegUpperT
      }
      // Right Leg Lower
      merge {
			cylinder {0,y*-3,LegLowerThick}
			sphere {0,LegLowerThick}
			sphere {y*-3,LegLowerThick}
			bounded_by {box {-LegLowerThick-y*3,LegLowerThick}}
			rotate RightLegLowerR translate RightLegLowerT
			rotate RightLegUpperR translate RightLegUpperT
		}

		#if (Textures = 0)
			texture {BadRobotTex}
		#end
		#if (Textures = 1)
			texture {GoodRobotTex}
			interior {RobotInterior}
		#end		
		no_shadow
	}
	// Sword
	merge {
		cylinder {0,y*8,.25}
		sphere {0,.25}
		sphere {y*8,.25}
	
		#if (Textures = 0)
			texture {
				pigment {color rgb 1}
				finish {specular 1}
			}
		#else
			texture {
				pigment {color transmit 1}
				finish {specular 1}
			}
			interior {
				media {
					emission 1
					density {
						cylindrical
						color_map {
							[0.75 rgb <0,2,0>]
							[0.85 rgb <0,3,0>]
							[1.0 rgb 8]
						}
					}
				}
			}
		#end

		bounded_by {box{<-.25,-.25,-.25>,<.25,8.25,.25>}}
		rotate x*-90
		translate <0,-2,0>
		rotate RightArmLowerR translate RightArmLowerT rotate RightArmUpperR translate RightArmUpperT

		no_shadow	
	}
	#if (SwordLights != 0)
		light_source {
			y*4 color rgb <.25,1,.25>
			area_light
			y*4,x,SwordLights,1
			fade_distance 4
			fade_power 2
			rotate x*-90
			translate <0,-2,0>
			rotate RightArmLowerR translate RightArmLowerT rotate RightArmUpperR translate RightArmUpperT
		}
	#end
	rotate BodyR translate BodyT
	hollow
	light_group "!Sun"
}

// Figure #2
#declare NeckR = <0,0,0>;
#declare HeadR = <0,0,0>;
#declare LeftArmUpperR = <95,0,0>;
#declare LeftArmLowerR = <70,45,0>;
#declare RightArmUpperR = <60,0,-45>;
#declare RightArmLowerR = <45,0,0>;
#declare LeftLegUpperR = <90,0,0>;
#declare LeftLegLowerR = <-90,0,0>;
#declare RightLegUpperR = <-10,0,0>;
#declare RightLegLowerR = <-80,0,0>;
#declare BodyR = <0,175,0>;

#declare NeckT = <0,1,0>;
#declare HeadT = <0,2,-.25>;
#declare LeftArmUpperT = <1.5,1.2,0>;
#declare LeftArmLowerT = <0,-3,0>;
#declare RightArmUpperT = <-1.5,1.2,0>;
#declare RightArmLowerT = <0,-3,0>;
#declare LeftLegUpperT = <1,-2,0>;
#declare LeftLegLowerT = <0,-3,0>;
#declare RightLegUpperT = <-1,-2,0>;
#declare RightLegLowerT = <0,-3,0>;
#declare BodyT = <0,6,-20>;
union {
	merge {
		// Main Torso
		blob {
			cylinder {<-1,1,0>,<1,1,0>,1 .5}
			cylinder {<-1,1,0>,<-1,-2,0>,1 .5}
			cylinder {<0,1,0>,<0,-2,0>,1 .5}
			cylinder {<1,1,0>,<1,-2,0>,1 .5}
			threshold .1
		}
		// Neck
		merge {
			cylinder {0,3/2*y,NeckThick}
			sphere {0,NeckThick}
			sphere {3*y/2,NeckThick}
			bounded_by {box{-NeckThick,NeckThick+3*y/2}}
			rotate NeckR translate NeckT
		}
		// Head
		merge {
			cylinder {0,y/2,HeadThick}
			sphere {0,HeadThick}
			sphere {y/2,HeadThick}
			bounded_by {box {-HeadThick,HeadThick+3*y/2}}
			rotate HeadR translate HeadT
			rotate NeckR translate NeckT
		}
		// Left Arm Upper
		merge {
			cylinder {0,y*-3,ArmUpperThick}
			sphere {0,ArmUpperThick}
			sphere {y*-3,ArmUpperThick}
			bounded_by {box {-ArmUpperThick-y*3,ArmUpperThick}}
			rotate LeftArmUpperR translate LeftArmUpperT
		}
		// Left Arm Lower
		merge {
			cylinder {0,y*-2,ArmLowerThick}
			sphere {0,ArmLowerThick}
			sphere {y*-2,ArmLowerThick}
			bounded_by {box {-ArmLowerThick-y*2,ArmLowerThick}}
			rotate LeftArmLowerR translate LeftArmLowerT
			rotate LeftArmUpperR translate LeftArmUpperT
		}
		// Right Arm Upper
		merge {
			cylinder {0,y*-3,ArmUpperThick}
			sphere {0,ArmUpperThick}
			sphere {y*-3,ArmUpperThick}
			bounded_by {box {-ArmUpperThick-y*3,ArmUpperThick}}
			rotate RightArmUpperR translate RightArmUpperT
		}
		// Right Arm Lower
		merge {
			cylinder {0,y*-2,ArmLowerThick}
			sphere {0,ArmLowerThick}
			sphere {y*-2,ArmLowerThick}
			bounded_by {box {-ArmLowerThick-y*2,ArmLowerThick}}
			rotate RightArmLowerR translate RightArmLowerT
			rotate RightArmUpperR translate RightArmUpperT
		}
		// Left Leg Upper
		merge {
			cylinder {0,y*-3,LegUpperThick}
			sphere {0,LegUpperThick}
			sphere {y*-3,LegUpperThick}
			bounded_by {box {-LegUpperThick-y*3,LegUpperThick}}
			rotate LeftLegUpperR translate LeftLegUpperT
		}
		// Left Leg Lower
		merge {
			cylinder {0,y*-3,LegLowerThick}
			sphere {0,LegLowerThick}
			sphere {y*-3,LegLowerThick}
			bounded_by {box {-LegLowerThick-y*3,LegLowerThick}}
			rotate LeftLegLowerR translate LeftLegLowerT
			rotate LeftLegUpperR translate LeftLegUpperT
		}
      // Right Leg Upper
      merge {
      	cylinder {0,y*-3,LegUpperThick}
			sphere {0,LegUpperThick}
			sphere {y*-3,LegUpperThick}
			bounded_by {box {-LegUpperThick-y*3,LegUpperThick}}
      	rotate RightLegUpperR translate RightLegUpperT
      }
      // Right Leg Lower
      merge {
			cylinder {0,y*-3,LegLowerThick}
			sphere {0,LegLowerThick}
			sphere {y*-3,LegLowerThick}
			bounded_by {box {-LegLowerThick-y*3,LegLowerThick}}
			rotate RightLegLowerR translate RightLegLowerT
			rotate RightLegUpperR translate RightLegUpperT
		}

		#if (Textures = 0)
			texture {BadRobotTex}
		#end
		#if (Textures = 1)
			texture {GoodRobotTex}
			interior {RobotInterior}
		#end
		no_shadow
	}
	// Sword
	merge {
		cylinder {-y*6,y*6,.25}
		sphere {y*-6,.25}
		sphere {y*6,.25}
	
		#if (Textures = 0)
			texture {
				pigment {color rgb 1}
				finish {specular 1}
			}
		#else
			texture {
				pigment {color transmit 1}
				finish {specular 1}
			}
			interior {
				media {
					emission 1
					density {
						cylindrical
						color_map {
							[0.75 rgb <2,0,0>]
							[0.85 rgb <3,0,0>]
							[1.0 rgb 5]
						}
					}
				}
			}
		#end

		bounded_by {box{<-.25,-6.25,-.25>,<.25,6.25,.25>}}
		rotate x*-90
		translate <0,-2,-2>
		rotate RightArmLowerR translate RightArmLowerT rotate RightArmUpperR translate RightArmUpperT

		no_shadow	
	}
	#if (SwordLights != 0)
		light_source {
			0 color rgb <1,.25,.25>
			area_light
			y*6,x,SwordLights,1
			fade_distance 4
			fade_power 2
			rotate x*-90
			translate <0,-2,0>
			rotate RightArmLowerR translate RightArmLowerT rotate RightArmUpperR translate RightArmUpperT
		}
	#end
	rotate BodyR translate BodyT
	scale <-1,1,1>
	hollow
	light_group "!Sun"
}
