#include "textures.inc"

#declare ShowBuilding=1;

camera {
   location <-0.5,0,0>
   look_at <-0.5,0,1>
}

/*camera {
   location <-0.5,0,7>
   look_at <-0.5,-2,10>
}*/

// sun
light_source {
   <6,9,35>
   color rgb <1,1,1>
}

// sunspot on sky
light_source {
   <6,9,45>
   color rgb <2,2,-1>
   spotlight
   point_at <6,9,46>
   radius 15
   tightness 10
   falloff 16
}

// spot
light_source {
  <0,0,1>
  color rgb <1,1,1>
  shadowless
}


// ugly sky
plane {
   z, 50
   pigment {
      bozo
      turbulence 0.56
      color_map {
         [0.5 rgb <0.5, 0.5, 1.0>]
         [0.6 rgb 1.0]
         [1.0 rgb 0.5]
      }
      scale <10,10,1>
   }
}

// unseen ground
plane {
   z, 0
   pigment { rgb 0.5 }
}

// silly building
#declare SillyBuilding = 
box {
   <1, -1, 0>
   <-1, 1, 10>
   texture { Chrome_Texture }
}

// building block
#declare bx1=0.05;
#declare bx2=0.02;

#declare Box1 =
difference {
   box {
      <0,0,0>
      <1,1,1>
   }
   box {
      <-bx1, bx1,  bx1>
      <1+bx1,1-bx1,1-bx1>
   }
   box {
      <bx1,  -bx1, bx1>
      <1-bx1,1+bx1,1-bx1>
   }
}

#declare Box =
union {
   object {
      Box1
      pigment { rgb <0,0,0.3> }
   }
   union {
      box {
         <bx2,bx1,bx1>
         <1-bx2,1-bx1,1-bx1>
      }
      box {
         <bx1,  bx2,  bx1>
         <1-bx1,1-bx2,1-bx1>
      }
      texture { Chrome_Texture }
   }
}

// building
#declare bl1 = 0.2;

#declare Building1 =
union {
   #declare x1=-1;
   #declare y1=-1;
   
   #while (x1 < 1-bl1)
      object { Box scale <bl1,bl1,bl1> translate <x1,y1,0> }
      #declare x1=x1+bl1;
   #end
   
   #while (y1 < 1-bl1)
      object { Box scale <bl1,bl1,bl1> translate <x1,y1,0> }
      #declare y1=y1+bl1;
   #end
   
   #while (x1 >= -1+bl1)
      object { Box scale <bl1,bl1,bl1> translate <x1,y1,0> }
      #declare x1=x1-bl1;
   #end
   
   #while (y1 >= -1+bl1)
      object { Box scale <bl1,bl1,bl1> translate <x1,y1,0> }
      #declare y1=y1-bl1;
   #end
}

#declare Building =
union {
   #declare z1=0;
   #while (z1 < 10)
      object { Building1 translate <0,0,z1> }
      #declare z1=z1+bl1;
   #end
}

// place buildings

#if (ShowBuilding=1)
   object {
      Building
      translate <-2,0,0>
   }
   
   object {
      Building
      translate <2,0,0>
   }
   
   object {
      Building
      translate <-2,3,0>
   }
   
   object {
      Building
      translate <2,3,0>
   }
   
   object {
      Building
      translate <-2,-3,0>
   }
   
   object {
      Building
      translate <2,-3,0>
   }
#end

// birdie

#declare Bird =
union {
   sphere {
      <0, 0, 0>
      1
      scale <0.25,1,0.25>
   }
   disc {
      <0, 0.5, 0.25>
      z,
      1
      scale <2, 0.25, 0.2>
   }
   pigment { rgb <0.5, 0.25, 0> }
}

// place birdies

object {
   Bird
   scale <0.1, 0.1, 0.1>
   rotate <0, 0, 30>
   translate <1, 2, 20>
}

object {
   Bird
   scale <0.1, 0.1, 0.1>
   rotate <0, 0, -50>
   translate <-1, -1, 24>
}

object {
   Bird
   scale <0.1, 0.1, 0.1>
   rotate <0, 0, 40>
   translate <2.5, -3, 18>
   
}


// smoke?
triangle {
   <0.8, -1.5, 3.5>
   <0.5, -1.5, 2>
   <3.0, -1.3, 2>
   //pigment { rgb 0.5 }
   pigment {
       bozo
       turbulence 5
       color_map {
           [0.5 rgbt <1, 1, 1, 1>]
           [1.0 rgbt <1, 1, 1, 0>]
       }
       translate <1,0,0>
   }
}

// stuff on top building
#declare WW1 =
union {
   cylinder {
      <0.1,0,0>
      <-0.12,0,0.32>
      0.01
      pigment { rgb 0.2 }
   }
   
   cylinder {
      <0.3,0,0.2>
      <-0.3,0,0.4>
      0.01
      pigment { rgb 0.2 }
   }
}

object {
   WW1
   scale 0.7
   translate <1,-2.7,10>
}

object {
   WW1
   scale 0.7
   translate <1,-3.0,10>
}