#version unofficial MegaPov 0.4;
#include "colors.inc"
#debug concat("Doing city.inc...", "\n")

#declare Rand1 = seed(28563);

// macros

#macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
  #if (vlength(vY)>0)
    #local vZ1=vnormalize(vcross(vX1,vY));
    #local vZ2=vnormalize(vcross(vX2,vY));
    matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
    matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
  #end
#end

#macro MakeBuilding(pShape, pBase, pXPos, pZPos)
  #declare pXRand = (rand(Rand1)-0.5);
  #declare pRand = rand(Rand1)-0.5;
  #declare pZRand = (rand(Rand1)-0.5);
  #declare mNorm = <0,0,0>;
  #declare mTracePos = trace(pBase, <pXPos+pXRand, 500, pZPos+pZRand>, <pXPos+pXPos, -500, pZPos+pZRand>, mNorm);

  #if (mTracePos.y > 150) 
  object{
    pShape
    #if (scale_and_align = 1)
      scale <1 + rand(Rand1) , 0.25 + rand(Rand1), 1 + rand(Rand1)>
      Reorient(-z, <mNorm.x, 0, mNorm.z>)
    #end
    translate mTracePos
    translate <25, -220, 0>
  }
  #end   

#end

#macro snow_blobs_macro()
  #declare R_Val = 0.1;
  #declare S_Val = 1.0;
  #declare x_count = 5;
  #while (x_count < 16)
    #declare z_count = 0;
    #while (z_count < 3)
      #declare norm_reg = <0,0,0>;
      #declare trace_result =
        trace(near_range, <x_count-10.5, 100, z_count>, <x_count-10.5, -100, z_count>, norm_reg);
      #if ((trace_result.y/20) + (norm_reg.y*1.5) > 0.90)
        sphere {
          <0,0,0>, R_Val, S_Val 
          scale <1.4+(rand(Rand1)/2), 0.75, 1.4+(rand(Rand1)/2)>
          Reorient(y, norm_reg)
          translate trace_result
        }          
      #end
      #declare z_count = z_count + 0.0175 + (rand(Rand1)/200) - 0.0025 + (speedAdd/100); //0.0175 was 0.0125
    #end
    #declare x_count = x_count + 0.0175 + (rand(Rand1)/200) - 0.0025 + (speedAdd/100); //0.0175 was 0.0125
  #end
#end


// textures

#declare far_snow_texture =
texture{
  pigment{rgb<1,1,1.2>}
  normal {bumps 1 scale 0.001}// turbulence 0.5}
  finish{ambient 0.1 diffuse 0.65}
}

#declare city_rock_texture =
texture{
  pigment{Grey}
  normal{
    average 2
    normal_map{
      [dents 6 scale 0.1 ]
      [granite 6 scale 0.1 turbulence 0.25]
      [marble 6 scale 0.1 turbulence 0.5]
      [crackle 6 scale 0.1 turbulence 0.5]
    }
  }
  scale <350,200,150>
}

#declare far_rock_texture =
texture{
  pigment{Grey}
  normal{
    average 2
    normal_map{
      [dents 30 scale 1 ]
      [granite 30 scale 1 turbulence 0.25]
      [marble 30 scale 1 turbulence 0.5]
      [crackle 30 scale 1 turbulence 0.5]
    }
  }
}

#declare far_rock_face_texture =
texture{
  agate scale 0.025 turbulence 0.5
  texture_map{
    [0.960 far_rock_texture]
    [0.965 far_snow_texture]
  }
}  

#declare far_mountain_texture =
texture{
  slope 6*y, y
  texture_map{
    [0.55 far_rock_face_texture]
    [0.55 far_snow_texture]
  }
}


// objects
// mountains    

#declare far_range =
height_field{
  tga
  "far_range.tga"
  smooth
  translate <-0.5,0,0>
  texture{far_mountain_texture}
  scale <9000,3600,1500>
}

#declare near_range =
height_field{
  tga
  "near_range.tga"     
  smooth
  texture{city_rock_texture scale <1/350,1/200,1/150>}
  translate <-0.5,0,0> 
  scale <21,10,5>
}

#declare one_city_peak =
height_field{
  tga               
  "city_peak.tga"     
  smooth
  translate <-0.5,0.0,-0.5> 
  scale <350,200,150>
}

#declare city_peak =
union{
  object{one_city_peak}
  object{one_city_peak scale <0.75,0.85,0.75> rotate y*160 translate x*-25 translate z*-25}
  object{one_city_peak scale <0.5,1.05,0.5> rotate y*200 translate x*-15 translate z*15}
}
#debug concat("Finished city.inc...", "\n")
