#version unofficial MegaPov 0.4;
#debug concat("Doing balloon.inc...", "\n")
// ----------------------------------------

#declare net_pigment =
pigment{
  image_pattern{gif "net.gif" map_type 1}
  pigment_map{
    [0.5 rgbf 1]
    [0.5 rgb<1,1,0.75>]
  }
}

#declare net_normal =
normal{
  image_pattern{gif "net.gif" map_type 1}
  normal_map{[0.5 bump_map{gif "net.gif" map_type 1} 10]}
}

#declare balloon_section =
lathe {
  cubic_spline
  6,
  <-1, -1>, <0, 0>, <2, 3>, <2, 5>, <0, 6>, <-1, 6> // the list of <u,v> points
  scale<0.5,1,1>
  translate y*-3
}

#declare all_sections =
union{
  object{balloon_section rotate y*0 pigment{Red*1}  normal{wrinkles 0.5 scale 0.05} finish{ambient 0.3}}
  object{balloon_section rotate y*30 pigment{White*1}  normal{wrinkles 0.5 scale 0.05} finish{ambient 0.3}}
  object{balloon_section rotate y*60 pigment{Red*1}  normal{wrinkles 0.5 scale 0.05} finish{ambient 0.3}}
  object{balloon_section rotate y*90 pigment{White*1}  normal{wrinkles 0.5 scale 0.05} finish{ambient 0.3}}
  object{balloon_section rotate y*120 pigment{Red*1}  normal{wrinkles 0.5 scale 0.05} finish{ambient 0.3}}
  object{balloon_section rotate y*150 pigment{White*1}  normal{wrinkles 0.5 scale 0.05} finish{ambient 0.3}}
}

#declare hollow_sections =
difference{
  object{all_sections hollow on}
  cylinder{<0,0,0>,<0,6,0> 0.2}
  box{<-5,-4,-5>,<5,-2.5,5>}
  pigment{rgbf 1}
}

#declare hollow_sections_nopig =
difference{
  object{balloon_section scale<2,1,1> hollow on}
  cylinder{<0,0,0>,<0,6,0> 0.2}
  box{<-5,-4,-5>,<5,-2.5,5>}
  pigment{net_pigment}
  normal{net_normal}
}

#declare net_and_balloon =
union{
  object{
    hollow_sections
  }
  object{
    hollow_sections_nopig
    scale 1.01
  }
}

#init_spline {
  "cane_spline",
  #declare x_spline = 0;
  #declare y_spline = 0.5;
  #while (x_spline <= 20)
    <x_spline, y_spline>
    #declare x_spline = x_spline + 1;
    #declare y_spline = - y_spline;
  #end
}

#declare basket_side =
union{
  #declare cane_array = 0;
  #declare stagger = 0.5;
  #while (cane_array <= 20)
    #declare cane=0;
    #while (cane <= 20)
      sphere { <cane, eval_spline ("cane_spline",cane),0>,0.25 scale<1,1,2>translate z*cane_array translate x*stagger}
      #declare cane= cane + 0.2;
    #end
    #declare stagger = - stagger;
    #declare cane_array = cane_array + 1;
  #end
  #declare strut = 0;
  #while (strut < 20)
    cylinder{<strut,0,-1>,<strut,0,21>, 0.15 translate x*0.5}
    #declare strut = strut + 1;
  #end
}

#declare basket =
union{
  object{basket_side}
  object{basket_side rotate z*-90}
  object{basket_side rotate z*-90 translate x*20}
  object{basket_side translate y*-20}
  box{<0,0,0>,<22,-22,1> translate<-1,1,1>}
  pigment{Goldenrod}
  rotate x*-90
  translate <-10,-10,-10>
}

#declare connect_pigment =
pigment{
  image_pattern{gif "net.gif" map_type 2}
  pigment_map{
    [0.25 rgbf 1]
    [0.25 rgb<1,1,0.75>]
  }
}

#declare connect_normal =
normal{
  image_pattern{gif "net.gif" map_type 2}
  normal_map{[0.5 bump_map{gif "net.gif" map_type 1} 5]}
}

#declare connect_ropes =
difference{
  cone{
    <0,0,0>, 1.0, <0,1,0>, 1.75 open
    pigment{connect_pigment}
    normal{connect_normal}
    scale <14,100,14>
  }
  cylinder{<-25,0,0>,<25,0,0>,8 pigment{rgbf 1} scale<1,4,1>}
  cylinder{<0,0,-25>,<0,0,25>,8 pigment{rgbf 1} scale<1,4,1>}
  translate y*9
}

#declare full_basket =
union{
  object{basket}
  object{connect_ropes}
  scale 0.025

}

#macro make_balloon(balloon_type)
  #if (balloon_type = 1)
    #include "balloonist.inc"
    #declare whole_balloon = 
    union{
      object{net_and_balloon translate y*4}
      object{full_basket}
      object{BlobMan scale 0.5 scale 0.025 translate y*0.5 translate z*-0.1 rotate y*180}
      object{balloon_torch}
      scale 4
    }
  #end

  #if (balloon_type = 2)
    #declare balloon_pigment = pigment{Green}
  #end
  #if (balloon_type = 3)
    #declare balloon_pigment = pigment{Red}
  #end
  #if (balloon_type = 4)
    #declare balloon_pigment = pigment{Yellow}
  #end
  #if (balloon_type = 5)
    #declare balloon_pigment = pigment{Magenta}
  #end
  #if (balloon_type = 6)
    #declare balloon_pigment = pigment{Orange}
  #end
  #if (balloon_type = 7)
    #declare balloon_pigment = pigment{Med_Purple}
  #end
  #if (balloon_type = 8)
    #declare balloon_pigment = pigment{Green}
  #end
  #if (balloon_type = 9)
    #declare balloon_pigment = pigment{Plum}
  #end
  #if (balloon_type = 10)
    #declare balloon_pigment = pigment{DarkOrchid}
  #end
  
  #if (balloon_type > 1)  
    #declare whole_balloon = 
    union{
      object{balloon_section scale<2,1,1> translate y*4 pigment{balloon_pigment} finish{ambient 0.3}}
      object{hollow_sections_nopig scale 1.01 translate y*4}
      box{<-10,-10,-10>,<10,10,10> pigment{Yellow} scale 0.025}
      scale 4
    }
  #end
#end
#debug concat("Finished balloon.inc...", "\n")
