// umbrella.inc
// Generates an umbrella object

#declare _UmbrellaSeed = seed(345);

// a person macro
#macro Person(X, Y, Z, R)
#local LegRadius = 0.075;
#local LegOffset = 0.125;
#local LegHeight = 0.8;
#local ArmRadius = 0.05;
#local ArmOffset = 0.25;
#local ArmHeight = 1.5;

union {
    // legs
    cylinder { <LegOffset,0,0>, <LegOffset,LegHeight,0> LegRadius }
    cylinder { <-LegOffset,0,0>, <-LegOffset,LegHeight,0> LegRadius }
    // torso
    superellipsoid { <0.2,0.2>
        scale <0.2,0.375,0.075>
        translate <0,1.175,0>
    }
    // arms
    cylinder { <ArmOffset,LegHeight,0>, <ArmOffset,ArmHeight,0> ArmRadius }
    cylinder { <-ArmOffset,LegHeight,0>, <-ArmOffset,ArmHeight,0> ArmRadius }
    // head
    sphere { <0,0,0> 1
        scale <0.1,0.13,0.11>
        translate <0,1.675,0>
    }
    texture {
        pigment { rgb <rand(_UmbrellaSeed)/2,rand(_UmbrellaSeed)/2,rand(_UmbrellaSeed)/2> }
    }
    rotate <0,R,0>
    translate <X,Y,Z>
}
#end

// umbrella macro
#macro Umbrella(x1, y1, z1, Height, Radius, Blades, BladeLength, Colour1, Colour2)

#local Ang = 360 / Blades;

object {
	intersection {
		sphere { <0,Height-Radius,0>, Radius }
		#local i = 0;
		#while (i < Blades)
			plane { x, BladeLength
				rotate <0, Ang*i, 0>
			}
			#local i = i + 1;
		#end
		#local B = BladeLength / cos(pi/Blades);
		plane { -y, (-sqrt(Radius*Radius - B*B) - Height + Radius) }
	}

	// texture
	texture {
		#switch (rand(_UmbrellaSeed))
		#range(0.0,0.6)
			pigment { radial
				colour_map {
					[ 0.0 Colour1 ]
					[ 0.5 Colour1 ]
					[ 0.5 Colour2 ]
					[ 1.0 Colour2 ]
				}
				frequency (Blades / 2)
				rotate <0, Ang/2, 0>
			}
		#break
		#range(0.6,0.8)
			pigment { Colour1 }
		#break
		#range(0.8,1.0)
			pigment { wood
				colour_map {
					[ 0.0 Colour1 ]
					[ 0.5 Colour1 ]
					[ 0.5 Colour2 ]
					[ 1.0 Colour2 ]
				}
				scale 0.3
				rotate <90,0,0>
			}
		#break
		#end
		normal { wrinkles 0.2
			scale 0.3
		}
		finish {
			reflection 0.2
		}
	}
	rotate <rand(_UmbrellaSeed)*15, rand(_UmbrellaSeed)*180, 0>
	// translate into place
	translate <x1,y1,z1>
}

Person(x1,y1,z1, rand(_UmbrellaSeed)*180)

#end // macro Umbrella()