// dmcity.pov
// David Morgan-Mar

#declare Brollies = 1;
#declare Vehicles = 1;
#declare GlassPane = 1;
#declare Rain = 1;
#declare Gloomy = 1;
#declare Foggy = 1;

#declare NumBrollies = 10;
#declare NumDrops = 200;

#declare Seed1 = seed(4029);

#if (Gloomy)
	#declare Bright = 0.5;
	global_settings {
		ambient_light 3
		max_trace_level 20
	}
#else
	#declare Bright = 2;
#end

#declare KerbWidth = 4.5;
#declare KerbHeight = 0.15;
#declare RoadRadius = 75;

#declare camera1 = camera {
	location <-10,10,-25>
	look_at <-2,5,0>
}
#declare camera2 = camera {
	location <-10,10,-10>
	look_at <-10,0,-10>
	orthographic
}
#declare camera3 = camera {
	location <0,50,0>
	look_at <0,0,0>
}

camera { camera1 }

light_source { <-10,20,-50>, rgb <Bright,Bright,Bright>
	#if (Gloomy)
		shadowless
	#end
}

#if (Foggy)
	fog { rgb <0.5, 0.5, 0.5>
		distance 50
	}
#end

sky_sphere {
	pigment { gradient y
		colour_map {
			[0.0 rgb <1, 1, 1> ]
			[0.5 rgb <0.9, 0.95, 1> ]
			[0.75 rgb <0.03, 0.0, 0.2> ]
			[1.0 rgb <0.0, 0.0, 0.1> ]
		}
		scale 2
		translate -1
		turbulence 0.06
	}
}

// McPOValds sign
box { <0,0,0>, <1,1,1>
	texture {
		pigment {
			image_map { gif "McPOValds.gif" }
		}
		finish { ambient 0.9 }
	}
	scale <1,7,0.1>
	translate <9.5,5,17.5>
}

// street texture
#declare line_colour = rgb <1,1,1>;
#declare street_colour = rgb <0.1,0.1,0.1>;
#declare street_normal = normal { wrinkles 0.1
		scale 0.2
	}
#declare street_finish = finish {
		reflection 0.3
	}
#declare street_T = texture {
	pigment { street_colour }
	normal { street_normal }
	finish { street_finish }
}
#declare pavement_T = texture {
	pigment {wrinkles color_map {[0 rgb .5] [1 rgb .6]} scale 1.5}
	normal { street_normal }
	finish { street_finish }
}

// city macro stuff
#declare city_seed = 19;
#declare traffic_spacing = 10;
#declare traffic_lanes = 2;
#declare city_block_count = <2, 0, 6>;
#declare buildings_per_block = <1, 0, 5>;
#declare city_night = true;
#declare pavement_width = 4.5;
#include "dmcity.obj"
#include "CITY.inc"

#declare StreetHalfWidth = (traffic_lanes*2 + 1) * 1.5;

// default plane surface
plane {y, -0.01 pigment {rgb <0, 0.2, 0>}}
// intersection square of road
#declare LineWidth = 0.2;
#declare WalkWidth = 4;
union {
	box { <-StreetHalfWidth,0,-StreetHalfWidth>, <StreetHalfWidth,0.01,StreetHalfWidth>
		texture {
			pigment { checker
				street_colour, line_colour
				translate <0.5,0,0.5>
				scale (StreetHalfWidth - LineWidth) * 2
			}
			normal { street_normal }
			finish { street_finish }
		}
	}
	#declare i = 0;
	#while (i < 4)
		box { <StreetHalfWidth,0,-StreetHalfWidth>, <StreetHalfWidth+WalkWidth,0.01,StreetHalfWidth>
			texture {
				pigment { gradient x
					colour_map {
						[0.0 street_colour]
						[(WalkWidth-LineWidth)/WalkWidth street_colour]
						[(WalkWidth-LineWidth)/WalkWidth line_colour]
						[1.0 line_colour]
					}
					scale WalkWidth
					translate StreetHalfWidth
				}
				normal { street_normal }
				finish { street_finish }
			}
			rotate <0,i*90,0>
		}
		#declare i = i + 1;
	#end
}

// traffic lights
#declare RedFacing = true;
#declare x0 = StreetHalfWidth + 0.8;
#declare z0 = x0 + 3;

union {
	object { green_traffic_light translate <-x0,0,-z0> }
	object { green_traffic_light rotate <0,180,0> translate <x0,0,z0> }
	object { red_traffic_light rotate <0,90,0> translate <-z0,0,x0> }
	object { red_traffic_light rotate <0,270,0> translate <z0,0,-x0> }
	#if (RedFacing)
		rotate <0,90,0>
	#end
}

// umbrellas
#if (Brollies)
	#include "umbrella.inc"
	#declare i = 0;
	#while (i < NumBrollies)
		#declare colour1 = rgb <rand(Seed1),rand(Seed1),rand(Seed1)>;
		#declare colour2 = rgb <rand(Seed1),rand(Seed1),rand(Seed1)>;
		#declare blades = 2*int(rand(Seed1)*3) + 6;
		Umbrella(-x0-rand(Seed1)*pavement_width,0,-StreetHalfWidth-rand(Seed1)*10,
			1.9, 0.9, blades,0.6, colour1, colour2)
		#declare colour1 = rgb <rand(Seed1),rand(Seed1),rand(Seed1)>;
		#declare colour2 = rgb <rand(Seed1),rand(Seed1),rand(Seed1)>;
		#declare blades = 2*int(rand(Seed1)*3) + 6;
		Umbrella(-x0-rand(Seed1)*pavement_width,0,StreetHalfWidth+rand(Seed1)*30,
			1.9, 0.9, blades,0.6, colour1, colour2)
		#declare colour1 = rgb <rand(Seed1),rand(Seed1),rand(Seed1)>;
		#declare colour2 = rgb <rand(Seed1),rand(Seed1),rand(Seed1)>;
		#declare blades = 2*int(rand(Seed1)*3) + 6;
		Umbrella(x0+rand(Seed1)*pavement_width,0,-StreetHalfWidth-rand(Seed1)*20,
			1.9, 0.9, blades,0.6, colour1, colour2)
		#declare colour1 = rgb <rand(Seed1),rand(Seed1),rand(Seed1)>;
		#declare colour2 = rgb <rand(Seed1),rand(Seed1),rand(Seed1)>;
		#declare blades = 2*int(rand(Seed1)*3) + 6;
		Umbrella(x0+rand(Seed1)*pavement_width,0,StreetHalfWidth+rand(Seed1)*30,
			1.9, 0.9, blades,0.6, colour1, colour2)
		#declare colour1 = rgb <rand(Seed1),rand(Seed1),rand(Seed1)>;
		#declare colour2 = rgb <rand(Seed1),rand(Seed1),rand(Seed1)>;
		#declare blades = 2*int(rand(Seed1)*3) + 6;
		Umbrella(x0+rand(Seed1)*30,0,StreetHalfWidth+rand(Seed1)*pavement_width,
			1.9, 0.9, blades,0.6, colour1, colour2)
		#declare i = i + 1;
	#end
#end // Brollies

// pane of glass
#if (GlassPane)
	//union {  **** BLOB RAINDROPS COMMENTED OUT
		box { <0, 0, 0>, <1, 1, 0.01>
			texture {
				pigment { rgbt <1,1,1, 1> }
				normal { gradient x 0.001
					sine_wave
					turbulence 0.5
					scale 0.015
				}
			}
			interior { ior 1.5 }
		/*  **** BLOB RAINDROPS COMMENTED OUT
		}
		difference {
			blob { threshold 0.5
				#local i = 0;
				#while (i < NumDrops)
					#local x0 = rand(Seed1);
					#local y0 = rand(Seed1);
					#local r0 = 0.005 + rand(Seed1)*0.01;
					sphere { <x0, y0, 0.01+r0/4>, r0, 1}
					sphere { <x0, y0+r0/2, 0.01+r0/8>, r0/2, 1}
					#local i = i + 1;
				#end
			}
			box { <0, 0, 0>, <1, 1, 0.01> }
			#if (WaterDrops)
				texture {
					pigment { rgbt <0.98,1,1,0.95> }
					normal { ripples 0.1
						scale 0.01
					}
				}
				interior { ior 1.33 }
			#else
				texture {
					pigment { rgb <1,0,0> }
				}
			#end
			scale <1, 1, 0.2>
		}
		*/

		// translate in front of camera
		rotate <0,45,0>
		translate <-10.3,9.3,-24.15>
	}
#end

// rain plane
#if (Rain)
	plane { z, 0
		hollow
		texture {
			pigment { bozo
				colour_map {
					[0.0 rgbt <1,1,1,1> ]
					[0.9 rgbt <1,1,1,1> ]
					[0.95 rgb <0.7,0.7,0.7> ]
					[1.0 rgb <0.7,0.7,0.7> ]
				}
			}
			finish { ambient 0.3 }
			scale <0.001,0.1,1>
			rotate <0,0,-10>
		}

		// translate in front of camera
		rotate <0,18,0>
		translate <-10.3,9.3,-24.0>
	}
#end

/* OLD STUFF
// kerbs
intersection {
	plane { y, 0 }
	union {
		plane { x, -StreetWidth/2 }
		plane { -x, -StreetWidth/2 }
	}
	union {
		plane { z, -StreetWidth/2 }
		plane { -z, -StreetWidth/2 }
	}
	texture {
		pigment { rgb <0.8,0.8,0.8>
		}
	}
}

// roads
union {
	cylinder { <-1000, -RoadRadius, 0>, <1000, -RoadRadius, 0>, RoadRadius }
	cylinder { <0, -RoadRadius, -1000>, <0, -RoadRadius, 1000>, RoadRadius }
	texture {
		pigment { rgb <0.2,0.2,0.2> }
		normal { bozo 0.1
			scale 2
		}
		finish {
			reflection 0.3
		}
	}
}

// buildings
#include "building.inc"
#declare BuildingWidth = 20;
#declare BuildingHeight = 15;
#declare NumBuildings = 10;

#declare x0 = StreetWidth/2 + KerbWidth;
#declare z0 = x0;

Building(-x0,0,z0,-x0-BuildingWidth,BuildingHeight,z0+BuildingWidth)
#declare i = 0;
#while (i < NumBuildings)
	Building(x0,0,z0,x0+BuildingWidth,BuildingHeight+rand(Seed1)*15,z0+BuildingWidth)
	#declare z0 = z0 + BuildingWidth;
	#declare i = i + 1;
#end

// streetlights
#include "streetlight.inc"
#declare PoleKerb = 0.8;
#declare PoleSpacing = 16;
#declare NumPoles = 7;

#declare x0 = StreetWidth/2 + PoleKerb;
#declare z0 = x0 + 3;

StreetLight(x0,0,-z0, 180, NoLight)
StreetLight(-x0,0,-z0, 0, GreenLight)
#declare i = 0;
#while (i < NumPoles)
	#if (i = 0)
		StreetLight(x0,0,z0, 180, GreenLight)
		StreetLight(-x0,0,z0, 0, NoLight)
	#else
		StreetLight(x0,0,z0, 180, NoLight)
		StreetLight(-x0,0,z0, 0, NoLight)
	#end
	#declare z0 = z0 + PoleSpacing;
	#declare i = i + 1;
#end
*/
