/*

Synthetic Garden  
----------------
Designed by Eric van der Ree - Netherlands.
Finished in december 1999.
PovRay version 3.1

*/


                                       //  include files
                                       //  -------------
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"
#include "metals.inc"
#include "DO_Plants1.inc"

                                       //  (de)activate parts of the scene
                                       //  -------------------------------
#declare Show_SunLight      = 1
#declare Show_Fog           = 1
#declare Show_Sky           = 1
#declare Show_HfFgr         = 0
#declare Show_Walks         = 0
#declare Show_Walls         = 0
#declare Show_TreeLeft      = 0
#declare Show_BushTrees     = 0
#declare Show_Ferns         = 0
#declare Show_Flowers       = 0
#declare Show_Plants        = 0
#declare Show_Trees         = 1
#declare Show_Spruce        = 0
#declare Show_Grass         = 0
#declare Show_City          = 1 
#declare Show_Sun           = 1


                                       //  universal light
                                       //  ---------------
light_source
  { <-1500, 9000, 500> color White }



                                       //  sunlight
                                       //  --------
#if (Show_SunLight = 1)

#declare sun_color = color red 1.0 green 0.9 blue 0.8;

light_source {
   <500, 0, 300>
    color sun_color
             }
light_source {
    <500, 0, 0>
    color sun_color
             }
light_source {
   <-500, 0, 300>
    color sun_color
             }
light_source {
    <-500, 0, 0>
    color sun_color
             }

light_source {
   <200, 50, -450>
    color sun_color
             }

light_source {
   <-200, 50, -450>
    color sun_color
             }

#end


                                       //  universal fog
                                       //  -------------
#if (Show_Fog = 1)

fog {fog_type 2
     distance 400
     color LightGrey
     turbulence 0.2
     fog_offset 10
     fog_alt 1
     up <0, 1, 0>
    }

#end



                                       //  the sky
                                       //  -------
#if (Show_Sky = 1)

background { VioletRed }

#declare Sky = sphere {
  <0,0,0>,0.98
     texture { pigment { image_map { tga "Sky.tga" } } }
                        }
difference {
   sphere { <0,0,0>,1 }
     object {Sky}
     scale <3000,500,3000>
     texture { pigment { image_map { tga "Sky.tga" } } }
           }

#end



                                       //  area in the foreground
                                       //  ----------------------
#if (Show_HfFgr = 1)

height_field {
     gif "Ridge1.gif"
       scale <200,120,200>
       translate <180,-105,70>
       texture {
       pigment {  
           image_map {
           tga "greenmos.tga"
                     }
           turbulence 1.0
            }
               }
     smooth
  }

#end




                                       //  the walks in the garden
#if (Show_Walks = 1)                   //  -----------------------
                                       
#declare Box       = box { <0,0,0>, <2,1,1> }
                                         
#declare CountZ    = 0;
#declare CountMaxZ = 70;

#while (CountZ <= CountMaxZ)
                                                 
  #declare CountX    = 0;                
  #declare CountMaxX = 90;               

  #while (CountX <= CountMaxX)   

    #declare Tx  = 225   + (CountX * 2.2);
    #declare Ty  = -88.4; 
    #declare Tz  = 80    + (CountZ * 1.0);
    object { Box translate <Tx,Ty,Tz>
                 texture {T_Wood13 }

           } 
                 
    #declare CountX = CountX + 1;             

  #end          
  
  #declare CountZ = CountZ + 1;
  
#end     
      

#end


                     
                      
                                       //  the walls in the garden
#if (Show_Walls = 1)                   //  -----------------------
    
#declare Cyl      = cylinder { <0,0,0>, <0,7,0>, 0.5 }

#declare Count    = 0;                 //  the walls in the foreground
#declare CountMax = 40;               

#while (Count <= CountMax)   

  #declare Tx  = 245.8 + (Count * 0.6);
  #declare Ty  = -80.0 - (Count * 0.3);
  #declare TzI = 0.3;
  #if (Count < 7 )
      #declare TzI = 0.5;
  #end 
  #if (Count > 15)
      #declare TzI = 0.2;
  #end
  #declare Tz = 92  - (Count * TzI);
  object { Cyl translate <Tx,Ty,Tz>
               texture {T_Grnt19 }  }
  
  #if (Count > 7 & Count < 30)
    object { Cyl translate <Tx-25,Ty,Tz-4>
                 texture {T_Grnt19 }  }    
  #end                              
  object { Cyl translate <Tx+60,Ty-1,Tz+8>
               texture {T_Grnt19 }  }
                           
  #declare Count = Count + 1;             

#end                                 
    
#declare Count    = 0;                 // the walls in the background 
#declare CountMax = 40; 
                              
#while (Count <= CountMax)

  #declare Tx = 240 + (Count * 0.6);                               
  object { Cyl translate <Tx,-82,118>
               texture {T_Grnt19 }  }
               
  #declare Count = Count + 1;             
               
#end               

#declare Count    = 0;
#declare CountMax = 65; 
                              
#while (Count <= CountMax)

  #declare Tx = 310 - (Count * 0.7);
  #declare Tz = 105 + (Count * 0.2);                               
  object { Cyl translate <Tx,-82,Tz>
               texture {T_Grnt19 }  }
               
  #declare Count = Count + 1;             
               
#end               

#end

                       


                                       //  tree on the left in the foreground
#if (Show_TreeLeft = 1)                

#declare TreeX     = 227.5;            
#declare TreeY     = -60.9;
#declare TreeZ     = 45;  
#declare TreeSeed  = 1260;
#declare BaseLen   = 1;   
#declare LengthInc = 1.2;
#include "TreeDef.inc"
               
#end



                                       //  bushes/trees
                                       //  ------------
#if (Show_BushTrees = 1)

#declare col_12 = Black
#declare Sg    = 1

#declare Tseed = 1;
#declare R1    = seed(Tseed);
#declare TR    = 0.80;
#declare VR    = 0.40
#declare TG    = 0.40;
#declare VG    = 0.20
#declare TB    = 0.50;
#declare VB    = 0.10;
#include "BushTrees.inc"
#declare Bush01 = object { LBushTrees
         scale <0.020,0.020,0.020> }
object { Bush01                        //  number 1 (in the back, left, red/pink)
         translate <250,-95,210> }

#declare Tseed = 2;
#declare R1    = seed(Tseed);
#declare TR    = 0.80;
#declare VR    = 0.20
#declare TG    = 0.40;
#declare VG    = 0.10
#declare TB    = 0.50;
#declare VB    = 0.30;
#include "BushTrees.inc"
#declare Bush02 = object { LBushTrees
         scale <0.020,0.020,0.020> }
object { Bush02                        //  number 2 (right of number 1, pink)
         translate <270,-92,220> }

#declare Tseed = 3;
#declare R1    = seed(Tseed);
#declare TR    = 0.60;
#declare VR    = 0.15
#declare TG    = 0.80;
#declare VG    = 0.40
#declare TB    = 0.20;
#declare VB    = 0.05;
#include "BushTrees.inc"
#declare Bush03 = object { LBushTrees
         scale <0.020,0.020,0.020> }
object { Bush03                        //  number 3 (right of number 2, lightgreen)
         translate <290,-91,220> }

#declare Tseed = 4;
#declare R1    = seed(Tseed);
#declare TR    = 0.60;
#declare VR    = 0.15
#declare TG    = 0.80;
#declare VG    = 0.40
#declare TB    = 0.20;
#declare VB    = 0.05;
#include "BushTrees.inc"
#declare Bush04 = object { LBushTrees
         scale <0.020,0.020,0.020> }
object { Bush04                        //  number 4 (right of number 3, lightgreen)
         translate <325,-90,225> }

#declare Tseed = 5;
#declare R1    = seed(Tseed);
#declare TR    = 0.80;
#declare VR    = 0.40
#declare TG    = 0.40;
#declare VG    = 0.20
#declare TB    = 0.50;
#declare VB    = 0.10;
#include "BushTrees.inc"
#declare Bush05 = object { LBushTrees
         scale <0.020,0.020,0.020> }
object { Bush05                        //  number 5 (right of number 4, red/pink)
         translate <340,-80,230> }

#declare Tseed = 6;
#declare R1    = seed(Tseed);
#declare TR    = 0.60;
#declare VR    = 0.15
#declare TG    = 0.80;
#declare VG    = 0.40
#declare TB    = 0.20;
#declare VB    = 0.05;
#include "BushTrees.inc"
#declare Bush06 = object { LBushTrees
         scale <0.020,0.020,0.020> }
object { Bush06                        //  number 6 (right of number 5, lightgreen)
         translate <330,-80,150> }

#declare Tseed = 7;
#declare R1    = seed(Tseed);
#declare TR    = 0.80;
#declare VR    = 0.20
#declare TG    = 0.40;
#declare VG    = 0.10
#declare TB    = 0.50;
#declare VB    = 0.30;
#include "BushTrees.inc"
#declare Bush07 = object { LBushTrees
         scale <0.020,0.020,0.020> }
object { Bush07                        //  number 7 (most rightside, pink)
         translate <350,-80,120> }

#declare Tseed = 8;
#declare R1    = seed(Tseed);
#declare TR    = 0.80;
#declare VR    = 0.40
#declare TG    = 0.40;
#declare VG    = 0.20
#declare TB    = 0.50;
#declare VB    = 0.10;
#include "BushTrees.inc"
#declare Bush08 = object { LBushTrees
         scale <0.020,0.020,0.020> }
object { Bush08                        //  number 8 (in the front, behind number 9, red/pink)
         translate <275,-90,150> }

#declare Tseed = 9;
#declare R1    = seed(Tseed);
#declare TR    = 0.80;
#declare VR    = 0.20
#declare TG    = 0.40;
#declare VG    = 0.10
#declare TB    = 0.50;
#declare VB    = 0.30;
#include "BushTrees.inc"
#declare Bush09 = object { LBushTrees
         scale <0.020,0.020,0.020> }
object { Bush09                        //  number 9 (in the front, before number 8, pink)
         translate <280,-85,100> }

#end


                                       //  ferns 
                                       //  -----
#if (Show_Ferns = 1)

#declare col_4  = MediumForestGreen    
#declare col_12 = DarkGreen
#include "Ferns.inc"
#declare Fern01 = object { LFerns
         scale <0.0002,0.0002,0.0002> } 
     
object { Fern01                        //  number 1 (in the front, right of number 2)
         translate <278,-83,78>  }

object { Fern01                        //  number 2 (in the front, left of number 1)
         translate <257,-77,83>  }
   
object { Fern01                        //  number 3 (in the back, between number 4 and 5)
         translate <315,-79,106> }         

object { Fern01                        //  number 4 (in the back, left of number 3)
         translate <305,-80,116> }         
       
object { Fern01                        //  number 5 (in the back, right of number 3)
         translate <330,-79,104> }    
#end




                                       //  long flowers 
                                       //  ------------
#if (Show_Flowers = 1)
                                       
#declare col_2  = MediumForestGreen    
#declare col_3  = Plum
#declare col_4  = Yellow

#include "Flower.inc"
#declare Flower01 = object { LFlower
         scale <0.005,0.005,0.005> }
object { Flower01                      //  number  1 (Plum, foreground, left of number 2)
         translate <265,-97,75> }

object { Flower01                      //  number  2 (Plum, foreground, right of number 1)
         translate <295,-100,80> }
         
object { Flower01                      //  number  3 (Plum, foreground, between nummer 1 and 2)
         translate <275,-107,73> }
         
object { Flower01                      //  number 11 (Plum, background, between number 9 and 10)
         translate <255,-94,127> }
         
object { Flower01                      //  number 12 (Plum, background, between number 9 and 10)
         translate <254,-94,127> }
                  
object { Flower01                      //  number 16 (Plum, right background, left of number 14)
         translate <320,-96,102> } 
                           
#declare col_3 = Orange
#include "Flower.inc"
#declare Flower01 = object { LFlower
         scale <0.005,0.005,0.005> }
object { Flower01                      //  number  4 (Orange, foreground)
         translate <280,-98,74> }

object { Flower01                      //  number 10 (Orange, background, left of number 9)
         translate <253,-93,126> }
         
object { Flower01                      //  number 15 (Orange, right background, right of number 17)
         translate <328,-96,103> } 
         
#declare col_3 = Yellow
#include "Flower.inc"
#declare Flower01 = object { LFlower
         scale <0.005,0.005,0.005> }
object { Flower01                      //  number  5 (Yellow, foreground, right of number 6)
         translate <280,-95,70> }
         
object { Flower01                      //  number  6 (Yellow, foreground, left of number 5)
         translate <260,-100,73> } 
                                                
object { Flower01                      //  number 13 (Yellow, background, left of number 10)
         translate <250,-94,126> }      
         
#declare col_3 = OrangeRed
#include "Flower.inc"
#declare Flower01 = object { LFlower
         scale <0.005,0.005,0.005> }
object { Flower01                      //  number  7 (OrangeRed, foreground, right of number 8)
         translate <290,-105,75> }

object { Flower01                      //  number  8 (OrangeRed, foreground, left of number 7)
         translate <270,-100,74> }
                                                     
object { Flower01                      //  number  9 (OrangeRed, background, right of number 10)
         translate <257,-95,125> }
         
object { Flower01                      //  number 14 (OrangeRed, right background, left of number 17)
         translate <325,-96,105> }

object { Flower01                      //  number 17 (OrangeRed, right background, left of number 15)
         translate <327,-96,101> }
#end

                   
                   
                                       //  plants in pots in the foreground
#if (Show_Plants = 1)                                                       

#declare Plant = union {                 
                    object { DO_Pot2 }
                    object { DO_Plant5 
                             scale 1
                             translate y*.3 }
                       }     
object { Plant                         //  in the foreground
         scale 10  
         translate <258,-77,78> } 
         
object { Plant                         //  in the background
         scale 10  
         translate <302,-74,100> }
                           
                                            
#declare Plant = union {
                    object { DO_Pot2 }
                    object { DO_Plant1c 
                             scale .7
                             translate y*.26 }
                       }     
object { Plant                         //  in the foreground
         scale 10  
         translate <250,-75,88> }

         
#declare Plant = union {
                    object { DO_Pot2 }
                    object { DO_Plant3 
                             scale 1
                             translate y*.26 }
                       }     
object { Plant                         //  in the background
         scale 10  
         translate <306,-75,91> }
         
#end
                 
                 
                                       //  trees in the background
#if (Show_Trees = 1)                                                 

#include "veg.inc"
#declare Tree01 = object  { Tree
         scale <5,5,5> }
        
#declare CountX    = 210;
#declare CountMaxX = 731;
#declare CountZ    = 240;

#while (CountX <= CountMaxX)
  
  object { Tree01                      
           translate< CountX, -85, CountZ>
           no_shadow }
  
  #declare CountX = CountX + 20;
  #if (CountX > 410)
    #declare CountZ = CountZ + 10;
  #end
  
#end
                              
#end

 


                                       //  Spruce in the background
#if (Show_Spruce = 1)                                                 

#include "veg.inc"
#declare Spruce01 = object  { Spruce
         scale <5,5,5> }             
         
object { Spruce01                      //  most left side (on the right)
         translate< 344, -92, 186>}          
         
object { Spruce01                      
         translate< 354, -90, 190>}          
         
object { Spruce01                      
         translate< 368, -93, 188>}
                   
object { Spruce01                      
         translate< 373, -90, 175>} 
         
object { Spruce01                      
         translate< 380, -89, 167>}
         
object { Spruce01                   
         translate< 390, -95, 173>}
         
object { Spruce01                      
         translate< 397, -93, 171>}   
         
object { Spruce01                      
         translate< 400, -91, 172>}
                     
object { Spruce01                      
         translate< 408, -92, 175>} 
         
object { Spruce01                      //  most right side (on the right)
         translate< 416, -89, 174>}            


object { Spruce01                      //  most left side (on the left)
         translate< 285, -85, 290>}            

object { Spruce01                      
         translate< 297, -85, 292>} 
         
object { Spruce01                      
         translate< 307, -85, 288>}             

object { Spruce01                      
         translate< 316, -85, 285>} 
         
object { Spruce01                      //  most right side (on the left)   
         translate< 325, -85, 290>}                                     
         

object { Spruce01                      //  most left side (further away)
         translate< 405, -85, 350>}            

object { Spruce01                      
         translate< 430, -85, 352>} 
         
object { Spruce01                      
         translate< 385, -85, 349>}            

object { Spruce01                      
         translate< 397, -85, 355>} 
         
object { Spruce01                      
         translate< 407, -85, 356>}             
                      
object { Spruce01                      
         translate< 412, -85, 348>}            

object { Spruce01                      
         translate< 415, -85, 350>} 
         
object { Spruce01                      
         translate< 423, -85, 354>}             

object { Spruce01                      
         translate< 430, -85, 355>} 
         
object { Spruce01                        
         translate< 440, -85, 351>}                                     
        
object { Spruce01                         
         translate< 448, -85, 356>}                                               

object { Spruce01                      
         translate< 454, -85, 360>} 
         
object { Spruce01                      //  most right side (further away)   
         translate< 466, -85, 355>}                                              
         
#end                   




                                       //  grasses in the background
#if (Show_Grass = 1)                                                 

#include "veg.inc"
#declare Grass01 = object  { Grass
         scale <10,10,10> }
                                               
#declare CountZ    = 0;
#declare CountMaxZ = 100;

#while (CountZ <= CountMaxZ)
                                                 
  #declare CountX    = 0;                
  #declare CountMaxX = 110;           

  #while (CountX <= CountMaxX)   

    #declare Tx  = 250   + (CountX * 6.0);
    #declare Ty  = -88.4 + (CountZ * 0.1); 
    #declare Tz  = 190   + (CountZ * 6.0);
    object { Grass01 translate <Tx,Ty,Tz> }
                
    #declare CountX = CountX + 1;             

  #end          
  
  #declare CountZ = CountZ + 1;
  
#end  
         
#end         
 

                                       
                                       // a city in the background
#if (Show_City  = 1)
                               
#declare city_transform   = transform {translate <432, -64, 380>} 
#declare city_block_count = <10, 3, 0> 
#declare buildings_per_block = 1;
#declare building_gap = 25; 
#declare building_height_falloff = 2.5;
#include "EricCity.obj"
#include "city.inc"                               

#end



                                       //  the sun and camera
                                       //  ------------------
#if (Show_Sun = 1)

#declare effect_location   = <930,110, 900>;
#declare effect_scale      = 2.8;
#declare effect_intensity  = 0.4;
#declare effect_brightness = 0.4;
#declare effect_type       = "SUN3"
#declare camera_location   = <230, -53, 25>;
#declare camera_look_at    = <553, -53, 698>;
#declare camera_sky        = <0, 1, 0>;
#include "LENS.INC"

#end

                                       // the camera (separate, same as included in the sun)
                                       // --------------------------------------------------
camera {
   location <230, -53, 25>
   sky       <0, 1, 0>
   up        <0, 1, 0>
   right     <1, 0, 0>
   look_at   <553, -53, 698>
}

