// ***** Plante de l'Arche *****

#debug "\nCreation de la Plante de l'arche ......\n"

#declare Feuille_Arche =
difference{
   cylinder{<0,0,0>,<0,0,0.5>0.5 translate <0.5,0,-0.25> scale <1,1.5,1>}
   union{
      cylinder{<0,0,-1>,<0,0,1>0.49 translate <0.5,0,0> scale <1,1.5,1>}
      box{<-0.51,-1,-0.51>,<0.51,0,00.51> translate <0.5,0,0>}
      box{<1,0.51,0.51>,<-0.51,0,-0.51> rotate 15*z translate <0.6,-0.37,0>}
      box{<-0.51,0,0>,<0.51,1.5,0.51> rotate 20*y translate <0.5,0,0.2>}
      box{<0,0,0>,<1,1.5,0.51> rotate -20*y translate <0.5,0,-0.75>}
        }
   texture{Tex_Feuille_Arche}
          }

#declare Plante_Arche=
union{
   #declare Angle=0;
   #declare Compteur=0;
   #while (Compteur < 6)
      object{Feuille_Arche rotate Angle*y  scale 2}
      object{Feuille_Arche rotate (Angle + 30)*y scale 1.5}
   #declare Compteur = Compteur + 1;
   #declare Angle = Angle + 60;
   #end
   scale 20
     }


// ***** Plante de l'Allee *****

#debug "\nCreation de la Plante de l'allee ......\n"

#declare Feuille_Droite_Allee =
difference{
   sphere {<0,0,0> 1 scale <1.25,1,0.5>}
   union{
      box{<-2,-2,0.02>,<2,2,2>}
      box{<-2,-2,-2>,<2,-0.02,2>}
      box{<-2,0.02,-2>,<2,2,2>}
        }
          }
#declare Feuille_Gauche_Allee =
difference{
   sphere {<0,0,0> 1 scale <1.25,1,0.5>}
   union{
      box{<-2,-2,-0.02>,<2,2,-2>}
      box{<-2,-2,-2>,<2,-0.02,2>}
      box{<-2,0.02,-2>,<2,2,2>}
        }
          }

#declare Feuille_Allee =
union{
   object{Feuille_Droite_Allee  rotate -5*x}
   object{Feuille_Gauche_Allee rotate 5*x}
   texture{Tex_Feuille_Allee}
     }

#declare Un_Allee =
union{
   object{Feuille_Allee}
   cylinder{<-2.5,0,0>,<-1,0,0>0.05 texture{Tex_Tige_Allee}}
   translate <2.5,0,0>
     }

#declare Ombelle_Allee =
union{
   object{Un_Allee}
   object{Un_Allee rotate -30*y}
   object{Un_Allee rotate -60*y}
   object{Un_Allee rotate -90*y}
   object{Un_Allee rotate -120*y}
     }



#declare Plante_Allee =
   union{
      cone{<0,0,0>,0.175<0,25.2,0>0.1 texture{Tex_Branche_Allee}}
      object{Ombelle_Allee  rotate<-20,  0, 10> scale 1.5 translate <0, 0.0,0>}
      object{Ombelle_Allee  rotate<-20, 42,-11> scale 1.5 translate <0, 3.2,0>}
      object{Ombelle_Allee  rotate<-20,129, 12> scale 1.5 translate <0, 5.8,0>}
      object{Ombelle_Allee  rotate<-22,206, 12> scale 1.4 translate <0, 7.1,0>}
      object{Ombelle_Allee  rotate<-22,310,-12> scale 1.4 translate <0, 8.2,0>}
      object{Ombelle_Allee  rotate<-22, 31,-10> scale 1.3 translate <0, 9.2,0>}
      object{Ombelle_Allee  rotate<-25, 50, 11> scale 1.3 translate <0,10.5,0>}
      object{Ombelle_Allee  rotate<-25, 98, 10> scale 1.2 translate <0,11.3,0>}
      object{Ombelle_Allee  rotate<-25,200,-10> scale 1.1 translate <0,12.5,0>}
      object{Ombelle_Allee  rotate<-28 300,-12> scale 1.1 translate <0,13.8,0>}
      object{Ombelle_Allee  rotate<-28,  9, 10> scale 1.0 translate <0,14.7,0>}
      object{Ombelle_Allee  rotate<-30,215,-11> scale 1.0 translate <0,15.8,0>}
      object{Ombelle_Allee  rotate<-32,110, 11> scale 0.8 translate <0,16.7,0>}
      object{Ombelle_Allee  rotate<-34, 61, 12> scale 0.7 translate <0,18.4,0>}
      object{Ombelle_Allee  rotate<-38,150,-11> scale 0.7 translate <0,19.0,0>}
      object{Ombelle_Allee  rotate<-40, 98, 12> scale 0.6 translate <0,19.8,0>}
      object{Ombelle_Allee  rotate<-32,210, 11> scale 0.6 translate <0,21.2,0>}
      object{Ombelle_Allee  rotate<-34,361,-10> scale 0.5 translate <0,22.2,0>}
      object{Ombelle_Allee  rotate<-38,  0,-11> scale 0.5 translate <0,23.0,0>}
      object{Ombelle_Allee  rotate<-38,180, 11> scale 0.4 translate <0,23.8,0>}
      object{Ombelle_Allee  rotate<-38,300,-10> scale 0.3 translate <0,24.5,0>}
      object{Ombelle_Allee  rotate<-40, 60,-11> scale 0.2 translate <0,25.2,0>}
      
   scale <8,4,8>
        }



// ***** Plante de devant *****

#debug "\nCreation de la Plante de devant .......\n"

#declare Feuille_Droite_Devant =
difference{
   sphere{<0,0,0> 1 scale <1.25,1,0.15>}
   union{
      box{<-2,-2,0.02>,<2,2,2>}
      box{<-2,-2,-2>,<2,-0.02,2>}
      box{<-2,0.02,-2>,<2,2,2>}
        }
          }

#declare Feuille_Gauche_Devant =
difference{
   sphere {<0,0,0> 1 scale <1.25,1,0.15>}
   union{
      box{<-2,-2,-0.02>,<2,2,-2>}
      box{<-2,-2,-2>,<2,-0.02,2>}
      box{<-2,0.02,-2>,<2,2,2>}
       }
           }

#declare Feuille_Devant =
union{
   object{Feuille_Droite_Devant translate<1.25,0,0>}
   object{Feuille_Gauche_Devant translate<1.25,0,0>}
   texture{Tex_Feuille_Devant}
     }

#declare Branche_Devant =
union{
   cone{<0,0,0>,0.1 <0,3,0>,0.08 texture{Tex_Tige_Devant}}
   #declare Compteur = 0;
   #while (Compteur < 341)
      object{Feuille_Devant rotate 30*z rotate   Compteur*y translate <0,3,0>}
   #declare Compteur = Compteur + 20;
   #end
     }

#declare Plante_Devant =
union{
object{Branche_Devant scale 15                          translate<  0,0, 0>}
object{Branche_Devant scale 13 rotate -25*z rotate 35*y translate<  8,0, 18>}
object{Branche_Devant scale 12 rotate  25*z rotate 255*y translate<  12,0, -4>}
object{Branche_Devant scale 11 rotate -20*x rotate 20*z translate<  -10,0,-5>}
object{Branche_Devant scale 10 rotate  10*x rotate 25*z translate<  -12,0,7>}
}



// ***** Plante de l'Escalier *****

#debug "\nCreation de la Plante de l'escalier ...\n"

#declare Feuille_Escalier =
difference {
   cylinder { <-0.5,0,0>, <0.5,0,0>, 1 translate <0,-0.5,0>}
   union{
   cylinder { <-0.5,0,0>, <0.5,0,0>, 0.98 translate <0,-0.5,0>}
   box{<-1.5,-1.5,-1.5>,<0,1.5,1.5> rotate 25*z rotate 15*x}
   box{<0,-1.5,-1.5>,<1.5,1.5,1.5> rotate -25*z rotate 15*x}
       }
 translate <-0.025,-0.35,0.515>
}

#declare Tige_Escalier=
union{
object{Feuille_Escalier rotate 90*y rotate 45*z scale 1.5 translate <0,3,0> texture{Tex_Feuille_Escalier}}
cone { <0,0,0>,0.035 <0,3,0>, 0.025 texture{Tex_Tige_Escalier}}
scale 20}

#declare Plante_Escalier =
union{
   object{Tige_Escalier scale 1.422 rotate - 9.896*z rotate    0*y translate  24.722*x translate  68.163*z}
   object{Tige_Escalier scale 1.666 rotate -15.044*z rotate - 60*y translate   4.518*x translate  58.759*z}
   object{Tige_Escalier scale 1.976 rotate - 3.411*z rotate -120*y translate  22.933*x translate  48.636*z}
   object{Tige_Escalier scale 1.365 rotate -17.135*z rotate -200*y translate -10.975*x translate   8.848*z}
   object{Tige_Escalier scale 1.938 rotate -19.239*z rotate -300*y translate  28.604*x translate  14.667*z}
   object{Tige_Escalier scale 1.298 rotate -11.831*z rotate -140*y translate - 8.793*x translate  46.426*z}
   object{Tige_Escalier scale 1.719 rotate - 7.362*z rotate -200*y translate  3.0975*x translate   2.273*z}
   object{Tige_Escalier scale 1.097 rotate - 3.565*z rotate -235*y translate -25.901*x translate   0.408*z}
   object{Tige_Escalier scale 1.626 rotate -20.641*z rotate -125*y translate   2.162*x translate  57.452*z}
   object{Tige_Escalier scale 1.529 rotate -24.913*z rotate - 75*y translate  29.249*x translate  45.411*z}
   object{Tige_Escalier scale 1.500 rotate -10.817*z rotate -305*y translate   0.555*x translate - 9.298*z}
   object{Tige_Escalier scale 1.337 rotate -26.124*z rotate -220*y translate -10.571*x translate   0.240*z}
   object{Tige_Escalier scale 1.181 rotate - 6.429*z rotate -250*y translate   4.101*x translate - 5.147*z}
   object{Tige_Escalier scale 1.542 rotate -26.124*z rotate -300*y translate  8.9131*x translate - 8.473*z}
   object{Tige_Escalier scale 1.312 rotate -10.254*z rotate -250*y translate -30.127*x translate -45.147*z}
   object{Tige_Escalier scale 1.106 rotate -12.264*z rotate -260*y translate - 8.251*x translate -32.473*z}
   object{Tige_Escalier scale 1.999 rotate - 7.157*z rotate - 20*y translate  20.214*x translate  66.274*z}
scale 0.6
     }


 
 
// ***** Plante du Haut *****

#debug "\nCreation de la Plante du Haut .........\n"

#declare Feuille_Haut =
difference{
   sphere{<0,0,0>,1 scale <3,1.8,2>}
      union{
         sphere{<0,0,0>,0.98 scale <3,1.8,2>}
	 plane { y, 0.5 }
	 plane { z, -0.2 rotate 20*y inverse}
	 plane { z, -0.2 rotate -20*y }
	   }
      rotate -52* z
      scale <1.5,1.8,1>
      texture {Tex_Feuille_Haut}
      	   }
	  	
#declare Tige_Haut =
union{
   cone{<0,0,0>,0.15,<0,5,0>,0.075 texture {Tex_Tige_Haut}}  
   difference{
      torus{1,0.075}
      plane{x,0} 
      plane{z,0 inverse translate -0.5*x} 
      rotate 90*z rotate 90*y translate <1,3.3,0> scale<1,1.5,1>
             } 
   texture {Tex_Tige_Haut}
     }
 
 
#declare P_Haut =
union{
   object{Feuille_Haut translate <3,1.9,0>}
   object{Tige_Haut}
     }
    


#declare Plante_Haut =
union{
   object { P_Haut scale  10 rotate -5*z rotate   0*y pigment{color<1,0,0>}}
   object { P_Haut scale   8 rotate -2*z rotate  75*y pigment{color<1,1,0>}}
   object { P_Haut scale   9 rotate -3*z rotate 140*y pigment{color<1,1,1>}}
   object { P_Haut scale   6 rotate -8*z rotate 220*y pigment{color<1,1,0>}}
   object { P_Haut scale   5 rotate -6*z rotate 340*y pigment{color<1,1,1>}}
   object { P_Haut scale   8 rotate -6*z rotate  20*y translate  20*x translate -10*z pigment{color<1,0,0>}}
   object { P_Haut scale   7 rotate -4*z rotate 150*y translate  20*x translate -10*z pigment{color<1,1,0>}}
   object { P_Haut scale   6 rotate -8*z rotate 290*y translate  20*x translate -10*z pigment{color<1,1,1>}}
   object { P_Haut scale  12 rotate -6*z rotate  50*y translate -10*x translate  20*z pigment{color<1,0,0>}}
   object { P_Haut scale  10 rotate -4*z rotate 140*y translate -10*x translate  20*z pigment{color<1,1,0>}}
   object { P_Haut scale   9 rotate -8*z rotate 250*y translate -10*x translate  20*z pigment{color<1,1,1>}}
   object { P_Haut scale  11 rotate -8*z rotate 300*y translate -10*x translate  20*z pigment{color<1,1,1>}}
     }
    
    
    

// ***** Plante de la Tour *****

#debug "\nCreation de la Plante de la Tour ......\n"

#declare Tige_Tour=
difference{
   torus{1 0.02 rotate 90*z rotate 90*y scale <1.5,2.5,1>}
   union{
      box{<-2.1,-5,-2><2.1,0,2.1>}
      box{< 0.75,-2.1,-2><2.1,2.1,2.1>}
        }
texture{Tex_Tige_Tour}
          }
          
#declare Feuille_Tour=
intersection{
   difference{
      sphere{<0,0,0>,1 scale <1.5,2.55,3.75>}
      union{
         sphere{<0,0,0>,0.98 scale <1.5,2.55,3.75>}
         box{<-5,-5,-5><5,2.0,5> rotate 10*z}
           }
             }
   cylinder{<0,1,0>,<0,3,0>,0.9 scale<1,1,0.6>}
texture{Tex_Feuille_Tour}
            }
            
            
#declare P_Tour=
union{
   object{Tige_Tour translate 1.5*x}
   object{Feuille_Tour translate 1.5*x}
               }

#declare Plante_Tour=
union{                                         
   object{P_Tour scale 12  rotate 30*x rotate 160*y}
   object{P_Tour scale 15  rotate 28*x rotate  10*y}
   object{P_Tour scale 22  rotate 22*x rotate 200*y}
   object{P_Tour scale 25  rotate 20*x rotate  90*y}
   object{P_Tour scale 30  rotate 12*x rotate 250*y}
   object{P_Tour scale 35  rotate 15*x rotate  60*y}
   object{P_Tour scale 38  rotate  6*x rotate 150*y}
   object{P_Tour scale 40  rotate  5*x rotate   0*y}
     }
