#include "G2_Textures.inc"

//These variables determine which parts of the
//scene are used
#declare Shrooms = true;
#declare Trees = true;
#declare Ground = true;
#declare MiniMushes = true;

//Area lights, a height field for the ground,
//anything that increases quality or render time
//is enabled by this variable
#declare Trimmings = true;

#declare AREA_LIGHT_DIM = 3; //dimension of the area light

//Constants for the camera to be used.
#declare STD_POS = 0;
#declare OVERHEAD = 1;
#declare SIDE = 2;

//determines which camera to use
#declare CameraType = STD_POS;

//Number of miniature mushrooms to include
//WARNING: parse time increases very fast
//as this increases. Drop it to 20 for tests,
//100-150 (1-2mins) for major renders.
#declare Minimush_density = 165;

global_settings { 
 ambient_light 0.4
 radiosity { //Radiosty settings. Ugh, I'm not going to try and comment them
  brightness 3.8
  count 1
  error_bound 1
  gray_threshold 0.0
  low_error_factor 0.5
  minimum_reuse 0.015
  nearest_count 5
  recursion_limit 4
  max_sample 2 //MegaPOV option
 }
}

background { rgb <0.05, 0.15, 0.05> } //greenish BG, like foliage

fog //A minor ground fog
{
 fog_type 2
 distance 1
 color rgb 0.5
 transmit 0.4
 fog_offset 0.3
 fog_alt 0.35
 turbulence 0.8
}

//these are to enhance the radiosity
plane { -x, 0
 pigment { gradient z
  color_map {
   [0/7 rgb<1, 0, 0>]
   [1/7 rgb<1, 0.5, 0>]
   [2/7 rgb<1, 1, 0>]
   [3/7 rgb<0, 1, 0>]
   [4/7 rgb<0, 0, 1>]
   [5/7 rgb<0.5, 0, 1>]
   [6/7 rgb<1, 0, 1>]
   [7/7 rgb<1, 0, 0>]
  }
  scale 7
 }
 finish { diffuse 0.15 ambient 0.075 }
 translate <9, 0, 0>
}

plane { -y, 0
 pigment { radial
  color_map {
   [0/7 rgb<1, 0, 0>]
   [1/7 rgb<1, 0.5, 0>]
   [2/7 rgb<1, 1, 0>]
   [3/7 rgb<0, 1, 0>]
   [4/7 rgb<0, 0, 1>]
   [5/7 rgb<0.5, 0, 1>]
   [6/7 rgb<1, 0, 1>]
   [7/7 rgb<1, 0, 0>]
  }
  scale 7
 }
 finish { diffuse 0.15 ambient 0.075 }
 translate <4.5, 15, 4.7>
}