//...................................................................................

#macro Get_normal_vector_in_xy_plane(v1, vn1)    
// This macro takes a vector and returns the vector that is perpendicular to 
//      it in the xy plane; this vector is not normalized.
//      it is assumed that v1 and vn1 have their base at the origin.
// v1 is the input vector
// vn1 is the outpur vector
// vn1 is perpendicular to v1 and is located in the xy plane
// the vector passed through the 2nd parameter (vn1) must be declared 
//     before calling the macro; it can be given any name.
 #if (v1.x != 0 | v1.y != 0 | v1.z != 0)    

  #if (v1.x=0 & v1.y=0) 
    #declare vn1=<0,1,0>; // any vector in the xy plane would do
  #else
    #declare vn1=<-v1.y, v1.x, 0>;
  #end
 #end 
#end     

//...................................................................................

#macro Get_vector_at_angle_alfa(v1, alfa, valfa) 
// This macro rotates the vector v1 by an angle alfa and returns the resulting vector
// in valfa. v1 and valfa have their base at the origin.
// valfa lies in the (v1,y) plane if v1 is not on the y-axis; 
// if v1 is on the y axis, valfa is in the (y,z) plane.
// valfa is not normalized.              
// A left-handed coord. system is assumed.
  #if (v1.x=0 & v1.z=0)
    #local v2=vcross(v1,z); 
    #declare valfa = vaxis_rotate(v1,v2,alfa);
  #else
    #local v2=vcross(v1,y); 
    #declare valfa = vaxis_rotate(v1,v2,alfa);
  #end
#end









