// ----------------------------------------    
#declare r1 = seed(565);//   
#declare r2 = seed(98);  
#declare len1 = 1;
#declare leaf1 = union
{
  cylinder {<0,0,0> <0,len1,0> 1
            scale <0.05,.5,0.025>     
           }
  sphere {<0,0,0> 1
          scale <0.5,1,0.1>  
          translate <0,len1+0.5,0>
         } 
  pigment { rgb < 0.549, 0.6745, 0.4667>*(0.8+rand(r1)*.4) }
  scale.5
}   

#declare leaf = union
{
  object {leaf1 rotate z*30 rotate x*30}
  object {leaf1 rotate z*-30}
  object {leaf1 rotate z*30}
}              

#declare leaf=mesh
{           
  #declare stem_len=0.05;
  #declare leaf_half_wi=.75*0.85;  
  #declare leaf_len=1.6*0.85;

  #declare vt1 = <-0.025,0,0>;
  #declare vt2 = <0.025,0,0>;
  #declare vt3 = <-0.025,stem_len,0>;
  #declare vt4 = <0.025,stem_len,0>;  
  
  #declare vt5 = <-leaf_half_wi, stem_len+leaf_len/3, 0>;
  #declare vt6 = <leaf_half_wi, stem_len+leaf_len/3, 0>;
  #declare vt7 = <0.,stem_len+leaf_len,0>;   
  
  #declare vt8 = <-leaf_half_wi*.85, stem_len+leaf_len/3*2, 0>;
  #declare vt9 = <leaf_half_wi*.85, stem_len+leaf_len/3*2, 0>;
  #declare vt10 = <0, stem_len+leaf_len/6, 0>;
  
  #declare vt11 = <-leaf_half_wi*.45, stem_len+leaf_len/3*2, 0>;
  #declare vt12 = <leaf_half_wi*.45, stem_len+leaf_len/3*2, 0>;
  
  triangle {vt1 vt2 vt3}
  triangle {vt2 vt4 vt3}    
  triangle {vt5 vt6 vt4}  
  triangle {vt8 vt9 vt10}  
  triangle {vt11 vt12 vt7}

  #declare vt1 = vaxis_rotate(<-0.025,0,0>,x,30);
  #declare vt2 = vaxis_rotate(<0.025,0,0>,x,30);
  #declare vt3 = vaxis_rotate(<-0.025,stem_len,0>,x,30);
  #declare vt4 = vaxis_rotate(<0.025,stem_len,0>,x,30);  
  
  #declare vt5 = vaxis_rotate(<-leaf_half_wi, stem_len+leaf_len/3, 0>,x,30);
  #declare vt6 = vaxis_rotate(<leaf_half_wi, stem_len+leaf_len/3, 0>,x,30);
  #declare vt7 = vaxis_rotate(<0.,stem_len+leaf_len,0>,x,30);   
  
  #declare vt8 = vaxis_rotate(<-leaf_half_wi*.85, stem_len+leaf_len/3*2, 0>,x,30);
  #declare vt9 = vaxis_rotate(<leaf_half_wi*.85, stem_len+leaf_len/3*2, 0>,x,30);
  #declare vt10 = vaxis_rotate(<0, stem_len+leaf_len/6, 0>,x,30);
  
  #declare vt11 = vaxis_rotate(<-leaf_half_wi*.45, stem_len+leaf_len/3*2, 0>,x,30);
  #declare vt12 = vaxis_rotate(<leaf_half_wi*.45, stem_len+leaf_len/3*2, 0>,x,30);
  triangle {vt1 vt2 vt3}
  triangle {vt2 vt4 vt3}    
  triangle {vt5 vt6 vt4}  
  triangle {vt8 vt9 vt10}  
  triangle {vt11 vt12 vt7}
  
  #declare vt1 = vaxis_rotate(<-0.025,0,0>,z,30);
  #declare vt2 = vaxis_rotate(<0.025,0,0>,z,30);
  #declare vt3 = vaxis_rotate(<-0.025,stem_len,0>,z,30);
  #declare vt4 = vaxis_rotate(<0.025,stem_len,0>,z,30);  
  
  #declare vt5 = vaxis_rotate(<-leaf_half_wi, stem_len+leaf_len/3, 0>,z,30);
  #declare vt6 = vaxis_rotate(<leaf_half_wi, stem_len+leaf_len/3, 0>,z,30);
  #declare vt7 = vaxis_rotate(<0.,stem_len+leaf_len,0>,z,30);   
  
  #declare vt8 = vaxis_rotate(<-leaf_half_wi*.85, stem_len+leaf_len/3*2, 0>,z,30);
  #declare vt9 = vaxis_rotate(<leaf_half_wi*.85, stem_len+leaf_len/3*2, 0>,z,30);
  #declare vt10 = vaxis_rotate(<0, stem_len+leaf_len/6, 0>,z,30);
  
  #declare vt11 = vaxis_rotate(<-leaf_half_wi*.45, stem_len+leaf_len/3*2, 0>,z,30);
  #declare vt12 = vaxis_rotate(<leaf_half_wi*.45, stem_len+leaf_len/3*2, 0>,z,30);
  triangle {vt1 vt2 vt3}
  triangle {vt2 vt4 vt3}    
  triangle {vt5 vt6 vt4}  
  triangle {vt8 vt9 vt10}  
  triangle {vt11 vt12 vt7}
}


#macro place_leaf(v1, vtrans, gama)
  #declare alfa = degrees(atan2(v1.z,v1.x));     
  #declare v1x = sqrt(v1.x*v1.x+v1.z*v1.z);
  #declare beta = degrees(atan2(v1x,v1.y)); 
  #declare r3=rand(r2); 

  object {leaf      
          rotate y*gama
          rotate z*-beta
          rotate y*-alfa 
          translate vtrans    
          #switch (r3)  
            #range (0,0.5)
              pigment {rgb< 0.549, 0.8745, 0.6667>*(0.7+0.6*rand(r2))*0.6}   
            #break
            #range (0.5,1)
              pigment { rgb <0.7, 0.9, 0.5>*(0.7+0.6*rand(r2))*0.6}
            #break
          #end
         }
#end  




#macro place_leaf1(v0, vtrans, gama)   
  #local v4 = vaxis_rotate(vnormalize(<-v0.y, v0.x, 0.000>), v0, gama);
  #local v2 = vaxis_rotate(vnormalize(<-v0.y, v0.x, 0.000>), v0, gama);
  #local v3 = vaxis_rotate(v2, v0, 90);    
  #local v1 = vaxis_rotate(v4, v3, 15-rand(r1)*30);
  #local alfa = degrees(atan2(v1.z,v1.x));     
  #local v1x = sqrt(v1.x*v1.x+v1.z*v1.z);
  #local beta = degrees(atan2(v1x,v1.y));  

  object {leaf      
          rotate z*-beta
          rotate y*-alfa 
          translate vtrans
         }                          
#end  


//:::::::::::::::::::::::::::::::::::::::::

//sphere {<-8,40,0> 0.5 pigment {color Red}}       
//sphere {<-8,0,0> 0.5 pigment {color Red}}       
//sphere {<-8,-12,0> 0.5 pigment {color Red}}       
       
#declare twig_tex = texture
{
  pigment {color rgb < 0.55, 0.44, 0.37>}   
}





//=========================================================================
#macro twig(vc0, vc1, circumf, th, sinuosity, leng, blevel, leaf_scaling)
                                    
                                    
   cylinder {vc0, vc1, circumf*th}  
   
   #local leaf_scaling1=1;  
   #local v1=vc1 - vc0;    
   //#local ra=rot_angle;  
      
      #switch (blevel)
        #case (0)  
          #local b_min_angle = 70;
          #local b_max_angle = 72;
          #local leng1=leng*0.998;  
          #local rd1 = circumf*0.97; 
          #local min_circ = 0.34;   
          #local sinuos = 2;
          #local init_angle = rand(r1)*360;   
          #local th1=th;         
        #break
        
        
        #range (1,2)     
          #local th1=2;
          #local b_min_angle = 30;
          #local b_max_angle = 35;
          #local leng1=leng*0.97;  
          #local rd1 = circumf*0.95; 
          #if (blevel=1)
            #local min_circ = 0.020;// + rand(r1)*0.055;   
          #else
            #local min_circ = 0.010;  
          #end
          #local sinuos = 5; 
          
        #if (blevel=2)
          #local leaf_scaling1=leaf_scaling;//*0.935*(1+0.1*rand(r1)); 
          #local dv=0.3*vnormalize(v1);  
          #local ldv = vlength(dv); 
          #local lv1 = vlength(v1);
          #local i=1;    
          #while (i*ldv < lv1)
            place_leaf(i*dv, vc1+i*dv, rand(r1)*360)       
            #local i=i+1;
        #end    
          #end   
        #break     
        
      #end    
    
    
   #local rc = vlength(v1)*tan(radians(sinuosity));
   #local v2 = vnormalize(<-v1.y, v1.x, 0.1>)*rc*(rand(r1));
   #local v3 = vnormalize(vaxis_rotate(v2+v1,v1,rand(r1)*360))*leng;
    
    
   #if (rd1>min_circ & blevel < 3)  
      #local vc2 = v3+vc1;      
      twig(vc1, vc2, rd1, th1, sinuos, leng1, blevel, leaf_scaling1)
           
      #if (b_min_angle = 90) b_min_angle=89;  #end  
      #if (b_max_angle = 90) b_max_angle=91;  #end  

       
      #switch (blevel)
        #case (0)  
          #local rd2 = rd1*0.75;             
          #if (vc1.y > -10 & rand(r1) < 0.30)   
             #local new_branch=1;
          #else
             #local new_branch=0;
          #end
          #local initial_length = rd1*0.7+.5; 
        #break
        
        #case (1)   
          #local rd2 = rd1*0.9;
          #if (rand(r1)<0.30) 
           #local new_branch=1; 
          #else
           #local new_branch = 0;
          #end
          #local initial_length = rd1*.7+.5;  
        #break 
        
        #case (2)   
          #local rd2 = rd1*0.30+0.02;
          #if (rand(r1)<0.40) 
           #local new_branch=1; 
          #else
           #local new_branch = 0;
          #end
          #local initial_length = rd1*3+2;  
       #break 

        #else
          #local new_branch = 0;
      #end 
       
       #if (new_branch)
        #local blevel1=blevel+1;   
        #local rc2 = vlength(v1)*tan(radians(b_max_angle-90)); 
        #local cc = (b_min_angle-90)/(b_max_angle-90);  
        #local bb = 1 / (1 - cc);  
        #local aa = cc*bb;
        #local v4 = vnormalize(<-v1.y, v1.x, 0.01>);  
        #local v6 = vnormalize(<-v4.y, v4.x, 0.01>)*rc2*((rand(r1)+aa)/bb);  
        #local v5 = (v6+v4); 
        
        #local alfa2 = rand(r1)*360; 
        #local init_angle = -alfa2;
        #local v8 = vnormalize(vaxis_rotate(v5,v1,alfa2))*initial_length + vc1 ;        
        twig(vc1, v8, rd2, th1, sinuos, initial_length, blevel1, leaf_scaling)     
       //#else 
        #if (blevel=2)
         #local rseed1 = seed(vc1.x*100); 
         #local rota=rand(rseed1)*360;
         place_leaf(v8-vc1, v8,rota)     
        #end
       #end    
   #end     
#end


//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
                             
#declare vq1=<0, -12, 0>;
#declare vq2=<0, -4, 0>;
#declare tree = union
{
twig(vq1, vq2, 1, 2, 8, 1.5, 0, 1)
}
    
object
{
   tree        
   texture {twig_tex}   
   rotate y*-90
   scale .42/3.3 
   scale <1,1.10,1>
   translate <-12,-.5,16>    
}    
           

                                                       
                                                       
                                                       
                                                       
                                                       
                                                       
                                                       
                                                       
                                                       
                                                       
                                                       
                                                       