#declare holes_on=on;     
#declare big_holes=on;
#declare table = union
{

  #declare dist=0;
  #declare tr=.5;
  #declare tht=0.8;
  #declare small_radius=0.008;
  
  // table top
  #declare wd=0.2;
  #declare dp=0.2;
  #declare ht=0.5;   


                  
        
#if (big_holes)            
  #declare ds=0.04; 
  #declare dw=2*(wd-small_radius-ds);
  #declare cube_w=0.025;
  #declare cw=cube_w*1.4142;
  #declare gap=(dw-5*2*cw)/4;
#else
  #declare ds=0.01; 
  #declare dw=2*(wd-small_radius-ds);
  #declare cube_w=0.012;
  #declare cw=cube_w*1.4142;
  #declare gap=(dw-15*2*cw)/14;
#end                          


#declare my_cube = box {<-cube_w/2,-0.1,-cube_w/2>,<cube_w/2,0.1,cube_w/2> rotate y*45}
#declare tr1=tr-0.02;

#if (holes_on)
#declare holes = union
{
  #declare dx=0;
  #while (dx < tr1)  
    #declare dy=0;
    #while (dy < sqrt(tr1*tr1-dx*dx))
       object {my_cube translate <dx,0,dy>} 
       object {my_cube translate <-dx,0,dy>} 
       object {my_cube translate <dx,0,-dy>} 
       object {my_cube translate <-dx,0,-dy>} 
       #declare dy=dy+cw*2+gap;  
    #end  
    #declare dx=dx+cw*2+gap;
  #end

  #declare dx=gap/2+cw;
  #while (dx < tr1)  
    #declare dy=gap/2+cw;
    #while (dy < sqrt(tr1*tr1-dx*dx))
       object {my_cube translate <dx,0,dy>} 
       object {my_cube translate <-dx,0,dy>} 
       object {my_cube translate <dx,0,-dy>} 
       object {my_cube translate <-dx,0,-dy>} 
       #declare dy=dy+cw*2+gap;  
    #end  
    #declare dx=dx+cw*2+gap;
  #end
}   
#end
         


  difference
  {
    cylinder {<0,tht-0.001,0>, <0,tht,0>, tr}  
#if (holes_on)    object {holes  translate y*tht}   #end
  }
  torus {.5,0.007 translate y*tht}      

  /*  difference
  {
    cylinder {<0,tht-small_radius,0>, <0,tht,0>, tr}  
    cylinder {<0,(tht-small_radius)*0.9,0>, <0,tht*1.1,0>, tr-0.02}  
  }


               */
  
  //feet
  //       
  #declare secant_length = array[3]{.35,.3,.32}
  #declare major_radius = array[3]{.30,.9,2.5}
  #declare total_rotation=0;
  #declare xr=0;
  #declare zr=0;  
  #declare alfa=0;
  
  #declare foot= union
  { 
    Get_end_point_of_arc(major_radius[0], small_radius, secant_length[0], xr, zr, alfa) 
    #declare v1=<xr,0,zr>;
    object {arc_with_round_section(major_radius[0], small_radius, secant_length[0])} 
    #declare end_point=v1;    
    #declare gama=alfa;   
    #declare first_point=<-xr,0,zr>;
                        
    #declare i=1;
    #while (i<3)            
     Get_end_point_of_arc(major_radius[i], small_radius, secant_length[i], xr, zr, alfa) 
     #declare gama=180-gama-alfa; 
     #declare total_rotation=total_rotation+gama;
     #declare connect_point=vaxis_rotate(<-xr,0,zr>,y,total_rotation);

     #declare beta = degrees(atan2(connect_point.x,connect_point.z));
     object {arc_with_round_section(major_radius[i], small_radius, secant_length[i]) 
             rotate y*total_rotation      
             translate end_point-connect_point 
            } 

     #declare new_end_point = vaxis_rotate(<xr,0,zr>,y,total_rotation);
     #declare new_end_point = new_end_point+ end_point-connect_point;  
     #declare end_point = new_end_point;   
 
     #declare i=i+1;    
     #declare gama=alfa;   
    #end          
   }
   
  #declare feet = union
  { 
   #declare i=0;
   #while (i<4)
    object {foot   
            translate -first_point   
            rotate x*-90 
            rotate z*-50
            translate <-tr,tht-small_radius/2,0>    
            rotate i*90*y
           }       
     //sphere {<-tr*0.56,tht/3,0> 0.01 pigment {Red} rotate i*90*y}
     #declare i=i+1;
    #end   
  }               
   
  
//[[[[[[[[[[[[[[[[[[[[[[
// feet connection
  #declare small_radius=0.006;
  #declare secant_length = array[3]{.1,.35,.1}
  #declare major_radius = array[3]{1.0,.186,1.0}
  #declare total_rotation=0;
  #declare xr=0;
  #declare zr=0;  
  #declare alfa=0;
  
  #declare connection= union
  { 
    Get_end_point_of_arc(major_radius[0], small_radius, secant_length[0], xr, zr, alfa) 
    #declare v1=<xr,0,zr>;
    object {arc_with_round_section(major_radius[0], small_radius, secant_length[0])} 
    #declare end_point=v1;    
    #declare gama=alfa;   
    #declare first_point=<-xr,0,zr>;
    
//    sphere {end_point 0.02 pigment {Red}}
                        
    #declare i=1;
    #while (i<3)            
     Get_end_point_of_arc(major_radius[i], small_radius, secant_length[i], xr, zr, alfa) 
     #declare gama=180-gama-alfa; 
     #declare total_rotation=total_rotation+gama;
     #declare connect_point=vaxis_rotate(<-xr,0,zr>,y,total_rotation);

     #declare beta = degrees(atan2(connect_point.x,connect_point.z));
     object {arc_with_round_section(major_radius[i], small_radius, secant_length[i]) 
             rotate y*total_rotation      
             translate end_point-connect_point 
            } 

     #declare new_end_point = vaxis_rotate(<xr,0,zr>,y,total_rotation);
     #declare new_end_point = new_end_point+ end_point-connect_point;  
     #declare end_point = new_end_point;   
 //   sphere {end_point 0.02 pigment {Red}}
 
     #declare i=i+1;    
     #declare gama=alfa;   
    #end          
   }
  
  
  
  
  
  
  object {feet}  
  //object {connection translate -first_point rotate y*-33 translate <-tr*0.56,tht/3,0>}
  //object {connection translate -first_point rotate y*-33 translate <-tr*0.56,tht/3,0>  rotate y*180}
  

}     
      
  
#declare tbl_txt = texture {pigment {Gray50} finish {specular 0.25 roughness 0.15}}   
                  
object {
table 
rotate y*15 
texture {tbl_txt} 
translate <-5.35+.1,0,-5.45> 
}               
      
//cylinder {<-5,0,0> <5,0,0> 0.01 pigment {Red}}


                                           

