#include "branche_de_saule_mesh_1.inc"
// ----------------------------------------
#declare saule_tex = texture
{
  pigment {color rgb < 0.5, 0.3, 0.15>*0.5}   
  normal {
    gradient x       // this is the PATTERN_TYPE
    slope_map {       // Now let's get fancy
      [0.0  <0, 1>]   // Do tiny triangle here
      [0.2  <1, 1>]   //  down
      [0.2  <1,-1>]   //     to
      [0.4  <0,-1>]   //       here.
      [0.4  <0, 0>]   // Flat area
      [0.5  <0, 0>]   //   through here.
      [0.5  <1, 0>]   // Square wave leading edge
      [0.6  <1, 0>]   //   trailing edge
      [0.6  <0, 0>]   // Flat again
      [0.7  <0, 0>]   //   through here.
      [0.7  <0, 3>]   // Start scallop
      [0.8  <1, 0>]   //   flat on top
      [0.9  <0,-3>]   //     finish here.
      [0.9  <0, 0>]   // Flat remaining through 1.0
    }
   turbulence 0.36  
   octaves 2  
   lambda 5  
   omega 0.15  
  }
  scale 0.5  
}




//.................................................................................
#declare rand_saule1 = seed(740);

#macro twig(v0, v1, rd0, rd1, level, dist, cumlen)   
  
  // conditions for elongating a branch
  #local elongate=0; 
  #switch (level)
    #case (0)         
       #if (v1.y<80) 
         #local elongate=1; 
         #local rd2=rd1*.94;  
         #local sinuos=1;
         #local blen=2;
       #end            
    #break 

    #case (1)
       #if (rd1>.7) 
         #local elongate=1; 
         #local rd2=rd1*.90; 
         #local sinuos=2;  
         #local blen=2;
       #end     
    #break             

    #case (2)
       #if (rd1>.5) 
         #local elongate=1; 
         #local rd2=rd1*.95; 
         #local sinuos1=2;  
         #local blen=2;
       #end     
    #break             

    #case (3)
       #if (rd1>.2) 
         #local elongate=1; 
         #local rd2=rd1*.95; 
         #local sinuos=2;   
         #local blen=2;
       #end     
    #break             

  #end


      
  #local v6 = vnormalize(v1-v0)*blen;
  #local v8 = vnormalize(<-v6.y, v6.x, 0.01>)*sinuos*rand(rand_saule1);
  #local v9 = vaxis_rotate(v8+v6,v6,rand(rand_saule1)*360);               
  #local v7 =v0+v6+v9;
  cone { v0, rd0, v7, rd1}  
 
#if (level>2 & elongate=0)            

  object {une_branche_de_saule
          rotate y*-degrees(atan2(v7.z,v7.x))
          translate <v7.x,-40+v7.y,v7.z>  
         }                    
  object {une_branche_de_saule_1 
          rotate y*(-degrees(atan2(v7.z,v7.x))+25+rand(rand_saule1)*20)
          translate <v7.x,-35+v7.y,v7.z>  
         }  
  #if (rand(rand_saule1)<0.75)                         
  object {une_branche_de_saule_2 
          rotate y*(-degrees(atan2(v7.z,v7.x))-25-rand(rand_saule1)*20)
          translate <v7.x,-40+v7.y,v7.z>  
         }            
  #end        
#end                
           
  #local cumlen1=cumlen+blen;   
  
  #if (elongate) 
     #local v8=v7+v6; 
     twig(v7, v8, rd1, rd2, level, dist, cumlen1)


  // conditions for new branches 
  #local new_branch=0;  
  #switch (level)
    #case (0)         
       #if (v1.y > 20 & rand(rand_saule1)<0.4) 
         #local new_branch=1; 
         #local rd1=rd1*.4+0.8; 
         #local rd2=rd1*.95; 
         #local min_insert_angle= 40;
         #local max_insert_angle= 50;
       #end               
    #break 

    #case (1)
       #if (rand(rand_saule1)<0.25) 
         #local new_branch=1; 
         #local rd1=rd1*.3+.4; 
         #local rd2=rd1*.95; 
         #local min_insert_angle= 30;
         #local max_insert_angle= 50;
       #end 
    #break             

    #range (2,3)
       #if (rand(rand_saule1)<0.99) 
         #local new_branch=1; 
         #local rd1=rd1*.3+.1; 
         #local rd2=rd1*.90; 
         #local min_insert_angle= 30;
         #local max_insert_angle= 50;
       #end 
    #break             
  #end

  #if (new_branch) 
     #local cumlen2=0;  
     #local level1=level+1; 
     #local alfa=rand(rand_saule1)*(max_insert_angle - min_insert_angle) + min_insert_angle;  
     //#local alfa=55;
     #declare valfa=v8;
     Get_vector_at_angle_alfa(v8, alfa, valfa) 
     #declare v9=vaxis_rotate(valfa,v8,rand(rand_saule1)*360);  
     twig(v8, v8+v9, rd1, rd2, level1, dist, cumlen2)
  #end        

  #end   
    
#end

//*****************************************************


//,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,

#declare v0=<0,0,0>;
#declare v1=<0,1,0>; 


#declare tree = union
{
twig(v0, v1, 4, 4, 0, 0, 0)    
}

object
{
tree    
texture {saule_tex}
scale .025        
translate <-2.9,0,2>
}     

/*
#declare tree = union
{
twig(v0, v1, 4, 4, 0, 0, 0)    
}
      */ 
      
      
        
object
{
tree    
texture {saule_tex}
scale .025*1.1
rotate y*100
translate <-12,.5,2>
}                