// Persistence of Vision Ray Tracer Scene Description File
// File: mm_garden.pov
// Vers: 3.1
// Desc: entry for irtc dec/99 (gardens)
// Date: 12/31/99
// Auth: marianne mandl   (mandl@vienna.at)
//

#version 3.1;  

global_settings 
{ 
  ambient_light <0.9, 0.35, 0.15>*1.5
  assumed_gamma 1.0 
}

// standard include files
#include "colors.inc"
#include "metals.inc"
#include "finish.inc"  

// home made include files 
#include "vector_macros.inc"
#include "arc_macro.inc"

                  
            
// soil and background tiles are switched off as they require bitmaps which are not included               
#declare ground=off;
#declare terrasse=off;
 
// all other elements are switched on and can be rendered 
#declare furniture=on;
#declare lawn=on;
#declare pine_tree=on;
#declare weeping_willow=on;
#declare back_hedge=on;
#declare walls=on;
#declare flowers=on;
#declare fougeres=on;
#declare hose=on;   
#declare vin=on;
#declare back_trees=on;
#declare ombres=on;
                   

// light color                   
#declare LateAfternoonLight= rgb <0.9, 0.35, 0.15>;//Gold;//
#declare MorningLight=White;
// ----------------------------------------
camera
{
  //location  <.0, 13.7, 1.0>  look_at   <-5, 1,  1> 
  //location  <-15, 2, -7>  look_at   <-12, 0,  15>  

  location  <-3, 1.65, -7>  look_at   <-12, 0,  15>   
  angle 50
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.4] [1.0 color White] }
  }
}

           
light_source
{
  0*x 
//color <0.8, 0.498039, 0.196078>*1.5
color LateAfternoonLight*0.5
  //color White
  translate <700, 300, -2000>  
  //translate <70000, 30000, -200000>  
  #if (!ombres) shadowless #end
}
                  
light_source
{
  0*x // light's position (translated below)
  //color <0.8, 0.498039, 0.196078>*0.5
  color LateAfternoonLight*.20
  //color White*0.5
  translate  <-3, 1.65, -1> 
  shadowless
}                   

light_source
{
  0*x 
  color LateAfternoonLight*.2
  translate  <-3, 1.65, -7> 
  shadowless
}
    
    
                   
// ----------------------------------------  

// tree colors
#declare lawn_green = rgb < 0.319, 0.78, 0.3267 >*.525; //rgb <.15, .75, .15>
#declare hedge_green = rgb < 0.3, 0.8, 0.20 >*.27;
 //rgb < 0.349, 0.7745, 0.3667 >*0.37 
#declare willow_green = rgb <0.35, 0.75, 0.33>*.6;
#declare pine_green = rgb < 0.2, 0.7745, 0.4 >*.215; 
                     
#declare cx=10;
#declare cz=12; 


//table and chairs  
#if (vin)
  #include "wine_glass.inc"  
  #include "cushion2.inc"
#end

#if (furniture)
  #include "chair1.inc"
  #include "table1.inc"
#else            
  #declare table = union
  { #declare tblh=0.8; 
    #declare tblr=0.5;
    cylinder {<0,tblh,0>, <0,tblh+0.05,0> tblr}
    cylinder {<0,0,0>, <0,tblh+0.05,0> tblr/10}
    cylinder {<0,0,0>, <0,0.03,0> tblr/3}
  }   


  #declare chair = union
  { 
    #declare chw2=0.22;
    #declare chh=0.37;
    #declare chfr=0.025;
    box {<-chw2,chh,-chw2>,<chw2,chh+0.05,chw2>}
    cylinder {<-chw2+chfr,0,-chw2+chfr>, <-chw2+chfr,chh,-chw2+chfr> chfr}
    cylinder {<-chw2+chfr,0,chw2-chfr>, <-chw2+chfr,chh,chw2-chfr> chfr}
    cylinder {<chw2-chfr,0,-chw2+chfr>, <chw2-chfr,chh,-chw2+chfr> chfr}
    cylinder {<chw2-chfr,0,chw2-chfr>, <chw2-chfr,chh,chw2-chfr> chfr}
  }       

  //object {table translate <-5.25+.1,0,-5.3> pigment {Blue}}
  //object {chair translate <-5.5,0,-4> pigment {Red}}
  //object {chair translate <-5.1+.2,-0.03,-4.3-.08> pigment {Red}}   
#end 



#declare lawn_clip = difference
{
  box {<-cx,-1,-3> <2,1,cz>}
  cylinder {<0,-1,0> <0,1,0> .35 translate <-8.5,0,2.8> } 
  cylinder {<0,-1,0> <0,1,0> .4 translate <-2.9,0,2> } 
  cylinder {<0,-1,0> <0,1,0> .5 scale <2,1,1> translate <-3, 0, -3> } 
  cylinder {<0,-1,0> <0,1,0> .6 scale <1.3,1,2.7> translate <-cx, 0, -0.2> } 
  
}
  

plane { y, -.026 pigment {Brown}}
#if (ground)
  #include "ground.inc"       
#end

#if (lawn)
  #include "grass.inc"       
  #declare dscale=0.35;
  #declare sq_len=ds*nn*dscale;
  #declare rndq=seed(676);
  #declare patch_of_grass = union
  {
  
  #declare i=-10;
  #declare j=-3;  
  #declare dm=(ds*(nn-1)*dscale)*.5;
  #while (i<0)
    #while (j<12)     
       object {grass1 scale dscale pigment {lawn_green}   
               translate <-dm,0,-dm>
               scale <pow(-1,ceil(rand(rndq)*2)),1,pow(-1,ceil(rand(rndq)*2))>     
               rotate <0,ceil(rand(rndq)*4)*90,0>
               translate <i+dm, 0, j+dm>
              }   
       #declare j=j+sq_len;
    #end
    #declare i=i+sq_len;
    #declare j=-3;
  #end 
  }

  object {patch_of_grass  clipped_by {lawn_clip}} 

#else
  plane { y, -.025 pigment {lawn_green} clipped_by {lawn_clip}}
#end

#if (walls)
  #include "wall1.inc"
#else
  box {<-cx,0,cz>, <-cx+0.2,2.1,-cz> pigment {White}}                    
  box {<-cx,0,cz>, <cx+0.2,2.1,cz-0.2> pigment {White}}                    
#end




  #declare tree_gate = union
  {  
   #declare dcx=3;
   #declare gw=1.0;
   #declare gh=1.5;
   #declare th2=.45;
   box {<-cx+dcx,-0.1,cz-7+1>, <-cx+dcx+gw,gh,cz-7-1>} 
   cylinder {<-cx+dcx+gw/2,gh,cz-7-1>,<-cx+dcx+gw/2,gh,cz-7+1> gw/2} 
  }     

  #declare hedge = difference
  {
   union
   {                  
     box {<-cx,0,cz-7+th2>, <0,2.1,cz-7-th2>}     
     cylinder {<-cx+dcx+gw/2,gh*.8,cz-7-th2>,
             <-cx+dcx+gw/2,gh*.8,cz-7+th2> gw*1.25} 
   }
   object {tree_gate}  
  }       

#if (back_hedge) 
#include "hedge1.inc"
object {haie clipped_by{hedge} bounded_by {clipped_by}
pigment { rgb < 0.2, 0.8, 0.4 >*.385 }
}
#else   
  object {hedge pigment { hedge_green}} 
  //rgb < 0.2, 0.8, 0.4 >*.385 }}//< 0.349, 0.7745, 0.3667 >*.225 }} 
#end

#if (weeping_willow)                       
  #include "saule.inc"
#else
  #declare saule = union
  { #declare sh=1;
    #declare sr=1.3;
    cylinder {<0,0,0>, <0,sh,0>, .15}  
    sphere {<0,sh+sr,0> sr}
    cylinder {<0,sh+sr,0>, <0,sh,0>, sr} 
    pigment {willow_green} 
  }    
  object {saule scale .85 translate <-3,0,2>}        
  object {saule  scale 1.1 translate <-12,0,2>}        
#end

#if (pine_tree)
  #include "sapin.inc"
#else
  #declare sapin = cone {<0,0,0>,1,<0,4,0>,0 pigment { pine_green}}  
  object {sapin translate <-8.8,0,3.9>}        
#end




//flowers
#if (flowers)
  #include "flowers2.inc"  
  #include "daisy.inc"
  object {des_fleurs(420, .3, 16, OrangeRed, 2, 50, 24, Gray10) 
          scale .1/4
          rotate x*-17
          translate <-3.65, -0.22, -2.75>
         }   
  #declare k=0;             
  #declare r1=seed(1);
  #while (k<30)      
     object {des_fleurs(1, .5, 5, White*1.5, 2, 50, 24, Gold) 
             scale .1/6                             
             rotate y*rand(r1)*360
             translate <-cx+rand(r1)*cx, 0.02, -3+rand(r1)*6-0.15>
            } 
     #declare k=k+1;
  #end       
#end     


//fern
#if (fougeres)
  #include "fern2.inc"
#end     


//terrasse
#if (terrasse)
  #include "tiles1.inc"  
  #include "cement.inc"
#end 

//#if (jetdeau)
  //#include "jet_d_eau1.inc"
//#end    

#if (hose)
  #include "hose1.inc"
#end    


// background tree
#if (back_trees)
  #include "tree2.inc"
  #include "tree3.inc"
#end
