// ----------------------------------------
#declare r1=seed(2);
#declare water_tx1 = material {texture {pigment {Red}}}

#declare water_tx = 
   material  
   {   
      texture
      {      
         pigment
         {
            color rgbf <1.0, 1.0, 1.0, 0.906233>
         }     
         finish
         {
            ambient 0.0
            diffuse 0.0
            brilliance 0.977333
            phong 0.021567
            phong_size 31.123333
            specular 0.654667
            roughness 0.001
            reflection 0.143867
         }          
      }   
      interior
      {
         ior 1.33
      }       
   }


//#declare drop=sphere{0,0.04} 


#macro spray(v0)  
#local s0=<0,0,0>;
#local half_g=9.81/2; 
#local tm=0;
union 
//merge
{
#while (tm<6)            
   #declare tm2=tm*tm;
   #declare xt=s0.x + v0.x*tm + rand(r1)*tm/4;  
   #declare yt=s0.y + v0.y*tm - half_g*tm2 + rand(r1)*tm/10;   
   #declare zt=s0.z + v0.z*tm + rand(r1)*tm/4;  
   object {sphere{0,0.007*0.15+rand(r1)*0.005*0.15} translate <xt,yt,zt>*0.15}
   #declare tm=tm+.0015;
#end
}    
#end

#declare h=sqrt(0.65*0.65-0.25*0.25);

#declare jet_d_eau = union
{
#declare i=0; 
#declare njets=20;
#while (i<njets) 
 #declare x0=7+rand(r1)*.5; 
 #declare y0=13+rand(r1)*.1;
 #declare z0=-12+i*1.2;
 #declare v0=<x0, y0, z0>; 
 #declare dy=-h+sqrt(0.65*0.65-(-0.20+i*0.02)*(-0.20+i*0.02));
 object {spray(v0) translate <0, dy, -0.20+i*0.02>
 }
 #declare i=i+1;
#end  
}

