#include "jet_d_eau2.inc"
// ----------------------------------------
#declare watering_device = union
{
  #declare small_radius=0.010; 
  #declare ht=0.05;
  torus {0.25, small_radius scale <1,1,0.55>
            texture {T_Chrome_5A}
        }

    #declare xr=0;
    #declare zr=0;  
    #declare alfa=0;
    Get_end_point_of_arc(0.65, small_radius, .5, xr, zr, alfa)   
 
    #declare v1=<0,0,zr>;
    object {arc_with_round_section(0.65, small_radius, .5) 
            translate -v1
            rotate x*-90 
            translate y*ht 
            texture {T_Chrome_5A}
           }   
    cylinder {<0,0,0> <0,ht,0> small_radius*0.75   
              translate x*-0.25 
              texture {T_Brass_1A}
             }
    cylinder {<0,0,0> <0,ht,0> small_radius*0.75   
              translate x*0.25 
              texture {T_Brass_1A}
             }
  
    cylinder {<0,0,0> <0.07,0.,0> 0.04   
              translate <0.25-0.02,ht,0> 
              texture {T_Brass_1A}
             } 
    torus {0.04, 0.007 rotate z*-90 translate <0.25-0.02,ht,0> texture {T_Brass_1A}}
    torus {0.04, 0.007 rotate z*-90 translate <0.32-0.02,ht,0> texture {T_Brass_1A}}
}
  

   
   

#declare tuyau = union
{

#declare first_pt_1=<0,0,0>;
#declare last_pt_1=<0,0,0>;
#declare first_pt_2=<0,0,0>;
#declare last_pt_2=<0,0,0>;
#declare first_pt_3=<0,0,0>;
#declare last_pt_3=<0,0,0>;
#declare first_pt_4=<0,0,0>;
#declare last_pt_4=<0,0,0>;
   
#declare small_radius=0.015;

//  1st segment
#declare secant_length = array[3]{.7,.3,.2}
#declare major_radius = array[3]{.6,.5,1.7}
object {connect_2d_arcs(3, secant_length, major_radius, small_radius, first_pt_1, last_pt_1)
        translate -last_pt_1     
        rotate z*-3
        translate last_pt_1     
       } 


//  2nd segment
#declare secant_length = array[3]{.2,.3,.5}
#declare major_radius = array[3]{1.3,1.5,2.2}
object {connect_2d_arcs(3, secant_length, major_radius, small_radius, first_pt_2, last_pt_2)
        translate -first_pt_2 
        rotate x*180  
        rotate y*75
        translate last_pt_1
       }   
       
#declare last_pt_2 = last_pt_2 - first_pt_2; 
#declare last_pt_2 = vaxis_rotate(last_pt_2,x,180); 
#declare last_pt_2 = vaxis_rotate(last_pt_2,y,75) +last_pt_1; 

//  3rd segment
#declare secant_length = array[3]{.2,.7,1.5}
#declare major_radius = array[3]{1.3,2.5,3.2}
object {connect_2d_arcs(3, secant_length, major_radius, small_radius, first_pt_3, last_pt_3)
        translate -first_pt_3 
        rotate y*45
        translate last_pt_2 
       }   
#declare last_pt_3 = last_pt_3 - first_pt_3; 
#declare last_pt_3 = vaxis_rotate(last_pt_3,y,45) +last_pt_2; 
       
//  4th segment
#declare secant_length = array[3]{.6,1.7,2.5}
#declare major_radius = array[3]{2.3,6.5,12.2}
object {connect_2d_arcs(3, secant_length, major_radius, small_radius, first_pt_4, last_pt_4)
        translate -first_pt_4   
        rotate x*180
        rotate y*90
        translate last_pt_3 
       }
}



#declare hose_tx =
texture {pigment {Black} finish {specular 0.15 roughness 0.15}} 

#declare systeme_d_arrosage = union     
{     
//  pipe
object {
        tuyau  texture {hose_tx}
        translate -first_pt_1  
}             
//  watering thing
object {watering_device 
        translate x*-0.25   
        rotate y*-35
       }  

object {jet_d_eau 
        translate z*-0.25 
        rotate y*(90-35)
        translate y*ht
        material {water_tx}
       }
}        

object {systeme_d_arrosage
        scale .8
        rotate y*-60    
        translate <-5.5,0.035,-.5>
}

        
//sphere {0, 0.04 pigment {Red}} 


