
#declare rsap1=seed(56);//38);
                        
#declare leaf1 = mesh
{
  #declare vt1=<-0.0636,0,0>;
  #declare vt2=<0.0636,0,0>;
  #declare vt3=<0,.75,0>;
  #declare vt4=vt3;
  #declare vt5=vt3+<0.0636,0,0>;
  #declare vt6=vt2;
  
  
  #declare i=0;
  #while (i<4)     
    #declare vt1=vaxis_rotate(<-0.0636,0,0>, x, i*90);
    #declare vt2=vaxis_rotate(<0.0636,0,0>, x, i*90);
    #declare vt3=vaxis_rotate(<0,.75,0>, x, i*90);
    #declare vt4=vt3;
    #declare vt5=vaxis_rotate(<0,.75,0>+<0.0636,0,0>, x, i*(80+rand(rsap1)*20));
    #declare vt6=vt2;
  triangle {vt1, vt2, vt3}
  triangle {vt4, vt5, vt6} 
    #declare i=i+1;
  #end
     
  
}                                            


#macro place_branch_with_leaves(v0, vtrans, gama, leaf_len)   
  #local v4 = vaxis_rotate(vnormalize(<-v0.y, v0.x, 0.000>), v0, gama);
  #local v2 = vaxis_rotate(vnormalize(<-v0.y, v0.x, 0.000>), v0, gama);
  #local v3 = vaxis_rotate(v2, v0, 90);    
  #local v1 = vaxis_rotate(v4, v3, 15-rand(rsap1)*30);
  #local alfa = degrees(atan2(v1.z,v1.x));     
  #local v1x = sqrt(v1.x*v1.x+v1.z*v1.z);
  #local beta = degrees(atan2(v1x,v1.y));  

  #declare vt1=<-0.0636,0,0>;
  #declare vt2=<0.0636,0,0>;
  #declare vt3=<0,.75,0>;
  #declare vt4=vt3;
  #declare vt5=vt3+<0.0636,0,0>;
  #declare vt6=vt2;
  
  
  #declare i=0;
  #while (i<4)     
    #declare vt1=vaxis_rotate(<-0.0636,0,0>*leaf_len*.25, x, i*(80+rand(rsap1)*20));
    #declare vt2=vaxis_rotate(<0.0636,0,0>*leaf_len*.25, x, i*(80+rand(rsap1)*20));
    #declare vt3=vaxis_rotate(<0,.75,0>*leaf_len*.25, x, i*(80+rand(rsap1)*20));
    #declare vt5=vaxis_rotate((<0,.75,0>+<0.0636,0,0>)*leaf_len*.25, x, i*(80+rand(rsap1)*20));
        
    #declare vt1=vaxis_rotate(vt1, z, -beta);
    #declare vt2=vaxis_rotate(vt2, z, -beta);
    #declare vt3=vaxis_rotate(vt3, z, -beta);
    #declare vt5=vaxis_rotate(vt5, z, -beta);
    
    #declare vt1=vaxis_rotate(vt1, y, -alfa) + vtrans;
    #declare vt2=vaxis_rotate(vt2, y, -alfa) + vtrans;
    #declare vt3=vaxis_rotate(vt3, y, -alfa) + vtrans;
    #declare vt5=vaxis_rotate(vt5, y, -alfa) + vtrans;
    #declare vt4=vt3;
    #declare vt6=vt2;  

    triangle {vt1, vt2, vt3}
    triangle {vt4, vt5, vt6} 
    #declare i=i+1;
  #end     
#end      

                      /*
#declare hedge_branch = mesh
 {
   #local leaf_scaling=1; 
   #local v1=<0,1,0>;  
   #local vrot = <rand(rsap1)*360,rand(rsap1)*360,rand(rsap1)*360>;
   //#local v1 = vrotate(v1,vrot);     
   #local vc1=<0,0,0>;  
   triangle {vc1-<.015,0,0>, vc1+<.015,0,0>, v1-<.015,0,0>}
   triangle {v1-<.015,0,0>, v1+<.015,0,0>, vc1+<.015,0,0>}   

          #local lv1 = vlength(v1); 
          #local dc=0.05;
          #local ds=.05;  
          #while (ds < lv1)
            place_branch_with_leaves(ds*v1, vc1+ds*v1, rand(rsap1)*360, leaf_scaling)       
            #if (leaf_scaling < 0.35) 
              #local leaf_scaling = 0.35; 
            #else 
              #local leaf_scaling=leaf_scaling*0.97;  
            #end        
            #local ds = ds+ dc;     
            #local dc=0.05*leaf_scaling;
          #end  
  }   
  
  
        
                          */
                          
                          
                          
// good parameters : dijk=.25   leaf_scaling=.75   dc=0.05 --> see hedge1.jpg
// good parameters : dijk=.20   leaf_scaling=.5   dc=0.075 
#declare hedge_blob= mesh
{
  
  #declare ds=1.;   
  #declare dijk=.22;
  #declare i0=0;
  #declare j0=0;
  #declare k0=0;
  #while (i0<ds) 
    #declare j0=0;
    #while (j0<ds)  
      #declare k0=0;   
      #while (k0<ds)
   #local leaf_scaling=.5; 
   #local v1=<0,1,0>;  
   #local vrot = <rand(rsap1)*360,rand(rsap1)*360,rand(rsap1)*360>;
   #local v1 = vrotate(v1,vrot);     
   #local vc1=<i0,j0,k0>;  
   //triangle {vc1-<.005,0,0>, vc1+<.005,0,0>, vc1+v1-<.005,0,0>}
   //triangle {vc1+v1-<.005,0,0>, vc1+v1+<.005,0,0>, vc1+<.005,0,0>}   

          #local lv1 = vlength(v1); 
          #local dc=0.075;
          #local ds=.05;  
          #while (ds < lv1)
            place_branch_with_leaves(ds*v1, vc1+ds*v1, rand(rsap1)*360, leaf_scaling)       
            /*#if (leaf_scaling < 0.35) 
              #local leaf_scaling = 0.35; 
            #else 
              #local leaf_scaling=leaf_scaling*0.97;  
            #end       */ 
            #local ds = ds+ dc;     
            //#local dc=0.1*leaf_scaling;
          #end  
      #declare k0=k0+dijk; 
      #end 
    #declare j0=j0+dijk; 
    #end  
    #declare i0=i0+dijk;
  #end

} 


//#declare clip_box = box {<-0.095,-0.095,-0.095>,<1.095,1.095,1.095>}  
#declare clip_box = box {<0,0,0>,<1,1,1>}  
    

#declare hedge_cube =
object {hedge_blob //scale <.5,.5,.5> 
//clipped_by {clip_box}
//bounded_by {clipped_by}   
translate <-ds/2,-ds/2,-ds/2>
//pigment { rgb < 0.349, 0.7745, 0.3667 >*0.37 }
}   

       
       
          
#declare haie =  
union
{ 
#declare ax=-cx;
#declare ay=0;
#while (ax<0)
  #declare ay=0;
  #while (ay<3)
    object {hedge_cube             
            scale <pow(-1,ceil(rand(rsap1)*2)),pow(-1,ceil(rand(rsap1)*2)),
                   pow(-1,ceil(rand(rsap1)*2))>
            rotate <ceil(rand(rsap1)*2)*180,ceil(rand(rsap1)*4)*90,ceil(rand(rsap1)*2)*180> 
            translate <ax, ay, cz-7+.05-rand(rsap1)*.1> 
           }    
    object {hedge_cube             
            scale <pow(-1,ceil(rand(rsap1)*2)),pow(-1,ceil(rand(rsap1)*2)),
                   pow(-1,ceil(rand(rsap1)*2))>
            rotate <ceil(rand(rsap1)*2)*180,ceil(rand(rsap1)*4)*90,ceil(rand(rsap1)*2)*180> 
            translate <ax+0.25, ay+0.25, cz-7+.05-rand(rsap1)*.1> 
           }    
    #declare ay=ay+1;
  #end               
  #declare ax=ax+1;
#end
} 
                         
          
      
      
    /*  object {hedge 
      bounded_by{hedge} 
      pigment {HuntersGreen}}    */