// ----------------------------------------
#declare GroundTexture =
texture {
  pigment{
    granite
    color_map{
       [0.0   color rgb <0.26, 0.22, 0.22>]
       [0.2   color rgb <0.25, 0.22, 0.22>]
       [0.6   color rgb <0.32, 0.25, 0.25>]
       [0.8   color rgb <0.35, 0.25, 0.20>]
       [1.0   color rgb <0.40, 0.35, 0.30>]
    }
  }
  scale 1.25 rotate y*25
}   
      
texture {
  pigment{
    bozo
    turbulence 0.5
    color_map{
       [0.0   color rgbf <0.17, 0.17, 0.17, 0.5>]
       [0.1   color rgbf <0.32, 0.22, 0.22, 0.5>]
       [0.2   color rgbf <0.50, 0.50, 0.50, 0.8>]
       [0.6   color rgbf <0.50, 0.50, 0.50, 0.95>]
       [0.8   color rgbf <0.72, 0.58, 0.55, 0.75>]
       [1.0   color rgbf <0.89, 0.61, 0.50, 0.3>]
    }
  }
  scale 0.05 rotate y*40
}                                
                 


#declare earth_slab =
height_field{
   tga "tile3.tga"  scale <1.2,1,1.2>
}                    



#declare visible_ground = union
{
  cylinder {<0,-1,0> <0,1,0> .6 translate <-8.5,0,2.8> } 
  cylinder {<0,-1,0> <0,1,0> .6 translate <-2.9,0,2> }
  difference
  { 
   cylinder {<0,-1,0> <0,1,0> .7 scale <2,1,1> translate <-3, 0, -3> }     
   box {<-6,-1,-4> <2,1,-3>}
  }
  cylinder {<0,-1,0> <0,1,0> .7 scale <1.3,1,2.7> translate <-cx, 0, -.2> } 
}

#declare rndq=seed(676);

#declare tree_soil= union
{
  #declare i=-1;
  #declare j=-1;  
  #while (i<1)
    #while (j<1)     
       object {earth_slab texture {GroundTexture}//
       //pigment {color rgb <0.16, 0.05, 0.05>}} 
       scale <1,.25,1> 
             //  scale <pow(-1,ceil(rand(rndq)*2)),1,pow(-1,ceil(rand(rndq)*2))>     
              // rotate <0,ceil(rand(rndq)*4)*90,0>
               translate <i, -.08, j>
              }   
       #declare j=j+1;
    #end
    #declare i=i+1;
    #declare j=-1;
  #end 
}   

#declare wall_soil= union
{
  #declare i=-1;
  #declare j=-1;  
  #while (i<1)
    #while (j<3)     
       object {earth_slab texture {GroundTexture}
       scale <1,.25,1> translate <i, -.08, j>}   
       #declare j=j+1;
    #end
    #declare i=i+1;
    #declare j=-1;
  #end 
}

#declare foreground_soil= union
{
  #declare i=-2;
  #declare j=-1;  
  #while (i<2)
    #while (j<1)     
       object {earth_slab texture {GroundTexture}
       scale <1,.25,1> translate <i, -.08, j>}   
       #declare j=j+1;
    #end
    #declare i=i+1;
    #declare j=-1;
  #end 
}          

#declare terrasse_soil= union
{
  #declare i=-cx;
  #declare j=-3;  
  #while (i<-2)
    #while (j<-2)     
       object {earth_slab texture {GroundTexture}
       scale <1.,.25,1.> translate <i, -.08, j>}   
       #declare j=j+1;
    #end
    #declare i=i+1;
    #declare j=-3;
  #end 
}


  #declare dy=0.03;
  object {tree_soil translate <-8.5,dy,2.8> clipped_by {visible_ground}}   
  object {tree_soil translate <-2.9,dy,2> clipped_by {visible_ground}}   
  //object {foreground_soil translate <-3, dy, -3> clipped_by {visible_ground}}   
  object {wall_soil translate <-cx, dy, -.2> clipped_by {visible_ground}}   
  object {terrasse_soil}   
