// ----------------------------------------
#declare rand_grass = seed(10);   
#declare my_green = rgb < 0.349, 0.7745, 0.3667 >*.525;
#declare my_tx = texture
{
 pigment {my_green}   
}

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#macro grass(v0, v1, v_final_dir, alfa_max, rayon, level, branch_len, 
             sc, yrot, col, row, dx, dy, ds)   
   
   #local vn = vnormalize(v1-v0);
   #local vm = <-vn.y, vn.x, 0.01>;
   #local v2 = vn*branch_len + v0;  
   #local vo = vm*rayon;    
   #local trans = <col*ds+dx, 0, row*ds+dy>;
   #local vt1=vaxis_rotate(v0-vo, y, yrot)*sc + trans; 
   #local vt2=vaxis_rotate(v0+vo, y, yrot)*sc + trans;
   #local vt3=vaxis_rotate(v2+vo, y, yrot)*sc + trans;
   #local vt4=vaxis_rotate(v2-vo, y, yrot)*sc + trans;
   #local vt5=vaxis_rotate(v2+vo, y, yrot)*sc + trans;
   #local vt6=vaxis_rotate(v0-vo, y, yrot)*sc + trans;  
   
   
   triangle {vt1, vt2, vt3}     
   triangle {vt4, vt5, vt6} 
  
   #local rayon1=rayon*.66;  
   #local level1=level+1;  
   #local branch_len1=(.07+0.06*rand(rand_grass))*branch_len;
  
   #local v3=vnormalize(v1-v0)*branch_len1;   
   #local rc = branch_len1*tan(radians(alfa_max)*rand(rand_grass));
   #local v4 = vnormalize(<-v3.y, v3.x, 0.00>)*rc;     
   #local v5 = v4+v3 + v2;
  
   
   #local v6 = vnormalize(v_final_dir);
   #local v7 = vnormalize(v3+v4);
   #local alfa_max1 = alfa_max;  
     #if (sqrt((v7.x-v6.x)*(v7.x-v6.x) +(v7.y-v6.y)*(v7.y-v6.y)) < 0.1)
       #local alfa_max1 = alfa_max+3;  
     #end              
   
   #if (level1<3+rand(rand_grass)*4)  
     grass(v2, v5, v_final_dir, alfa_max1, rayon1, level1, 
          branch_len1, sc, yrot, col, row, dx, dy, ds)  
   #end      
#end

//*****************************************************


//,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,

#declare v_final_dir=<0,3,0>; 
#declare nn=20;
#declare ds=0.11;
#macro Bueschel(ii, jj)   
  #local i=0;  
  #local n=10+rand(rand_grass)*10;
  #while (i<n)    
    #if (rand(rand_grass)>0.5)       
      #local alfa = -(5+rand(rand_grass)*10); 
    #else
      #local alfa = -(2+rand(rand_grass)*4); 
    #end      
    
      #local x0 = rand(rand_grass)*rand(rand_grass);
      #local v0=<x0,0,0>;
      #local v1=<x0+(rand(rand_grass)-.5)*1,1,0>;     
      #local yrot1=i*360/n+rand(rand_grass)*15;
      #local dx1=-0.035+rand(rand_grass)*0.07;
      #local dy1=-0.035+rand(rand_grass)*0.07;
      grass(v0, v1, v_final_dir, alfa,  .07, 0, 3, .05, yrot1, ii, jj, dx1, dy1, ds)        
   
    #local i=i+1;
  #end 
#end    
          
    
#declare grass1 = mesh
{ 
  #declare k=0;
  #declare j=0; 
  #while (j<nn)
     #while (k<nn) 
        Bueschel(k-0.1+rand(rand_grass)*0.2, j-0.1+rand(rand_grass)*0.2) 
        #declare k=k+1;  
     #end    
     #declare j=j+1; 
     #declare k=0;
  #end 
}  

      
#declare soil_tx = texture
{
  pigment{
    granite
    color_map{
       [0.0   color rgb <0.48, 0.27, 0.22>]
       [0.2   color rgb <0.50, 0.28, 0.22>]
       [0.7   color rgb <0.68, 0.35, 0.25>]
       [0.8   color rgb <0.60, 0.35, 0.20>]
       [1.0   color rgb <0.60, 0.35, 0.30>]
    }
  }
  scale 1.25
}
  
#declare soil = plane
{
 y, -.1
 texture {soil_tx}
}  

object {soil}  
            
                  
