
// ----------------------------------------
#declare r1 = seed(10);   
#declare r2 = seed(70);   

#declare wi=3;

#declare my_green = rgb < 0.2 0.9, 0.4 >*.625;

#declare leaf2 = object
{
  cone {<0,0,0> 1 <0,1,0> .35
            scale <wi/2., 19, 0.05>                 
           }
  pigment { my_green }
} 
     /*
#declare leaf1 = 
box {
				<0,0,0>,<1,1,.01>
				texture {
					material_map {
						gif "leaf1.gif"
						texture {pigment {color my_green}}
						texture {pigment {color Clear}}
					}
				}
				//rotate x*90
				//translate <-.5,0,0>
				scale <.42,1.9,.5>*7
			}


                                   */

#macro place_leaf3(v0, ds, vtrans1, vtrans2, gama, leaf_len)
   
   
 #if (v0.x!=0 | v0.y!=0 | v0.z!=0) 
      
   #if (v0.x=0)
     #if (v0.z >=0)
       #local beta=90;
     #else
       #local beta=-90;
     #end 
   #else
     #local beta = degrees(atan2(v0.z,v0.x));     
   #end
   
   #local v4=vaxis_rotate(v0,y,beta);

   #if (v4.x=0)
     #if (v4.y >=0)
       #local alfa=-90;
     #else
       #local alfa=90;
     #end 
   #else
     #local alfa = degrees(-atan2(v4.y,v4.x));     
   #end

   #local gama1=gama+90;       
   #local i=0;
   #while (i<2)
     #if (i=0)  
       #local vtrans=vtrans1; 
     #else   
       #local vtrans=vtrans2;  
     #end
     object 
     {leaf2 scale <1,leaf_len,1>
      rotate x*gama1 rotate z*-alfa rotate y*-beta translate vtrans
     }  
     #local gama1=gama1-150; 
     #local i=i+1;
   #end
   
 #end
          
#end

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#macro twig(v0, v1, v_final_dir, alfa_max, rayon, level, branch_len, 
            leaf_scaling, rot_angle, init_angle, curr_pos)   

   #local v2 = vnormalize(v1-v0)*branch_len + v0;
   cylinder {v0, v2, rayon pigment {my_green*0.5}}

          #local ra=rot_angle;  
          #local leaf_scaling1=leaf_scaling*0.85*(1+0.21*rand(r1)); 
          #local curr_pos1=curr_pos;  
          #local dv=wi;  
          #local lv1 = vlength(v2-v0);  
          #while (curr_pos1 < lv1)
              #local ra=ra-1.0;
              #if (ra>360) #local ra=0; #end   
              place_leaf3(v2-v0, curr_pos1/lv1, 
                          v0+(v2-v0)*(curr_pos1/lv1-rand(r2)/5),
                          v0+(v2-v0)*((curr_pos1-wi/2.5-rand(r2)/5)/lv1), 
                          rand(r2)*20+init_angle+ra, leaf_scaling)
              #local curr_pos1=curr_pos1+dv;  
          #end        
          #if (curr_pos1 > lv1) #local curr_pos1=curr_pos1-lv1;  #end
                         
  
   #local rayon1=rayon*.96;  
   #local level1=level+1;  
   #local branch_len1=.96*branch_len;
  
   #local v3=vnormalize(v1-v0)*branch_len1;   
   #local rc = branch_len1*tan(radians(alfa_max)*rand(r1));
   #local v4 = vnormalize(<-v3.y, v3.x, 0.00>)*rc;     
   #local v5 = v4+v3 + v2;
  
   
   #local v6 = vnormalize(v_final_dir);
   #local v7 = vnormalize(v3+v4);
   #local alfa_max1 = alfa_max;  
   //#if (abs(alfa_max) > 0) 
     #if (sqrt((v7.x-v6.x)*(v7.x-v6.x) +(v7.y-v6.y)*(v7.y-v6.y)) < 0.1)
       #local alfa_max1 = alfa_max+3;  
     #end              
   //#end  
   
   #if (level1<27+rand(r1)*24)  
     twig(v2, v5, v_final_dir, alfa_max1, rayon1, level1, 
          branch_len1, leaf_scaling1, ra, init_angle, curr_pos1)  
   #else
     #local curr_pos1=6;       
   #end
#end

//*****************************************************


//,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,

#declare v_final_dir=<0.5,-1,0>; 


#declare branch = union
{
#local v0=<2,0,0>;
#local v1=<2,6,0>; 
twig(v0, v1, v_final_dir, -15,  .5, 0, 8, 1, 2, 0, 0)    
}  

#macro branch1(alfa)
  union
{ 
#local x0 = rand(r1)*3;
#local v0=<x0,0,0>;
#local v1=<x0,6,0>; 
twig(v0, v1, v_final_dir, alfa,  .3, 0, 8, 1, 2, 25-rand(r1)*50, 0)    
}  
        
#end

#declare plant = union
{
  #declare i=0;  
  #declare n=50;
  #while (i<n)           
    #declare alfa = -(7+rand(r1)*12);
    object {branch1(alfa)    pigment {my_green}  scale .1 rotate y*(i*360/n+rand(r1)*15)}  
    #declare i=i+1;
  #end
}        

        /*
object {plant   //no_shadow
 scale .05
 translate <-4,-.15,cz-7-th2-0.5>} 
                           */
 
object {plant //no_shadow
 scale .05 
 rotate y*140
 translate <-2.85,-.05,-3.0>}