#declare r1 = seed(10);   
#declare r2 = seed(70); 
  


#declare my_green = rgb < 0.1, 0.5, 0.3 >*.3;



 
#declare cl_sph = union
{ 
sphere { 0.0, 1.  translate <0, 0, 2.0>}
//sphere { 0.0, 1.  translate <0, .01, 2.0>}
}     

//object {cl_sph pigment {Blue}}
 
#macro petal(petal_len, petal_opening, petal_num, centre_rad)   
#local delta = 360/petal_num; 
#local sm_rad=.75+.5*rand(r1);
#local big_rad=1;
torus {big_rad, sm_rad   
       clipped_by {cl_sph}  
       translate y*(sm_rad*0.5)
       translate -(big_rad*1)*z
       scale <.5,petal_len,.5>  
       translate (centre_rad*0.9)*z
       rotate y*(5+rand(r1)*10)
       rotate (petal_opening+rand(r1)*20)*x
       rotate y*delta
       translate y*(sm_rad*0.75)
      } 
#end

#macro fleur(petal_col, petal_len, petal_opening, petal_num, centre_col)
union
{
 #local centre_rad=1.0;
 #local i1=0;   
 #local delta=360/petal_num;
 #while (i1< petal_num)
    object {petal(petal_len*(0.9+rand(r1)*0.2), petal_opening*(0.9+rand(r1)*0.2), 
            petal_num, centre_rad) 
            rotate i1*(delta)*y pigment{petal_col}}   
    #local i1=i1+1;
 #end     
 sphere { <0,0,0>, centre_rad  scale <1,0.25,1>   
          texture
          {
            pigment {centre_col} 
            //normal {agate 0.2 scale 0.10}     
          }
        }             
 scale <1,1-rand(r1)/2,1>*1
 rotate (y*rand(r1)*30)
}        
#end


#macro flower(v1, petal_col, petal_len, petal_opening, petal_num, centre_col)
  #declare alfa = degrees(atan2(v1.z,v1.x));     
  #declare v1x = sqrt(v1.x*v1.x+v1.z*v1.z);
  #declare beta = degrees(atan2(v1x,v1.y));  

  object {fleur(petal_col,petal_len,petal_opening, petal_num, centre_col) 
          scale (2.5+rand(r1)/2)      
          rotate z*-beta
          rotate y*-alfa 
          translate v1
         }


#end

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#macro twig(v0, v1, v_final_dir, alfa_max, rayon, level, branch_len, 
            leaf_scaling, rot_angle, init_angle, curr_pos,
             petal_col, petal_len, petal_opening, petal_num, centre_col)   

   #local v2 = vnormalize(v1-v0)*branch_len + v0;
   cylinder {v0, v2, rayon pigment {my_green*0.5}}


          #local ra=rot_angle;  
          #local leaf_scaling1=leaf_scaling*0.85*(1+0.21*rand(r1)); 
          #local curr_pos1=curr_pos;   
          
          
  
   #local rayon1=rayon*.96;  
   #local level1=level+1;  
   #local branch_len1=.96*branch_len;
  
   #local v3=vnormalize(v1-v0)*branch_len1;   
   #local rc = branch_len1*tan(radians(alfa_max)*rand(r1));
   #local v4 = vnormalize(<-v3.y, v3.x, 0.00>)*rc;     
   #local v5 = v4+v3 + v2;
  
   
   #local v6 = vnormalize(v_final_dir);
   #local v7 = vnormalize(v3+v4);
   #local alfa_max1 = alfa_max;  
   //#if (abs(alfa_max) > 0) 
     #if (sqrt((v7.x-v6.x)*(v7.x-v6.x) +(v7.y-v6.y)*(v7.y-v6.y)) < 0.1)
       #local alfa_max1 = alfa_max+3;  
     #end              
   //#end  
   
   #if (level1<10+rand(r1)*4)  
     twig(v2, v5, v_final_dir, alfa_max1, rayon1, level1, 
          branch_len1, leaf_scaling1, ra, init_angle, curr_pos1
          , petal_col, petal_len, petal_opening, petal_num, centre_col)  
   #else
     #local curr_pos1=6; 
     flower(v5, petal_col, petal_len, petal_opening, petal_num, centre_col)      
   #end
#end

//*****************************************************


//,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,

#declare v_final_dir=<2.5,3,0>; 



#macro branch1(alfa, stem_thick, stem_len, petal_col, petal_len, petal_opening, petal_num, centre_col)
  union
{ 
#local x0 = rand(r1)*20;
#local v0=<x0,0,0>;
#local v1=<x0,6,0>; 
twig(v0, v1, v_final_dir, alfa,  stem_thick, 0, stem_len, 1, 2, 25-rand(r1)*50, 0,
     petal_col, petal_len, petal_opening, petal_num, centre_col)    
}  
        
#end

#macro des_fleurs(num_flowers, stem_thick, stem_len, 
                  petal_col, petal_len, petal_opening, petal_num, centre_col)

union
{
  #declare i=0;  
  #declare n=num_flowers;
  #while (i<n)    
    #if (rand(r1)>0.5)       
      #declare alfa = -(4+rand(r1)*8); 
    #else
      #declare alfa = -(1+rand(r1)*2); 
    #end
    object {branch1(alfa, stem_thick, stem_len, petal_col, petal_len, 
                    petal_opening, petal_num, centre_col)    
            pigment {my_green}  
            scale .1 rotate y*(i*360/n+rand(r1)*15)}  
    #declare i=i+1;
  #end
} 
#end       


//object {des_fleurs(5, .5, 4, White, 2, 50, 24, Gold) }    

