#declare holes_on=on;     
#declare big_holes=on;
#declare small_radius=0.006;
         
         
#declare chair= union
{  
  #declare dist=0;
  // bottom
  #declare wd=0.2;
  #declare dp=0.2;
  #declare ht=0.5;

#if (big_holes)            
  #declare ds=0.04; 
  #declare dw=2*(wd-small_radius-ds);
  #declare cube_w=0.025;
  #declare cw=cube_w*1.4142;
  #declare gap=(dw-5*2*cw)/4;
#else
  #declare ds=0.01; 
  #declare dw=2*(wd-small_radius-ds);
  #declare cube_w=0.012;
  #declare cw=cube_w*1.4142;
  #declare gap=(dw-15*2*cw)/14;
#end                          

#declare my_cube = box {<-cube_w/2,ht-.03,-cube_w/2>,<cube_w/2,ht+.03,cube_w/2> rotate y*45}


#declare my_clip =
box {<-(wd-small_radius-ds/2),ht-small_radius,-(wd-small_radius-ds/2)>, 
<(wd-small_radius-ds/2),ht+small_radius,(wd-small_radius-ds/2)>}

#if (holes_on)
#declare holes = union
{
  #declare dx=-(wd-small_radius-ds)-cw-gap;
  #declare dy=-(wd-small_radius-ds)-cw-gap;
  #while (dx < wd-small_radius-ds+cw)  
    #while (dy < wd-small_radius-ds+cw)
       object {my_cube translate <dx,0,dy>} 
       #declare dy=dy+cw*2+gap;  
    #end  
    #declare dy=-(wd-small_radius-ds)-cw-gap; 
    #declare dx=dx+cw*2+gap;
  #end

  #declare dx=-(wd-small_radius-ds)-gap/2;
  #declare dy=-(wd-small_radius-ds)-gap/2;
  #while (dx < wd-small_radius-ds)  
    #while (dy < wd-small_radius-ds)
       object {my_cube translate <dx,0,dy>} 
       #declare dy=dy+cw*2+gap;  
    #end  
    #declare dy=-(wd-small_radius-ds)-gap/2; 
    #declare dx=dx+cw*2+gap;
  #end
}    
#end 

#declare my_frame = difference
{
    box {<-wd,ht-small_radius/10,-dp>, <wd,ht+small_radius/10,dp>}     
    object {my_clip}
}
  
#declare seat = union
{
difference
{
  union 
  {
    cylinder {<-wd,ht,-dp>,<wd,ht,-dp> small_radius}
    cylinder {<wd,ht,-dp>,<wd,ht,dp> small_radius}
    cylinder {<wd,ht,dp>,<-wd,ht,dp> small_radius}
    cylinder {<-wd,ht,-dp>,<-wd,ht,dp> small_radius}  
   
    box {<-wd,ht-small_radius/10,-dp>, <wd,ht+small_radius/10,dp>}     
  } 
  
  #if (holes_on)
object {holes} 
  #end
}  
//object {my_frame}
}


object {seat} 
  
  // back ------------------------------------------------------------
  #declare hb=0.4;
  #declare cyl_rad=1;         
  #declare valfa=<0,0,0>;
  #declare v2 = <0,ht,-dp>;
  #declare v3 = <0,ht+hb,-dp*1.3>;
  #declare v1=v3-v2;
  #declare alfa =90;
  Get_vector_at_angle_alfa(v1, alfa, valfa) 
  #declare beta=degrees(acos(v1.y/vlength(v1)));





#declare my_cube = box {<-cube_w/2,-cube_w/2,-2>,<cube_w/2,cube_w/2,2>  rotate z*45 
//pigment {color rgbft <1,0,0,0., 0.6>}
}   

#if (holes_on)

#declare holes2 = union
{
  #declare dx=-(wd-small_radius-ds)-cw-gap;
  #declare dy=ht+hb-small_radius-ds-cw-gap+cw/2+gap/3;
  #while (dx < wd-small_radius-ds+cw)  
    #while (dy > ht+hb/2) 
       //#declare beta=dx/rayon;
       object {my_cube 
       //rotate y*degrees(beta) 
       translate <dx,dy,-dp>} 
       #declare dy=dy-cw*2-gap;  
    #end  
    #declare dy=ht+hb-small_radius-ds-cw-gap+cw/2+gap/3; 
    #declare dx=dx+cw*2+gap;
  #end

  #declare dx=-(wd-small_radius-ds)-gap/2;
  #declare dy=ht+hb-small_radius-ds-gap/2+cw/2+gap/3;
  #while (dx < wd-small_radius-ds)  
    #while (dy > ht+hb/2)
       object {my_cube  
       //rotate y*degrees(beta)
       translate <dx,dy,-dp>} 
       #declare dy=dy-cw*2-gap;  
    #end  
    #declare dy=ht+hb-small_radius-ds-gap/2+cw/2+gap/3;
    #declare dx=dx+cw*2+gap;
  #end         
}     

#end




#declare my_clip_box = box {<-wd,ht+hb/2,-.9>, <wd,ht+hb+0.005,-0.08> }

#declare back11 = 
intersection
{   
difference
{
cylinder {<0,ht,-dp>,<0,ht+hb,-dp> cyl_rad 
translate (cyl_rad-2*small_radius)*vnormalize(valfa)
} 
cylinder {<0,ht*0.9,-dp>,<0,(ht+hb)*1.1,-dp> cyl_rad 
translate (cyl_rad-2*small_radius)*vnormalize(valfa)  
scale 1.01
translate z*0.003
}                
}
object {my_clip_box }
translate z*-0.025
}   

  difference
  {
  object {back11   translate y*-(ht+hb/2)  rotate x*-beta    translate y*(ht+hb/2+0.03)}                
  #if (holes_on)
object {holes2} 
  #end
  }
  cylinder {<-wd,ht,-dp>,<-wd*1.0,ht+hb*1.0,-dp*1.3> small_radius}
  cylinder {<wd,ht,-dp>,<wd*1.0,ht+hb*1.0,-dp*1.3> small_radius}
  object {arc1(1, small_radius, .41, dist) 
          translate z*-dist
          rotate x*180 
          translate <0,ht+hb,-dp*1.29>
         }
  object {arc1(1, small_radius, .43, dist) 
          translate z*-dist
          rotate x*180 
          translate <0,ht+hb/2,-dp*1.1>
         }     
                  
  // back feet
  //left
  object {arc1(1, small_radius, .2, dist) 
          translate z*-dist
          rotate z*-90 
          rotate x*10 
          translate <-wd,ht-0.1,-dp-0.020>
         }   
  object {arc1(10, small_radius, ht-.2, dist) 
          translate z*-dist
          rotate z*-90 
          rotate x*15 
          translate <-wd,ht-.2-0.1,-dp-0.06315>
         }   
  //right
  object {arc1(1, small_radius, .2, dist) 
          translate z*-dist
          rotate z*-90 
          rotate x*10 
          translate <wd,ht-0.1,-dp-0.020>
         }   
  object {arc1(10, small_radius, ht-.2, dist) 
          translate z*-dist
          rotate z*-90 
          rotate x*15 
          translate <wd,ht-.2-0.1,-dp-0.06315>
         }      
         
  // front feet
  cylinder {<-wd,0,dp*1.1>,<-wd,ht,dp> small_radius}
  cylinder {<wd,0,dp*1.1>,<wd,ht,dp> small_radius}


  // 2 half-circles under the seat
  //cylinder {<-wd,ht/2,-dp-0.05>,<-wd+.006,ht/2,-dp+0.11> small_radius*0.65}
/*  object {arc1(0.5, small_radius*0.45, 0.16, dist) 
          translate z*-dist  
          rotate y*-85
          translate <-wd,ht/2,-dp+0.03>   
         }   
  object {arc1(0.2, small_radius*0.45, 0.38, dist) 
          translate z*-dist
          translate <0,ht/2,-dp+0.1>
         }   
  object {arc1(0.5, small_radius*0.45, 0.16, dist) 
          translate z*-dist  
          rotate y*85
          translate <wd,ht/2,-dp+0.03>      
         }   
          
  // front one        
  object {arc1(0.5, small_radius*0.45, 0.11, dist) 
          translate z*-dist   
          rotate y*-95
          translate <-wd,ht/2,dp-0.04>         
         }   
  object {arc1(0.2, small_radius*0.45, 0.38, dist) 
          translate z*-dist    
          rotate x*180 
          translate <0,ht/2,dp-0.1>
         }   
  object {arc1(0.5, small_radius*0.45, 0.11, dist) 
          translate z*-dist  
          rotate y*95
          translate <wd,ht/2,dp-0.04>        
         }   
  */

// arm_rests  
  // right side 
  
  #declare arm_rest = union
  {
  object {arc1(0.08, small_radius, 0.07, dist) 
          translate z*-dist  
          rotate y*129
          translate <wd+0.029,ht+hb/2,-dp+0.005>       
          //pigment {Green}  
         }   
  object {arc1(2, small_radius, 0.3, dist) 
          translate z*-dist  
          rotate y*90
          translate <wd+0.051,ht+hb/2,-dp+0.175>       
          //pigment {Red}  
         }   
  object {arc1(0.08, small_radius, 0.07, dist) 
          translate z*-dist  
          rotate y*65       
          rotate z*87.85
          translate <wd+0.051,ht+hb/2-0.0155,-dp+0.045+0.3>       
          //pigment {Green}  
         }      
  cylinder {<wd+0.051,ht+hb/2-0.01,-dp+0.045+0.3>,
            <wd+0.051,ht+hb/2-0.0155-0.12,-dp+0.045+0.3> small_radius*0.75}
  object {arc1(0.08, small_radius*0.75, 0.05, dist) 
          translate z*-dist  
          rotate z*(-90)
          rotate x*(30)
          rotate y*90
          translate <wd+0.038,ht+hb/2-0.0155-0.12-0.0175,-dp+0.045+0.3>       
          //pigment {Green}  
         }   
  object {arc1(0.08, small_radius*0.75, 0.04, dist) 
          translate z*-dist  
          rotate z*(-90) 
          rotate x*(-40)
          rotate y*90
          scale <-1,1,1>
          translate <wd+0.038-0.022,ht+hb/2-0.153-.035,-dp+0.045+0.3>       
          //pigment {Red}  
         }   
  }
  
  object {arm_rest}  
  object {arm_rest scale <-1,1,1>}  

}




object {chair 
rotate y*(15+60)
translate <-6.0,-0.03,-4.0> + <.2,0, -0.4+.25> 
texture {pigment {Gray50} finish {specular 0.25 roughness 0.15}} 
}  
         
object {chair 
rotate y*-60
translate <-5.1+.2,-0.03,-4.3-.08> + <-0.1,0,-0.1> 
texture {pigment {Gray50} finish {specular 0.25 roughness 0.15}} 
}