#macro Get_height_of_arc(big_rad, small_rad, len, dist) 
    #if (len > 0 & len < 2*big_rad & big_rad>small_rad)
      #local len2=len/2;  
      #local min_big_rad=big_rad-small_rad;
      #local h=sqrt(min_big_rad*min_big_rad-len2*len2);
      #if (h>0)  
        #declare dist=h+small_rad;
      #end
     #end
#end


//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#macro arc1(big_rad, small_rad, len, dist) 
// Creates an arc with the following properties:
//   . it is located in the (x,z) plane of pov-ray'S left handed coord. system
//   . the secant is on the x-axis with its end points symmetrically located  
//     around the origin
//   . it is generated by clipping a torus with major radius = big_rad and minor radius
//     = small_rad (see pov-ray doc) 
//   . the clipping is done so that the length of the secant is = len
    #if (len > 0 & len < 2*big_rad & big_rad>small_rad)
      #local len2=len/2;  
      #local min_big_rad=big_rad-small_rad;
      #local h=sqrt(min_big_rad*min_big_rad-len2*len2);
      #if (h>0)  
        #declare dist=h+small_rad;
        difference
        {
          torus {big_rad, small_rad}  
          union
          {               
            box {<-(big_rad+small_rad)*1.1,-small_rad*1.1,-(big_rad+small_rad)*1.1>,
                 <(big_rad+small_rad)*1.1,small_rad*1.1,h>}      
            
            box {<0,-small_rad*1.1,0>, 
                 <(big_rad+small_rad)*1.1,small_rad*1.1,-(big_rad+small_rad)*1.1>   
                 rotate y*degrees(-atan2(h,len2))
                 }      

            box {<0,-small_rad*1.1,0>, 
                 <-(big_rad+small_rad)*1.1,small_rad*1.1,-(big_rad+small_rad)*1.1>   
                 rotate y*degrees(atan2(h,len2))
                 }      
          }
          //translate z*-(h+small_rad)
        }
      #end
    #end
   
    #if (len >= 2*big_rad)
        #local len=big_rad*2;
        difference
        {
          torus {big_rad, small_rad}  
            box {<-(big_rad+small_rad)*1.1,-small_rad*1.1,-(big_rad+small_rad)*1.1>,
                 <(big_rad+small_rad)*1.1,small_rad*1.1,0>}      
        }

     #end
  #end 
                                                                     
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#macro Get_end_point_of_arc(big_rad, small_rad, len, xr, zr, alfa)
    #if (len > 0 & len < 2*big_rad & big_rad>small_rad)
      #local len2=len/2;  
      #local min_big_rad=big_rad-small_rad;    
      #if (min_big_rad > len2)
        #local h=sqrt(min_big_rad*min_big_rad-len2*len2);   
      #else
        #local h=0;
      #end
    #end
    
    #if (len >= 2*big_rad)
        #local len=big_rad*2;
        #local min_big_rad=big_rad-small_rad; 
        #local h=0;
     #end   
    
     #declare or = 1 + small_rad/min_big_rad;
     #declare xr = len2 * or;
     #declare zr = h * or;    
     #local alfa=degrees(atan2(zr,xr));
#end
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#macro arc_with_round_section(big_rad, small_rad, len) 
// Creates an arc with the following properties:
//   . it is located in the (x,z) plane of pov-ray'S left handed coord. system
//   . the secant is parallel to the x-axis with its end points symmetrically located  
//     around the z_axis
//   . it is generated by clipping a torus with major radius = big_rad and minor radius
//     = small_rad (see pov-ray doc) 
//   . the clipping is done so that the length of the secant is = len
    #if (len > 0 & len < 2*big_rad & big_rad>small_rad)
      #local len2=len/2;  
      #local min_big_rad=big_rad-small_rad;
      #local h=sqrt(min_big_rad*min_big_rad-len2*len2);
      #if (h>0)  
        difference
        {
          torus {big_rad, small_rad}// sturm}  
          union
          {               
            box {<-(big_rad+small_rad)*1.1,-small_rad*1.1,-(big_rad+small_rad)*1.1>,
                 <(big_rad+small_rad)*1.1,small_rad*1.1,h>}      
            
            box {<0,-small_rad*1.1,0>, 
                 <(big_rad+small_rad)*1.1,small_rad*1.1,-(big_rad+small_rad)*1.1>   
                 rotate y*degrees(-atan2(h,len2))
                 }      

            box {<0,-small_rad*1.1,0>, 
                 <-(big_rad+small_rad)*1.1,small_rad*1.1,-(big_rad+small_rad)*1.1>   
                 rotate y*degrees(atan2(h,len2))
                 }      
          }
        }
      #end
    #end
   
    #if (len >= 2*big_rad)
        #local len=big_rad*2;
        difference
        {
          torus {big_rad, small_rad}  
            box {<-(big_rad+small_rad)*1.1,-small_rad*1.1,-(big_rad+small_rad)*1.1>,
                 <(big_rad+small_rad)*1.1,small_rad*1.1,0>}      
        }
     #end   
  #end                                   
  
  
//::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#macro Get_rotation_angle_for_next_arc(xr1,zr1,xr2,zr2,gama)
   #local alfa1=degrees(atan2(zr1,xr1));
   #local alfa2=degrees(atan2(zr2,xr2));
   #declare gama=180-alfa1-alfa2;
#end 


//::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
//..........................................

#macro connect_2d_arcs(n, secant_length, major_radius, small_radius, first_point, last_point)
  #declare pipe = union
  {                      
    #local total_rotation=0;
    #local xr=0;
    #local zr=0;  
    #local alfa=0;
    Get_end_point_of_arc(major_radius[0], small_radius, secant_length[0], xr, zr, alfa) 
    #declare v1=<xr,0,zr>;
    object {arc_with_round_section(major_radius[0], small_radius, secant_length[0])} 
    #local end_point=v1;    
    #local gama=alfa;   
    #declare first_point=<-xr,0,zr>;
  
    #local i=1;
    #while (i<n)            
     Get_end_point_of_arc(major_radius[i], small_radius, secant_length[i], xr, zr, alfa) 
     #local gama=180-gama-alfa; 
     #local total_rotation=total_rotation+gama;
     #local connect_point=vaxis_rotate(<-xr,0,zr>,y,total_rotation);

     #local beta = degrees(atan2(connect_point.x,connect_point.z));
     object {arc_with_round_section(major_radius[i], small_radius, secant_length[i]) 
             rotate y*total_rotation      
             translate end_point-connect_point 
            } 

     #local new_end_point = vaxis_rotate(<xr,0,zr>,y,total_rotation);
     #local new_end_point = new_end_point+ end_point-connect_point;  
     #local end_point = new_end_point;   
 
     #local i=i+1;    
     #local gama=alfa;   
    #end              
  }
  pipe  
    #declare last_point=end_point;
#end
                                                                        
                                                                     
                                                                     