
#include "colors.inc"

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <    -24.288,     -66.883,      13.294>
  direction <        0.0,         0.0,      2.8243> // Aperture is 0.35 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    -10.170,     -23.558,       4.876>
}

//
// *******  L I G H T S *******
//

light_source {   // Light002
  <1.217, 5.549, 8.716>
  color rgb <1.000, 1.000, 0.000>*0.8000
}

light_source {   // Light1
  <-23.011, -18.271, 20.766>
  color rgb <1.000, 1.000, 1.000>*0.9999
}


//
// ********  MATERIALS  *******
//

#include "fort.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#declare BezPtch003 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <-0.068879, -2.010642, 0.196764>, <1.021951, -1.712676, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.107326, 0.000000, -0.214651>, <1.000000, 0.000000, 0.000000>, 
      <-2.003516, 1.000000, 0.017888>, <-1.000000, 1.000000, -0.008944>, <0.063395, 1.031925, 0.017888>, <0.991056, 1.000000, 0.000000>
    }
  }
  material {
    Grass
    scale 0.5
  }
  scale <16.0, 16.0, 5.0>
  translate  <1.470981, -47.750308, 0.0>
}
#declare Group001 = union {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-8.5, -5.5, 10.5>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-6.5, -5.5, 10.5>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-2.5, -5.5, 10.5>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-4.5, -5.5, 10.5>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-0.5, -5.5, 10.5>
  }
  translate  21.0*y
}
#declare BezPtch002 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <0.976439, -2.170266, 0.008915>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-1.947361, 0.733959, 1.105520>, <-0.346874, 0.744601, 0.196141>, <0.018970, 0.765884, 1.069858>, <1.076502, 0.733959, 0.891549>
    }
  }
  material {
    Grass scale 0.5
  }
  scale <16.0, 16.0, 5.0>
  translate  <1.056617, 48.943383, 0.0>
}
#declare BezPtch001 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.957433, -2.010642, 0.000000>, <-0.957433, -2.010642, 0.000000>, <0.042567, -2.010642, 0.000000>, <1.042567, -2.010642, 0.000000>, 
      <-1.957433, -1.010642, 0.000000>, <-1.310141, -1.000000, -1.038610>, <0.042567, -1.010642, 0.000000>, <1.042567, -1.010642, 0.000000>, 
      <-1.957433, -0.010642, 0.000000>, <-1.036117, -0.018386, -0.009273>, <0.042888, 0.045419, -0.004294>, <1.042567, -0.010642, 0.000000>, 
      <-1.957433, 0.989358, 0.000000>, <-0.957433, 0.989358, 0.000000>, <0.042567, 0.989358, 0.000000>, <1.042567, 1.090831, 0.000000>
    }
  }
  material {
    Grass scale 0.5
  }
  scale <16.0, 16.0, 5.0>
  translate  <0.513726, 0.513726, 0.0>
}
#declare CSG001 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 6.0>
    material {
      RoughStone_1
      // Transform to parent space
    }
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 20.0>
    rotate -90.0*y
    translate  <8.0, 5.0, 1.5>
    material {
      RoughStone_1
      // Transform to parent space
    }
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 9.0, 5.0>
    material {
      RoughStone_1
      // Transform to parent space
    }
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 3.01>
    translate  <-9.0, -4.0, -2.0>
    material {
      RoughStone_1
      // Transform to parent space
    }
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 3.0>
    rotate -90.0*y
    translate  <-8.0, -4.0, 0.5>
    material {
      RoughStone_1
      // Transform to parent space
    }
  }
}
#declare CSG002 = union {
  object { CSG001 }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.7, 4.0>
    translate  <-9.5, -2.5, -1.0>
    material {
      Planche
      // Transform to parent space
    }
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.7, 4.0>
    translate  <-9.5, -4.0, -1.0>
    material {
      Planche
      // Transform to parent space
    }
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.7, 4.0>
    translate  <-9.5, -5.5, -1.0>
    material {
      Planche
      // Transform to parent space
    }
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 0.35>
    translate  <-9.7, -4.0, -2.0>
    material {
      Planche_1
      // Transform to parent space
    }
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 3.5>
    translate  <-9.5, 5.0, -0.4>
    material {
      Chrome_Metal
      // Transform to parent space
    }
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 3.5>
    translate  <-9.5, 6.0, -0.4>
    material {
      Chrome_Metal
      // Transform to parent space
    }
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 3.5>
    translate  <-9.5, 4.0, -0.4>
    material {
      Chrome_Metal
      // Transform to parent space
    }
  }
  rotate 90.0*z
  translate  <1.33446, 5.548545, 4.916432>
}
#declare Group002 = union {
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-8.5, -5.5, 10.5>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-6.5, -5.5, 10.5>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-2.5, -5.5, 10.5>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-4.5, -5.5, 10.5>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-0.5, -5.5, 10.5>
  }
  translate  <10.0, 21.0, 0.0>
}
union { // Group003
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      Planche
    }
    scale <1.0, 1.0, 22.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <11.0, 15.5, 10.5>
  }
  object { BezPtch003 }
  object { Group001 }

  

union {
#declare LeaveSize = 1.5    //1-2
#declare LeaveText = 1      //1 or 2
#declare Value1 = 4         //Split Branches (1-6) Default = 5
#declare Value2 = 3         //Split Leaves         Default = 5
#include "c:\povray\plugins\tree01\tree01.inc"
object { TREE rotate <90,0,0> }  
translate <-15,0,0> 
}
  


union {
#declare LeaveSize = 1.1 ;   //1-2
#declare LeaveText = 2 ;     //1 or 2
#declare Value1 = 6 ;        //Split Branches (1-6) Default = 5
#declare Value2 = 8 ;        //Split Leaves         Default = 5
#include "c:\povray\plugins\tree01\tree01.inc"
object { TREE  rotate x *90}
translate <0, -20, 0>
}
  


#include "blob_man.inc"
#include "patrick.pos"
#include "patrick.cdf"
#declare Hair=0 ;

Blob_Man(0,0.7,1,<.75,1,1>,0,0,1*Hair,<.5,.5,.5>,0,0)

union {
object {
    BlobMan 
    scale .1  
    rotate <90,0,-45>
}     translate <-10,-20,5>
}


#include "blob_man.inc"
#include "couper.pos"
#include "couper.cdf"
#declare Hair=0 ;

Blob_Man(0,0.7,1,<.75,1,1>,0,0,1*Hair,<.5,.5,.5>,0,0)

union {
object {
    BlobMan 
    scale .1  
    rotate <20,0,0>
}     translate <-3,-20,1>
}




  

  object { BezPtch002 }
  sphere { // Lune
    <0,0,0>,1
    scale 2.0
    translate  <-22.251382, -4.659234, 23.113742>
    material {
      Asteroid_1
      // Transform to parent space
    }
  }         
  
disc { <0,0,0>, <0,0,1>, 1.0 texture { pigment {rgbf <.3,.6,1,.5>  } 
normal {bumps 2
scale .1}  } interior {ior 1.5} 
scale <10.0, 10.0, 1.0>
translate  <-17.751823, -19.623666, -0.757>

} 

/*  disc { // Disc001
    <0,0,0>, <0,0,1>, 1.0
    material {
      Eau
    }
    scale <10.0, 10.0, 1.0>
    translate  <-17.751823, -19.623666, -0.757>
  }
*/  
  object { BezPtch001 }
  object { CSG002 }
  object { Group002 }
}



box
{
  <-30, -50, 0>  // one corner position <X1 Y1 Z1>
  <20,  50,  2>  // other corner position <X2 Y2 Z2>
  pigment {rgbt <1,1,1,1>}
  
interior {
        media {
      emission .1
      intervals 10
      samples 1, 1
      confidence 0.5
      variance 1/128
     density { gradient z

              turbulence 0.5
                         
               } /// end den  
     }
     }                       

  hollow yes   

}

box
{
  <-30, -50, 2>  // one corner position <X1 Y1 Z1>
  <20,  50,  3>  // other corner position <X2 Y2 Z2>
  pigment {rgbt <1,1,1,1>}
  
interior {
        media {
      emission .07
      intervals 10
      samples 1, 1
      confidence 0.5
      variance 1/128
     density { gradient z

              turbulence 0.5
                         
               } /// end den  
     }
     }                       

  hollow yes   

}



box
{
  <-30, -50, 3>  // one corner position <X1 Y1 Z1>
  <20,  50,  50>  // other corner position <X2 Y2 Z2>
  pigment {rgbt <1,1,1,1>}
  
interior {
        media {
      emission .006
      intervals 10
      samples 1, 1
      confidence 0.5
      variance 1/128
     density { gradient z

              turbulence 0.5
                         
               } /// end den  
     }
     }                       

  hollow yes   

}
  