/***************************************************************
Blob Man Studio v3.0                                06 July 1999
====================
by Peter Houston <houston.graphics@iname.com>
                < http://welcome.to/HoustonGraphics >
based on Blob Man model by Govert Zoethout <zoethout@gmx.net>
                < http://victorian.fortunecity.com/dada/507/ >

Refer to blob_man.txt for full usage details

Requires blob_man.inc v3.0
****************************************************************

 B L O B   M A N   S A M P L E   P O S E S

Set Pose_Studio to 'no' to see pre-defined poses set PoseNo 
for the pose you wish to try.

 PoseNo                             PoseNo
   0 = Standing Relaxed               5 = Praying on Knees
   1 = Standing Hands on Hips         6 = "We're Not Worthy"
   2 = Meditation                     7 = Hand Stand
   3 = Sitting at Table/Piano etc     8 = Sun Bathing
   4 = Gunfighter                     9 = Surfer

If you wish to experiment with Blob Man Studio (below) set 
Pose_Studio to 'yes'.
****************************************************************/
#declare Pose_Studio=yes;
#declare PoseNo=0;

/****************************************************************
 General Settings used for Pose Studio and Pre-Defined Poses
*****************************************************************/
#declare Build      = 0.7;           // Blob Threshold (Low=Fat, High=Thin)
#declare Skin       = <.9,.7,.6>;    // Skin Pigment Colour
#declare Eye_Colour = <.6,.4,.1>; // Iris Colour of eye (<r,g,b>) - ie. <.22,.69,.87> = Blue
#declare Face_Map   = 0;             // Image map used for face (0-5)
#declare Right_Lid  = 0.1;             // Right Eye Lid Position  (range : 0-Open to 1-Closed) - standard: 0
#declare Left_Lid   = 0.1;             // Left Eye Lid Position  (range : 0-Open to 1-Closed) - standard: 0
#declare Hair       = 1;             // 0 = No Hair   1 = Hair *** For Pre-Defined Poses Only ***
#declare Hair_Col   = <0.05, 0.05, 0.05>;    // Hair Colour <r,g,b>
//#declare Costume    = "sample.cdf"   // Name of Costume Definition File eg. "sample.cdf"
                                     // Comment Out if you want to use defaults
#declare Background = <.5,.5,.5>;        // <r,g,b> of for Studio Background.

#declare DeBug      = off;           // Puts Visible Locators at ends of Limbs
                                     // useful for object positioning.

/****************************************************************

 B L O B   M A N   S T U D I O

Change the settings below to create your own poses.

****************************************************************/

#include "blob_man.inc"

#if (Pose_Studio=yes)
/****************************************************************
 Head Settings
*****************************************************************/
#declare Eye_Rot    = 0;             // Eye Rotation Angle left-right - standard: 0
#declare Lip_Size   = 0;             // Mouth/Lip Size (range: -0.5 to 0.5 ) - standard: 0  
#declare Head_Twist = 0;             // Head rotation Left(-) to Right(+) (range: -85 to 85) - standard: 0
#declare Head_Tip   = 0;             // Head position Front to Back (range: -15 to 50) - standard: 0
#declare Head_Tilt  = 0;             // Head position Right Side to Left Side  (range: -25 to 25) - standard: 0
                               
/****************************************************************
 Torso Settings
   Arm Rotation Vectors <X,Y,Z> 
   <0,0,0> is pointing straight down
   X= Back(-) to Front(+)
   Y= Twist Left(-), Right (+)
   Z= Side to Side Lift Right(-), Left(+)
*****************************************************************/
#declare RA_S2E= <20, 23, -10>;  // Right Arm Shoulder to Elbow rotation vector
#declare RA_E2W= <55,-05,-25>;  // Right Arm Elbow to Wrist rotation vector
#declare LA_S2E= <20,-23,  10>;  // Left Arm Shoulder to Elbow rotation vector
#declare LA_E2W= <55,  5, 25>;  // Left Arm Elbow to Wrist rotation vector
#declare RL_H2K= <58,0,0>;  // Right Leg Hip to Knee rotation vector
#declare RL_K2A= <33,0,0>;  // Right Leg Knee to Ankle rotation vector
#declare LL_H2K= <58,0,0>;  // Left Leg Hip to Knee rotation vector    
#declare LL_K2A= <35,0,0>;  // Left Leg Knee to Ankle rotation vector
               
/****************************************************************
 Hand Settings
   Hand Rotation Vectors <X,Y,Z>
   <0,0,0> - fingers pointing down with thumbs foward.
*****************************************************************/
// Right Hand
#declare RH_Rot     = <0,0,0>;  // Right Hand Rotation Vector
#declare RF_Spread  = 0.5;        // Finger Spread    - 0 = Closed   , 1 = Relaxed , 2 = Wide
#declare RFP_Pos    = 1.5;        // Pinky Position   - 0 = Straight , 1 = Relaxed , 2 = Curled
#declare RFR_Pos    = 1.5;        // Ring Position    - 0 = Straight , 1 = Relaxed , 2 = Curled
#declare RFM_Pos    = 1.5;        // Middle Position  - 0 = Straight , 1 = Relaxed , 2 = Curled
#declare RFI_Pos    = 1.3;        // Index Position   - 0 = Straight , 1 = Relaxed , 2 = Curled
#declare RFT_Pos    = 1.5;        // Thumb Position   - 0 = Straight , 1 = Relaxed , 2 = Curled

// Left Hand
#declare LH_Rot     = <0,0,0>;  // Left Hand Rotation Vector
#declare LF_Spread  = 0.4;        // Finger Spread    - 0 = Closed   , 1 = Relaxed , 2 = Wide
#declare LFP_Pos    = 1.5;        // Pinky Position   - 0 = Straight , 1 = Relaxed , 2 = Curled
#declare LFR_Pos    = 1.4;        // Ring Position    - 0 = Straight , 1 = Relaxed , 2 = Curled
#declare LFM_Pos    = 1.4;        // Middle Position  - 0 = Straight , 1 = Relaxed , 2 = Curled
#declare LFI_Pos    = 1.4;        // Index Position   - 0 = Straight , 1 = Relaxed , 2 = Curled
#declare LFT_Pos    = 1;        // Thumb Position   - 0 = Straight , 1 = Relaxed , 2 = Curled

/****************************************************************
 Foot Settings
   Foot Rotation Vectors <X,Y,Z>
   <0,0,0> - toes pointing forward
*****************************************************************/
#declare RF_Rot= <-20,30,0>;  // Right Foot Rotation Vector
#declare LF_Rot= <-15,-30,00>;  // Left Foot Rotation Vector

/****************************************************************
 Hair Settings     
   Note: Hair drastically increases the parse time !
*****************************************************************/
#declare Hair_On    = Hair;          // Hair (1) - No Hair (0)
#declare Hair_Rot   = <0,0,0>;    // Hair Rotation - Standard <0,0,0>
#declare Hair_Arch  = 0;          // Arch hairline over head in line with ears (1) or Not (0)
#declare Hair_Thck  = 0.5;       // Hair Thickness <0.15 to 0.5> - Standard: 0.25
#declare Hair_Line  = 5;          // Hair Line Height (Best Settings 3 to 6) - Standard: 5 
#declare Hair_LDpth = 0.9;        // Hairline profile Depth (Range: 0-Straight Fringe to 1-Widows Peak) - standard: 0.7
#declare Hair_Wght  = 0.01;       // Hair Weight (Range 0.005 to 0.05) - Standard: 0.01
#declare Hair_Hght  = 1;          // Hair Height (Range 1 to 2) - Standard: 1
#declare Hair_Length= 8;         // Hair Length (1 to 20) - Standard: 10
#declare Hair_Curl  = 0.02;       // Curliness (Range 0-Straight to 0.1-Curly) - Standard: 0.05

/****************************************************************
*****************************************************************

*****************************************************************
 Write settings to external file.
*****************************************************************/
#fopen file "sunning_vampire.pos" write
    #write (file, "/************************************************************\n",
                  "  Blob Man Pose File for use with Blob_Man.inc\n",
                  "  This file was created automatically by Blob_Man_Studio.POV\n",
                  "*************************************************************/\n\n")  
    #write (file, "#declare Pose_1=array[1][12]\n",
                  "  {\n",
                  "     { ",RA_S2E,",",RA_E2W,",",LA_S2E,",",LA_E2W,",",RL_H2K,",",RL_K2A,",",LL_H2K,",",LL_K2A,",",RH_Rot,",",LH_Rot,",",RF_Rot,",",LF_Rot," },\n",
                  "  }\n\n")
    #write (file, "#declare Pose_2=array[1][7]\n",
                  "  {\n",
                  "     { ",Eye_Rot,",",Lip_Size,",",Head_Twist,",",Head_Tip,",",Head_Tilt,",0,1 },\n",
                  "  }\n\n")
    #write (file, "#declare Pose_Hair_1=array[1][1]\n",
                  "  {\n",
                  "     { ",Hair_Rot," },\n",
                  "  }\n\n")
    #write (file, "#declare Pose_Hair_2=array[1][9]\n",
                  "  {\n",
                  "     { ",Hair_On,",",Hair_Arch,",",Hair_Thck,",",Hair_Line,",",Hair_LDpth,",",Hair_Wght,",",Hair_Hght,",",Hair_Length,",",Hair_Curl," },\n",
                  "  }\n\n")
    #write (file, "#declare Pose_Hands=array[2][6]\n",
                  "  {\n",
                  "     { ",RF_Spread,",",RFP_Pos,",",RFR_Pos,",",RFM_Pos,",",RFI_Pos,",",RFT_Pos," },\n",
                  "     { ",LF_Spread,",",LFP_Pos,",",LFR_Pos,",",LFM_Pos,",",LFI_Pos,",",LFT_Pos," },\n",
                  "  }\n")
#fclose file

#ifdef (Costume)
    #include Costume
#end


#ifndef (Skin_Tex)
#declare Skin_Tex = 
    texture {
        pigment {rgb Skin}
        finish {
            phong .3 phong_size 40
        }
        normal {
            crackle .2 
            turbulence .7 
            scale .7
        }
    }
#end

#declare BlobMan= merge {
    object { head( Build,Eye_Colour,Right_Lid,Left_Lid,Eye_Rot,Lip_Size,Head_Twist,Head_Tip,Head_Tilt,Face_Map ) }
    object {torso( Build,RA_S2E,RA_E2W,LA_S2E,LA_E2W,RL_H2K,RL_K2A,LL_H2K,LL_K2A ) }
    object { hand( Build,LA_S2E,LA_E2W,LH_Rot, 1,LF_Spread, LFP_Pos, LFR_Pos, LFM_Pos, LFI_Pos, LFT_Pos ) } // Left Hand
    object { hand( Build,RA_S2E,RA_E2W,RH_Rot,-1,RF_Spread, RFP_Pos, RFR_Pos, RFM_Pos, RFI_Pos, RFT_Pos ) } // Right Hand
    object { feet( Build,RL_H2K,RL_K2A,LL_H2K,LL_K2A,RF_Rot,LF_Rot ) }
    object { hair( Hair_On,Hair_Rot,Hair_Col,Hair_Arch,Hair_Thck,Hair_Line,Hair_LDpth,Hair_Wght,Hair_Hght,Hair_Length,Hair_Curl,Head_Twist,Head_Tip,Head_Tilt ) }
}

#else
/****************************************************************
 Use Pre-Defined Poses
*****************************************************************/

#include "default.pos"

#ifdef (Costume)
    #include Costume
#end

#ifndef (Skin_Tex)
#declare Skin_Tex = 
    texture {
        pigment {rgb Skin}
        finish {
            phong .3 phong_size 40
        }
        normal {
            crackle .2 
            turbulence .7 
            scale .7
        }
    }
#end

Blob_Man(PoseNo,Build,Face_Map,Eye_Colour,Right_Lid,Left_Lid,1*Hair,Hair_Col,0,0)

#end

/****************************************************************
 Lights, Camera and Setting
*****************************************************************/
camera{location <0,-40,-100> orthographic look_at <0,-40,0> }
light_source{<-200,200,-200> rgb <1,.9,.5> }      
light_source{< 400,400,-200> rgb <.2,.4,.8> shadowless }
light_source{<-200,200,-200> rgb .7         shadowless }
light_source{< 100, 50,-150> rgb .5         shadowless }
light_source{< 100,-50,-150> rgb .3         shadowless }
light_source{<-100,-50,-150> rgb .1         shadowless }
background {rgb Background}
 
/****************************************************************
 The Models
****************************************************************/
object {BlobMan              translate x*-15 no_shadow}
object {BlobMan rotate y*180 translate x* 45 no_shadow}
object {BlobMan rotate y* 90 translate x*-45 no_shadow}
object {BlobMan rotate y*-90 translate x* 15 no_shadow}
object {BlobMan rotate x*-90 translate y*-75 translate x*-15 no_shadow}
object {BlobMan rotate y*180 rotate x*90     translate y*-75 translate x* 45 no_shadow}
text { 
   ttf
   "crystal.ttf",
   #ifdef (Costume)
    concat ("Blob Man v3.0 - ",Costume),
   #else
   "Blob Man v3.0",
   #end
   .1,
   0
   translate <-11.5,1.5,0>
   pigment {rgb 1}
   finish {ambient 1}
   scale 6
}

// EOF