//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 6 materials and 51 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 10/30/1999    (30.10.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows.

*/ // End Scene Comment


// Scene Includes

#include "C:\My Documents\POV\Horror\sunning_vampire.pov"

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <    695.378,   -3185.045,      60.000>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    626.981,     -14.271,    -262.614>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <    640.202,   -2912.454,      42.423>
  direction <        0.0,         0.0,      1.8968> // Aperture is 0.52 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    692.795,   -2858.706,      31.431>
}

*/

/*
camera {  //  Camera CheckChairCamera
  location  <    -51.435,     -61.314,      32.967>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     10.704,       3.129,       9.631>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Sun
  <230128.753, -223572.363, 519679.225>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  MATERIALS  *******
//

#include "beach.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#declare TRRframeCSG = intersection {
  torus { // Torus005
    4.0, 1.0  rotate -x*90
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 1.5>
    translate  <3.0, 3.0, 0.0>
  }
  rotate <-90.0, 90.0, 0.0>
  translate  4.0*x
}
#declare TLRframeCSG = intersection {
  torus { // Torus006
    4.0, 1.0  rotate -x*90
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 1.5>
    translate  <3.0, 3.0, 0.0>
  }
  rotate <90.0, 90.0, 0.0>
  translate  22.0*x
}
#declare BezPtch004 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.563380, -2.000000, -0.751174>, <0.312989, -2.000000, -0.751174>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.563380, -1.000000, -0.751174>, <0.312989, -1.000000, -0.751174>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.563380, 0.000000, -0.751174>, <0.312989, 0.000000, -0.751174>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.563380, 1.000000, -0.751174>, <0.312989, 1.000000, -0.751174>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <8.75, 1.0, 1.0>
  translate  <15.25, 3.0, 2.0>
}
#declare Strap3 = union {
  object { BezPtch004 }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <24.0, 1.0, 1.0>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <-2.0, 1.0, 1.0>
  }
}
#declare BezPtch005 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.563380, -2.000000, -0.751174>, <0.312989, -2.000000, -0.751174>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.563380, -1.000000, -0.751174>, <0.312989, -1.000000, -0.751174>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.563380, 0.000000, -0.751174>, <0.312989, 0.000000, -0.751174>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.563380, 1.000000, -0.751174>, <0.312989, 1.000000, -0.751174>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <8.75, 1.0, 1.0>
  translate  <15.25, 3.0, 2.0>
}
#declare Strap4 = union {
  object { BezPtch005 }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <24.0, 1.0, 1.0>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <-2.0, 1.0, 1.0>
  }
  translate  5.0*y
}
#declare BezPtch006 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.563380, -2.000000, -0.751174>, <0.312989, -2.000000, -0.751174>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.563380, -1.000000, -0.751174>, <0.312989, -1.000000, -0.751174>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.563380, 0.000000, -0.751174>, <0.312989, 0.000000, -0.751174>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.563380, 1.000000, -0.751174>, <0.312989, 1.000000, -0.751174>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <8.75, 1.0, 1.0>
  translate  <15.25, 3.0, 2.0>
}
#declare Strap5 = union {
  object { BezPtch006 }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <24.0, 1.0, 1.0>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <-2.0, 1.0, 1.0>
  }
  translate  10.0*y
}
#declare BackStraping = union {
  object { Strap3 }
  object { Strap4 }
  object { Strap5 }
  material {
    Strapping
  }
  rotate <90.0, 0.0, -180.0>
  translate  <24.0, -1.0, -1.0>
}
#declare RearChairLegs = union {
  cylinder { // TopRearFrCyl
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 18.0>
    rotate 90.0*y
    translate  <4.0, 0.0, -4.0>
  }
  cylinder { // LRlegCylndr
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 22.0>
    translate  26.0*x
  }
  object { TRRframeCSG }
  object { TLRframeCSG }
  cylinder { // RRlegCyl
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 22.0>
  }
  object { BackStraping }
  rotate 165.0*x
  translate  <0.0, 21.5, 17.0>
}
#declare FRseatCorner = intersection {
  torus { // Torus003
    4.0, 1.0  rotate -x*90
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 1.5>
    translate  <3.0, 3.0, 0.0>
  }
  rotate <-90.0, 90.0, 0.0>
  translate  6.0*x
}
#declare FLseatCorner = intersection {
  torus { // Torus004
    4.0, 1.0  rotate -x*90
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 1.5>
    translate  <3.0, 3.0, 0.0>
  }
  rotate <90.0, 90.0, 0.0>
  translate  20.0*x
}
#declare BezPtch001 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.563380, -2.000000, -0.751174>, <0.312989, -2.000000, -0.751174>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.563380, -1.000000, -0.751174>, <0.312989, -1.000000, -0.751174>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.563380, 0.000000, -0.751174>, <0.312989, 0.000000, -0.751174>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.563380, 1.000000, -0.751174>, <0.312989, 1.000000, -0.751174>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <7.25, 1.0, 1.0>
  translate  <16.5, 3.0, 2.0>
}
#declare Strap = union {
  object { BezPtch001 }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <24.0, 1.0, 1.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <2.0, 1.0, 1.0>
  }
}
#declare BezPtch002 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.563380, -2.000000, -0.751174>, <0.312989, -2.000000, -0.751174>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.563380, -1.000000, -0.751174>, <0.312989, -1.000000, -0.751174>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.563380, 0.000000, -0.751174>, <0.312989, 0.000000, -0.751174>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.563380, 1.000000, -0.751174>, <0.312989, 1.000000, -0.751174>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <7.25, 1.0, 1.0>
  translate  <16.5, 3.0, 2.0>
}
#declare Strap1 = union {
  object { BezPtch002 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <24.0, 1.0, 1.0>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <2.0, 1.0, 1.0>
  }
  translate  5.0*y
}
#declare BezPtch003 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.563380, -2.000000, -0.751174>, <0.312989, -2.000000, -0.751174>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.563380, -1.000000, -0.751174>, <0.312989, -1.000000, -0.751174>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.563380, 0.000000, -0.751174>, <0.312989, 0.000000, -0.751174>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.563380, 1.000000, -0.751174>, <0.312989, 1.000000, -0.751174>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <7.25, 1.0, 1.0>
  translate  <16.5, 3.0, 2.0>
}
#declare Strap2 = union {
  object { BezPtch003 }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <24.0, 1.0, 1.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.0, 3.0>
    rotate -90.0*x
    translate  <2.0, 1.0, 1.0>
  }
  translate  10.0*y
}
#declare SeatStraping = union {
  object { Strap }
  object { Strap1 }
  object { Strap2 }
  material {
    Strapping
  }
  rotate 90.0*x
  translate  <0.0, 1.0, -1.0>
}
#declare SeatFrame = union {
  cylinder { // FSeatCyl
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 14.0>
    rotate 90.0*y
    translate  <6.0, 0.0, -4.0>
  }
  cylinder { // LseatCyl
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 18.0>
    translate  24.0*x
  }
  object { FRseatCorner }
  object { FLseatCorner }
  cylinder { // RseatCyl
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 18.0>
    translate  2.0*x
  }
  cylinder { // SeatPivotRod
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 29.0>
    rotate <90.0, -0.0, 90.0>
    translate  <-1.5, -0.0, 16.5>
  }
  object { SeatStraping }
  rotate -90.0*x
  translate  <0.0, 1.0, 1.0>
}
#declare CSG001 = intersection {
  torus { // Torus001
    4.0, 1.0  rotate -x*90
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 1.5>
    translate  <3.0, 3.0, 0.0>
  }
  rotate <-90.0, 90.0, 0.0>
  translate  4.0*x
}
#declare CSG002 = intersection {
  torus { // Torus002
    4.0, 1.0  rotate -x*90
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 1.5>
    translate  <3.0, 3.0, 0.0>
  }
  rotate <90.0, 90.0, 0.0>
  translate  22.0*x
}
#declare FrontChairLegs = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 18.0>
    rotate 90.0*y
    translate  <4.0, 0.0, -4.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 12.0>
    translate  26.0*x
  }
  object { CSG001 }
  object { CSG002 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 12.0>
  }
  rotate -15.0*x
}
#declare ChairFrame = union {
  object { RearChairLegs }
  object { SeatFrame }
  object { FrontChairLegs }
  material {
    Brushed_Aluminum
  }
}
#declare RightChairArm = union {
  cylinder { // ArmFront
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 3.2>
    rotate -90.0*y
    translate  <1.2, -2.5, 11.0>
  }
  box { // ArmTop
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 10.5, 0.2>
    translate  <-0.4, 8.0, 11.8>
  }
  box { // ArmSide
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 12.0, 1.0>
    translate  <1.1, 9.5, 11.0>
  }
  material {
    BumpyWhitePlastic
  }
}
#declare LeftChairArm = union {
  cylinder { // ArmFront1
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 3.2>
    rotate -90.0*y
    translate  <1.2, -2.5, 11.0>
  }
  box { // ArmTop1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 10.5, 0.2>
    translate  <-0.4, 8.0, 11.8>
  }
  box { // ArmSide1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 12.0, 1.0>
    translate  <-1.8, 9.5, 11.0>
  }
  material {
    BumpyWhitePlastic
  }
  translate  26.5*x
}
union { // LawnChair
  object { ChairFrame }
  object { RightChairArm }
  object { LeftChairArm }
  rotate 55.0*z
  translate  <689.0, -2872.0, 24.0>
}


plane { // Cloudy_Sky
  z,0
  material {
    Carribean_Cloud_Sky
  }
  no_shadow
  hollow
  scale 120000.0
  rotate -0.1*x
  translate  12000.0*z
}


plane { // SeaBottom
  z,0
  material {
    Sand
  }
  translate  -120.0*z
}


object {   // BeachHeight
  height_field {
    png "C:\Program Files\Moray For Windows\PovScn\Beach Height.png"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Sand
  }
  scale <3600.0, 900.0, 96.0>
  rotate 90.0*z
  translate  60.0*z
}


plane { // Ocean
  z,0
  material {
    Pacific
  }
  translate  6.0*z
}




