// GENERAL INCLUDES

#include "colors.inc"
#include "stones.inc"
#include "skies.inc"

// TEXTURES
#declare CaveInterior = interior{
  media{ // ground layer mist
    intervals 60
    emission 5.00
    absorption 6.00
    density{
      planar
      turbulence 0.10
      scale <0.25,3,0.25>
      density_map{
        [0.00 Black]
        [0.98 Black]
        [0.98 wrinkles scale 0.05 turbulence 0.50]
        [1.00 wrinkles scale 0.05 turbulence 0.50]
      }
    }
  }  
  media { // general mist
    intervals 60
    emission 0.2
    absorption 0.2
    density{
      agate
      turbulence .25
      scale 0.25 
      color_map{[0 White][0.25 White][0.75 Black][1 Black]}
    }
  }
}

#declare GreenSkin = texture{ // tentacle texture
  pigment{bozo pigment_map{[0 rgb<0.35,0.45,0.35>][1 rgb<0.45,0.65,0.45>]}}
  normal{wrinkles 0.50 scale 0.20 turbulence 0.25}
  finish{
    ambient 0.45
    reflection 0.05
    specular 0.8
    roughness 0.003
    phong 0.25
    phong_size 40
  }
}

// water texture
#declare Watermaterial = material{     
  texture{      
    pigment{color rgbf <0.5, 1.0, 1.0, 0.9>}      
    normal{ripples 0.75}      
    finish{
      ambient 0.1
      reflection 0.3
    }
  }   
  interior{ior 1.33}
  scale <0.1,0.1,0.1>
}

// texture for cave and stalags
#declare Cavetexture = texture{
  T_Stone10
  finish { phong 0.0 ambient 0.4 }
}

// OBJECTS

// stalagmite/tite
#declare Stalag = object{
  height_field{
    png
    "stalag.png"
    smooth
    rotate <0, 0, 180>
    scale <5.0, 3.0, 1.0>
    texture{
      Cavetexture
      scale 0.2
      normal{bumps 0.2}
    }
  }
}

// media container
#declare Cavemediasphere = object{
  sphere{
    <0,-15,5>,
    18
    pigment{color rgbf<1,1,1,1>}
    hollow
    interior{CaveInterior}
  }
}    

// main cave
#declare Cave = object{
  union { // BezPtch001
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <-2.150490, -0.207840, 3.201372>, <-1.914679, -0.215923, 3.203454>, <-0.550000, -0.210127, 3.386403>, <3.277601, -0.210127, 3.500738>, 
        <-2.150490, -0.357647, 3.283034>, <-1.914679, -0.589537, 3.283034>, <-0.738139, -1.102250, 3.694653>, <3.320772, -1.949231, 3.808988>, 
        <-2.150490, -0.278765, 3.783034>, <-1.914679, -0.589537, 3.783034>, <-0.738139, -1.102250, 4.194653>, <3.320772, -1.949231, 4.308988>, 
        <-2.543651, -0.202913, 3.490131>, <-1.914679, -1.032126, 3.502905>, <-0.738139, -1.544839, 3.914524>, <3.252152, -1.952652, 4.028859>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <3.277601, -0.210127, 3.500738>, <7.105203, -0.210127, 3.615073>, <8.241212, -0.215923, 2.852840>, <8.486648, -0.198215, 2.850758>, 
        <3.320772, -1.949231, 3.808988>, <7.379683, -2.796211, 3.923323>, <8.515693, -2.346211, 2.932420>, <8.623888, -1.226360, 2.932420>, 
        <3.320772, -1.949231, 4.308988>, <7.379683, -2.796211, 4.423323>, <8.515693, -2.346211, 3.432420>, <8.623888, -1.147478, 3.432420>, 
        <3.252152, -1.952652, 4.028859>, <7.242443, -2.360464, 4.143194>, <9.234157, -1.910464, 3.152291>, <9.970115, 3.165173, 4.012956>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <8.486648, -0.198215, 2.850758>, <8.732083, -0.180508, 2.848676>, <8.724829, -0.185510, 2.848676>, <3.172891, -0.185510, 3.023983>, 
        <8.623888, -1.226360, 2.932420>, <8.732083, -0.106508, 2.932420>, <8.724829, 0.041106, 2.932420>, <3.172891, 0.041106, 3.107727>, 
        <8.623888, -1.147478, 3.432420>, <8.732083, 0.051256, 3.432420>, <8.724829, 0.337633, 3.432420>, <3.172891, 0.337633, 3.607727>, 
        <9.970115, 3.165173, 4.012956>, <10.706073, 8.240809, 4.873621>, <10.698819, 8.527186, 4.873621>, <3.766725, 4.729556, 4.141023>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <3.172891, -0.185510, 3.023983>, <-2.379046, -0.185510, 3.199290>, <-2.386300, -0.199758, 3.199290>, <-2.150490, -0.207840, 3.201372>, 
        <3.172891, 0.041106, 3.107727>, <-2.379046, 0.041106, 3.283034>, <-2.386300, -0.125757, 3.283034>, <-2.150490, -0.357647, 3.283034>, 
        <3.172891, 0.337633, 3.607727>, <-2.379046, 0.337633, 3.783034>, <-2.386300, 0.032006, 3.783034>, <-2.150490, -0.278765, 3.783034>, 
        <3.766725, 4.729556, 4.141023>, <-3.165369, 0.931926, 3.408425>, <-3.172623, 0.626300, 3.408425>, <-2.543651, -0.202913, 3.490131>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <-2.543651, -0.202913, 3.490131>, <-1.914679, -1.032126, 3.502905>, <-0.738139, -1.544839, 3.914524>, <3.252152, -1.952652, 4.028859>, 
        <-2.936813, -0.127061, 3.128296>, <-1.914679, -1.474716, 3.222776>, <-0.738139, -1.987429, 3.634395>, <3.183532, -1.956072, 3.748730>, 
        <-2.116203, -0.081167, 9.057036>, <-1.188139, -1.832285, 8.387312>, <-0.738139, -2.282285, 8.615982>, <-0.094069, -2.250929, 8.615982>, 
        <-1.665223, -0.305642, 9.743186>, <-1.188139, -1.603616, 8.811089>, <-0.738139, -2.053616, 9.039759>, <-0.094069, -2.022259, 9.039759>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <3.252152, -1.952652, 4.028859>, <7.242443, -2.360464, 4.143194>, <9.234157, -1.910464, 3.152291>, <9.970115, 3.165173, 4.012956>, 
        <3.183532, -1.956072, 3.748730>, <7.105203, -1.924716, 3.863065>, <9.952622, -1.474716, 2.872162>, <11.316342, 7.477823, 4.593492>, 
        <-0.094069, -2.250929, 8.615982>, <0.550000, -2.219573, 8.615982>, <2.985890, -3.526247, 8.387312>, <3.094085, -0.918523, 9.149545>, 
        <-0.094069, -2.022259, 9.039759>, <0.550000, -1.990903, 9.039759>, <2.985890, -3.297577, 8.811089>, <2.666233, -1.142998, 9.789440>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <9.970115, 3.165173, 4.012956>, <10.706073, 8.240809, 4.873621>, <10.698819, 8.527186, 4.873621>, <3.766725, 4.729556, 4.141023>, 
        <11.316342, 7.477823, 4.593492>, <12.680063, 16.430363, 6.314823>, <12.672809, 16.716739, 6.314823>, <4.360558, 9.121480, 4.674319>, 
        <3.094085, -0.918523, 9.149545>, <3.202280, 1.689200, 9.911778>, <3.195026, 1.975577, 9.911778>, <0.079006, 1.975577, 9.819269>, 
        <2.666233, -1.142998, 9.789440>, <2.346575, 1.011582, 10.767791>, <2.339321, 1.297959, 10.767791>, <0.102134, 1.297959, 10.721537>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <3.766725, 4.729556, 4.141023>, <-3.165369, 0.931926, 3.408425>, <-3.172623, 0.626300, 3.408425>, <-2.543651, -0.202913, 3.490131>, 
        <4.360558, 9.121480, 4.674319>, <-3.951693, 1.526220, 3.033816>, <-3.958947, 1.220593, 3.033816>, <-2.936813, -0.127061, 3.128296>, 
        <0.079006, 1.975577, 9.819269>, <-3.037013, 1.975577, 9.726761>, <-3.044267, 1.669951, 9.726761>, <-2.116203, -0.081167, 9.057036>, 
        <0.102134, 1.297959, 10.721537>, <-2.135054, 1.297959, 10.675282>, <-2.142308, 0.992332, 10.675282>, <-1.665223, -0.305642, 9.743186>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <-1.665223, -0.305642, 9.743186>, <-1.188139, -1.603616, 8.811089>, <-0.738139, -2.053616, 9.039759>, <-0.094069, -2.022259, 9.039759>, 
        <-1.214244, -0.530116, 10.429335>, <-1.188139, -1.374946, 9.234865>, <-0.738139, -1.824946, 9.463535>, <-0.094069, -1.793589, 9.463535>, 
        <-1.329880, -0.207687, 13.723717>, <-1.188139, -1.374946, 9.734865>, <-0.738139, -1.824946, 9.963535>, <-0.094069, -1.793589, 9.963535>, 
        <-2.464671, -6.526611, 17.494644>, <-2.113225, -7.019739, 11.908740>, <-1.663225, -7.519630, 11.858848>, <0.646000, -7.565537, 17.627764>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <-0.094069, -2.022259, 9.039759>, <0.550000, -1.990903, 9.039759>, <2.985890, -3.297577, 8.811089>, <2.666233, -1.142998, 9.789440>, 
        <-0.094069, -1.793589, 9.463535>, <0.550000, -1.762233, 9.463535>, <2.985890, -3.068907, 9.234865>, <2.238380, -1.367472, 10.429335>, 
        <-0.094069, -1.793589, 9.963535>, <0.550000, -1.762233, 9.963535>, <2.985890, -3.068907, 9.734865>, <2.238380, -1.045043, 13.723717>, 
        <0.646000, -7.565537, 17.627764>, <2.955224, -7.611443, 23.396680>, <3.405224, -7.111552, 23.446571>, <3.419388, -6.531537, 23.471705>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <2.666233, -1.142998, 9.789440>, <2.346575, 1.011582, 10.767791>, <2.339321, 1.297959, 10.767791>, <0.102134, 1.297959, 10.721537>, 
        <2.238380, -1.367472, 10.429335>, <1.490870, 0.333964, 11.623804>, <1.483616, 0.620341, 11.623804>, <0.125261, 0.620341, 11.623804>, 
        <2.238380, -1.045043, 13.723717>, <1.490870, 0.978822, 17.712569>, <1.483616, 1.265198, 17.712569>, <0.009625, 1.265198, 17.712569>, 
        <3.419388, -6.531537, 23.471705>, <3.433552, -5.951521, 23.496838>, <3.426297, -6.022078, 23.574805>, <0.308717, -6.053434, 23.366661>
      }
    }
    object {
      bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
        <0.102134, 1.297959, 10.721537>, <-2.135054, 1.297959, 10.675282>, <-2.142308, 0.992332, 10.675282>, <-1.665223, -0.305642, 9.743186>, 
        <0.125261, 0.620341, 11.623804>, <-1.233095, 0.620341, 11.623804>, <-1.240349, 0.314714, 11.623804>, <-1.214244, -0.530116, 10.429335>, 
        <0.009625, 1.265198, 17.712569>, <-1.464367, 1.265198, 17.712569>, <-1.471621, 0.959572, 17.712569>, <-1.329880, -0.207687, 13.723717>, 
        <0.308717, -6.053434, 23.366661>, <-2.808863, -6.084791, 23.158517>, <-2.816117, -6.033484, 23.080549>, <-2.464671, -6.526611, 17.494644>
      }
    }
    rotate -180.0*z
    texture{
      Cavetexture
      scale 0.5
      normal { bumps 25 scale 0.5 }
    }
  }
}

#declare Tentacle = object{ // tentacle
  #declare Smoothness = 200;
  #declare Smoothness = (1 / Smoothness);
  #declare Count = 0;
  #declare BaseRadius = 0.45;
  union{
    #while (Count < 0.98)
      #declare spline_clock = Count;
      #include "cthulu.spl"
      #declare CurPoint = spline_pos;
      #ifdef (PrevPoint)      
        sphere{<0,0,0>, TentacleRadius
          translate(PrevPoint)
        }
      #end
      #declare PrevPoint = CurPoint;
      #declare Count = Count + Smoothness;
      #declare TentacleRadius = BaseRadius - (Count*0.40);
    #end
  }
}
