//          File: sticker.inc * MUST be used with Ray Benjamin's locker.inc
//       Version: 3.1g
//   Description: a sticker to put on the lockers
//       Created: 10/29/1999 
// Last Modified: 10/31/1999 
//        Author: Heather Cousineau, Copyright 1999, all rights reserved.

// The sticker object MUST be declareed AFTER the MakeLockerRow object 
// that contains the locker the sticker will be on and
// BEFORE any other MakeLockerRow objects.
// For the sticker, you must prepaire two TGA images:
//    * The image itself
//    * An image where the parts of the sticker that are visible are white
//       and the parts that are invisible are black.
// 
// In order to rotate the sticker, rotate it in a paint program.

// lockerNum        - Which locker to put the sticker on, goes from left to right
// perUp            - the percent of the height of the locker that the sticker is
//                    at. Goes from bottom to top.
// picForStic       - The TGA image itself          
// picForStickShape - The TGA image where the parts of the sticker that are visible are white
//                    and the parts that are invisible are black.

#macro sticker(lockerNum, perUp, picForStick, picForStickShape)
   #local lockerNum = lockerNum-1;
   #local start = lockerNum*LockerWidth+rowStart;
   #local scaleSticker = (LockerWidth-2*EdgeWidth+MW)*LockerWidth;

   //#local Angle = anglesOpen[lockerNum]; 
   #local Angle = lockerOpenAngle;
   
   object{
      height_field{
        tga picForStickShape
        texture{
          pigment{
            image_map { tga picForStick map_type 0 interpolate 2 once }
            rotate x*90 // lay X-Y image map down onto X-Z height field plane
          }//pigment
        }//texture   
        water_level .99
        scale <scaleSticker,0,scaleSticker>
        translate -.99*y
        rotate <-90,0,0>
      }//height_field
      rotate Angle*y
      translate <EdgeWidth+MW+start,((perUp/100)*LockerHeight),0>
   }//object  
#end